/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.webservice.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDSchema;
import org.teiid.designer.metamodels.webservice.Message;
import org.teiid.designer.metamodels.webservice.Output;
import org.teiid.designer.metamodels.webservice.util.WebServiceComponentFinder;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlRoot;

public class ReferencedXSDSchemaFinder
extends WebServiceComponentFinder {
    private final Set xsds = new HashSet();
    private final Set targetNamespaces = new HashSet();

    public boolean visit(EObject object) {
        if (object instanceof Message) {
            Message msg = (Message)object;
            this.found((XSDComponent)msg.getContentComplexType());
            this.found((XSDComponent)msg.getContentSimpleType());
            this.found((XSDComponent)msg.getContentElement());
            if (msg instanceof Output) {
                this.found(((Output)msg).getXmlDocument());
            }
        }
        return true;
    }

    protected void found(XSDComponent xsdComponent) {
        XSDSchema schema;
        if (xsdComponent != null && (schema = xsdComponent.getSchema()) != null) {
            this.xsds.add(schema);
            String ns = schema.getTargetNamespace();
            if (ns != null && ns.trim().length() != 0) {
                this.targetNamespaces.add(ns);
            }
        }
    }

    protected void found(XmlDocument xmlDocument) {
        XmlRoot root;
        if (xmlDocument != null && (root = xmlDocument.getRoot()) != null) {
            this.found(root.getXsdComponent());
        }
    }

    public Set getXsdSchemas() {
        return this.xsds;
    }

    public Set getXsdTargetNamespaces() {
        return this.targetNamespaces;
    }
}

