/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.ClosedProjectFilter;
import org.teiid.designer.ui.common.viewsupport.DotProjectFilter;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceTreeProvider;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.ui.wizards.IStructuralCopyTreePopulator;
import org.teiid.designer.ui.wizards.StructuralCopyModelFeaturePopulator;

public class TreeViewerWizardPanel
extends Composite
implements UiConstants {
    private static final String BROWSE_SHORTHAND = "...";
    private static final int FILE_NAME_TEXT_WIDTH = (int)((double)Display.getCurrent().getBounds().width * 0.25);
    private static final String SELECT_MODEL_TITLE = Util.getString("StructuralCopyWizardPage.selectModelTitle", new Object[0]);
    private static final String SELECT_MODEL_MSG = Util.getString("StructuralCopyWizardPage.selectModelMsg", new Object[0]);
    private static final String COPY_ALL_DESCRIPTIONS = Util.getString("StructuralCopyWizardPage.copyAllDescriptions", new Object[0]);
    private static final String GENERATE_DEFAULT_SQL = Util.getString("StructuralCopyWizardPage.generateDefaultSQL", new Object[0]);
    private WizardPage wizardPage;
    private Text fileNameText;
    private Button browseButton;
    private Button copyAllDescriptions;
    private Button generateDefaultSQLCheckBox;
    private IStructuralCopyTreePopulator populator = null;
    private Tree tree;
    private TreeViewer treeViewer;
    private MetamodelDescriptor metamodelDescriptor;
    private ModelResource selectorDialogResult = null;
    protected boolean sourceIsPhysical;
    protected boolean targetIsVirtual;
    protected boolean isTransform;
    private boolean firstTimeVisible = true;
    private boolean copyEntire;

    public TreeViewerWizardPanel(Composite parent, WizardPage wizardPage, MetamodelDescriptor metamodelDescriptor, ModelResource selection, boolean sourceIsPhysical, boolean targetIsVirtual, boolean isTransform) {
        super(parent, 0);
        this.wizardPage = wizardPage;
        this.metamodelDescriptor = metamodelDescriptor;
        this.selectorDialogResult = selection;
        this.sourceIsPhysical = sourceIsPhysical;
        this.targetIsVirtual = targetIsVirtual;
        this.isTransform = isTransform;
        this.initialize();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public IStructuralCopyTreePopulator getTreePopulator() {
        return this.populator;
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        Composite fileComposite = new Composite((Composite)this, 0);
        GridLayout fileCompositeLayout = new GridLayout();
        fileComposite.setLayout((Layout)fileCompositeLayout);
        fileCompositeLayout.numColumns = 3;
        fileCompositeLayout.marginWidth = 0;
        GridData fileCompositeGridData = new GridData(768);
        fileComposite.setLayoutData((Object)fileCompositeGridData);
        Label schemaNameLabel = new Label(fileComposite, 0);
        schemaNameLabel.setText(Util.getString("StructuralCopyWizardPage.existingModelLabel", new Object[0]));
        this.fileNameText = WidgetFactory.createTextField((Composite)fileComposite, (int)256);
        this.fileNameText.setEditable(false);
        GridData fileNameTextGridData = new GridData();
        fileNameTextGridData.widthHint = FILE_NAME_TEXT_WIDTH;
        this.fileNameText.setLayoutData((Object)fileNameTextGridData);
        this.browseButton = new Button(fileComposite, 8);
        this.browseButton.setText(BROWSE_SHORTHAND);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                TreeViewerWizardPanel.this.browseButtonClicked();
            }
        });
        Group treeGroup = new Group((Composite)this, 0);
        treeGroup.setText(Util.getString("TreeViewerWizardPanel.modelContentsLabel", new Object[0]));
        GridLayout treeGroupLayout = new GridLayout();
        treeGroup.setLayout((Layout)treeGroupLayout);
        GridData treeGroupGridData = new GridData(1808);
        treeGroup.setLayoutData((Object)treeGroupGridData);
        this.tree = new Tree((Composite)treeGroup, 2816);
        GridData treeGridData = new GridData(4, 4, true, true);
        this.tree.setLayoutData((Object)treeGridData);
        this.treeViewer = new TreeViewer(this.tree);
        this.setCopyEntireModel(true);
        this.addOptions(this);
    }

    protected void addOptions(Composite parent) {
        if (!this.targetIsVirtual || !this.isTransform) {
            this.copyAllDescriptions = new Button((Composite)this, 32);
            this.copyAllDescriptions.setSelection(true);
            this.copyAllDescriptions.setLayoutData((Object)new GridData(4, 4, false, false));
            this.copyAllDescriptions.setText(COPY_ALL_DESCRIPTIONS);
        }
        if (this.targetIsVirtual) {
            this.generateDefaultSQLCheckBox = new Button((Composite)this, 32);
            this.generateDefaultSQLCheckBox.setSelection(false);
            this.generateDefaultSQLCheckBox.setLayoutData((Object)new GridData(4, 4, false, false));
            this.generateDefaultSQLCheckBox.setText(GENERATE_DEFAULT_SQL);
        }
    }

    public boolean isCopyEntireModel() {
        return this.copyEntire;
    }

    public boolean isCopyAllDescriptions() {
        if (this.copyAllDescriptions != null) {
            return this.copyAllDescriptions.getSelection();
        }
        return false;
    }

    public boolean doGenerateDefaultSQL() {
        if (this.generateDefaultSQLCheckBox != null) {
            this.generateDefaultSQLCheckBox.getSelection();
        }
        return false;
    }

    public void setVisible(boolean theVisible) {
        super.setVisible(theVisible);
        if (theVisible && this.firstTimeVisible && this.selectorDialogResult != null) {
            this.firstTimeVisible = false;
            IFile file = (IFile)this.selectorDialogResult.getResource();
            this.fileNameText.setText(file.getProjectRelativePath().toString());
            this.populator = this.getFeaturePopulator(file);
            this.populator.populateModelFeaturesTree(this.treeViewer, this.selectorDialogResult, this.targetIsVirtual);
        }
    }

    void browseButtonClicked() {
        IStructuralCopyTreePopulator thePopulator = this.displaySelectorDialog();
        if (thePopulator != null) {
            this.populator = thePopulator;
            this.populator.populateModelFeaturesTree(this.treeViewer, this.selectorDialogResult, this.targetIsVirtual);
            this.setCopyEntireModel(this.isCopyEntireModel());
            if (this.selectorDialogResult != null) {
                this.wizardPage.setPageComplete(true);
                this.wizardPage.setErrorMessage(null);
            }
        }
        this.warnIfUnsupportedModelInfo(this.selectorDialogResult);
    }

    private IStructuralCopyTreePopulator displaySelectorDialog() {
        Object[] selection;
        StructuralCopyModelFeaturePopulator result = null;
        this.selectorDialogResult = null;
        ModelWorkspaceTreeProvider provider = new ModelWorkspaceTreeProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)provider, (ITreeContentProvider)provider);
        dialog.setInput((Object)ModelerCore.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.addFilter((ViewerFilter)new ClosedProjectFilter());
        dialog.addFilter((ViewerFilter)new DotProjectFilter());
        dialog.addFilter((ViewerFilter)new ModelingResourceFilter());
        dialog.setValidator((ISelectionStatusValidator)new ModelResourceSelectionValidator(this.metamodelDescriptor, false));
        dialog.setTitle(SELECT_MODEL_TITLE);
        dialog.setMessage(SELECT_MODEL_MSG);
        if (dialog.open() == 0 && (selection = dialog.getResult()).length == 1 && selection[0] instanceof IFile) {
            IFile sourceFile = (IFile)selection[0];
            result = this.getFeaturePopulator(sourceFile);
            this.selectorDialogResult = null;
            this.fileNameText.setText("");
            boolean exceptionOccurred = false;
            try {
                this.selectorDialogResult = ModelUtil.getModelResource((IFile)sourceFile, (boolean)true);
            }
            catch (Exception ex) {
                Util.log((Throwable)ex);
                exceptionOccurred = true;
            }
            if (!exceptionOccurred) {
                this.fileNameText.setText(sourceFile.getName());
            }
        }
        return result;
    }

    protected StructuralCopyModelFeaturePopulator getFeaturePopulator(IFile sourceFile) {
        return new StructuralCopyModelFeaturePopulator(sourceFile);
    }

    void setCopyEntireModel(boolean copyEntireModel) {
        this.copyEntire = copyEntireModel;
    }

    public void warnIfUnsupportedModelInfo(ModelResource mr) {
        ModelUtilities.warnIfUnsupportedModelInfoWontBeCopied(mr);
    }

    public void setMetamodelDescriptor(MetamodelDescriptor metamodelDescriptor) {
        this.metamodelDescriptor = metamodelDescriptor;
    }

    public void setSourceIsPhysical(boolean sourceIsPhysical) {
        this.sourceIsPhysical = sourceIsPhysical;
    }

    public void setTargetIsVirtual(boolean targetIsVirtual) {
        this.targetIsVirtual = targetIsVirtual;
    }
}

