/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.wizard.AbstractSelectionWizard;
import org.teiid.designer.ui.product.IModelerProductContexts;
import org.teiid.designer.ui.wizards.SingleColumnTableViewerSorter;

public final class ImportWizard
extends AbstractSelectionWizard
implements UiConstants,
UiConstants.ExtensionPoints.ImportWizards {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ImportWizard.class);
    private static final String TITLE = ImportWizard.getString("title");

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public ImportWizard(IWorkbench workbench, IStructuredSelection selection) {
        super((AbstractUIPlugin)UiPlugin.getDefault(), workbench, selection, TITLE, WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_IMPORT_WIZ"), "org.eclipse.ui.importWizards", (ViewerSorter)new SingleColumnTableViewerSorter());
    }

    protected IConfigurationElement[] getConfigurationElementsFor() {
        IConfigurationElement[] elements = super.getConfigurationElementsFor();
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            String contribID = elements[i].getAttribute("id");
            if (UiPlugin.getDefault().isProductContextValueSupported(IModelerProductContexts.Contributions.IMPORT, contribID)) {
                result.add(elements[i]);
            }
            ++i;
        }
        return result.toArray(new IConfigurationElement[result.size()]);
    }

    protected IWizard createSelectedWizard(IConfigurationElement element) {
        try {
            return (IWizard)element.createExecutableExtension("class");
        }
        catch (CoreException err) {
            Util.log((Throwable)err);
            WidgetUtil.showError((Throwable)err);
            return null;
        }
    }

    protected String getSelectedWizardIcon(IConfigurationElement element) {
        return element.getAttribute("icon");
    }

    protected String getSelectedWizardName(IConfigurationElement element) {
        return element.getAttribute("name");
    }

    protected void initializeSelectedWizard(IWizard wizard, IWorkbench workbench, IStructuredSelection selection) {
        ((IImportWizard)wizard).init(workbench, selection);
    }
}

