/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiConstants;

public class FolderUtil {
    public static final String THIS_CLASS = "FolderUtil";

    private static String getString(String key) {
        return UiConstants.Util.getString("FolderUtil." + key, new Object[0]);
    }

    private static String getString(String key, String parameter) {
        return UiConstants.Util.getString("FolderUtil." + key, (Object)parameter);
    }

    public static void createFolder(final Shell shell, IProject project, String name) {
        IPath containerPath = project.getFullPath();
        IPath newFolderPath = containerPath.append(name);
        final IFolder newFolderHandle = ModelerCore.getWorkspace().getRoot().getFolder(newFolderPath);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateFolderOperation op = new CreateFolderOperation(newFolderHandle, null, false, null, FolderUtil.getString("errorCreatingNewFolderTitle"));
                try {
                    op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)shell));
                }
                catch (ExecutionException e) {
                    shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)shell, (String)FolderUtil.getString("internalErrorCreatingNewFolderTitle"), null, (IStatus)((CoreException)e.getCause()).getStatus());
                            } else {
                                UiConstants.Util.log(4, (Throwable)e, e.getCause().getMessage());
                                MessageDialog.openError((Shell)shell, (String)FolderUtil.getString("internalErrorCreatingNewFolderTitle"), (String)UiConstants.Util.getString("internalErrorMsg", (Object)e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            UiConstants.Util.log(4, (Throwable)e, e.getTargetException().getMessage());
            MessageDialog.open((int)1, (Shell)shell, (String)FolderUtil.getString("internalErrorCreatingNewFolderTitle"), (String)FolderUtil.getString("internalErrorMsg", e.getTargetException().getMessage()), (int)0x10000000);
        }
    }
}

