/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorage;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceFilter;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceSelectionFilter;
import org.teiid.designer.core.workspace.ModelWorkspaceSelections;
import org.teiid.designer.core.workspace.ModelWorkspaceView;
import org.teiid.designer.core.xslt.Style;
import org.teiid.designer.core.xslt.StyleRegistry;
import org.teiid.designer.ddl.DdlOptions;
import org.teiid.designer.ddl.DdlPlugin;
import org.teiid.designer.ddl.DdlWriter;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public final class ExportDdlWizard
extends AbstractWizard
implements FileUtils.Constants,
IExportWizard,
InternalUiConstants.Widgets,
PluginConstants.Images,
CoreStringUtil.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ExportDdlWizard.class);
    private static final String TITLE = ExportDdlWizard.getString("title");
    private static final String PAGE_TITLE = ExportDdlWizard.getString("pageTitle");
    private static final String FILE_DIALOG_TITLE = ExportDdlWizard.getString("fileDialogTitle");
    private static final ImageDescriptor IMAGE = UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/exportDdl.gif");
    private static final String METADATA_GROUP = ExportDdlWizard.getString("metadataGroup");
    private static final String OPTIONS_GROUP = ExportDdlWizard.getString("optionsGroup");
    private static final String COMMENT_OPTIONS_GROUP = ExportDdlWizard.getString("commentOptionsGroup");
    private static final String USE_NAMES_IN_SOURCE_CHECKBOX = ExportDdlWizard.getString("useNamesInSourceCheckBox");
    private static final String USE_NATIVE_TYPE_CHECKBOX = ExportDdlWizard.getString("useNativeTypeCheckBox");
    private static final String FILE_GROUP = ExportDdlWizard.getString("fileGroup");
    private static final String FILE_LABEL = ExportDdlWizard.getString("fileLabel");
    private static final String FILE_BUTTON = BROWSE_BUTTON;
    private static final String INITIAL_MESSAGE = ExportDdlWizard.getString("initialMessage");
    private static final String INVALID_SELECTION_INITIAL_MESSAGE = ExportDdlWizard.getString("initialMessageInvalidSelection");
    private static final String NO_SELECTIONS_MESSAGE = ExportDdlWizard.getString("noSelectionsMessage");
    private static final String NO_EXPORT_TO_CHOICE_MESSAGE = ExportDdlWizard.getString("noExportChoiceMessage");
    private static final String NO_FILE_MESSAGE = ExportDdlWizard.getString("noFileMessage");
    private static final String INVALID_FILE_MESSAGE = ExportDdlWizard.getString("invalidFileMessage");
    private static final String EXPORT_ERROR_MESSAGE = ExportDdlWizard.getString("exportErrorMessage");
    private static final String DDL_EXTENSION = String.valueOf(FILE_EXTENSION_SEPARATOR) + "ddl";
    private static Clipboard CLIPBOARD;
    private DdlWriter writer;
    private ModelWorkspaceSelections selections;
    private ModelWorkspaceSelectionFilter selectionFilter;
    private ExportChoice exportChoice;
    private File file;
    private IStatus status;
    private IStructuredSelection selection;
    private WizardPage pg;
    private TreeViewer viewer;
    private Button schemaCheckBox;
    private Button infoCommentsCheckBox;
    private Button tableCommentsCheckBox;
    private Button columnCommentsCheckBox;
    private Button dropStatementsCheckBox;
    private Button useNamesInSourceCheckBox;
    private Button useNativeTypeCheckBox;
    private Button enforceUniqueNamesCheckBox;
    private Combo typeCombo;
    private Combo fileCombo;
    private boolean invalidSelection;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public ExportDdlWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), TITLE, IMAGE);
    }

    private void writeToStream(final OutputStream stream) throws Exception {
        new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        ExportDdlWizard.this.status = ExportDdlWizard.this.writer.write(ExportDdlWizard.this.selections, stream, monitor);
                    }
                    catch (Exception err) {
                        throw new InvocationTargetException(err);
                    }
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        Util.log((Throwable)e);
                    }
                    monitor.done();
                }
            }
        });
        if (!this.status.isOK()) {
            Util.log(this.status);
            WidgetUtil.showError((String)EXPORT_ERROR_MESSAGE);
        }
    }

    private void exportToFile() throws Exception {
        if (this.file == null || this.file.exists() && !WidgetUtil.confirmOverwrite((File)this.file)) {
            return;
        }
        this.writeToStream(new FileOutputStream(this.file));
    }

    private void exportToClipboard() throws Exception {
        if (CLIPBOARD == null || CLIPBOARD.isDisposed()) {
            WidgetUtil.showError((String)EXPORT_ERROR_MESSAGE);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.writeToStream(stream);
        CLIPBOARD.setContents(new Object[]{stream.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void exportToSQLWorkbook() throws Exception {
        String scrap = "";
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.writeToStream(stream);
        SQLEditorConnectionInfo editorConnectionInfo = new SQLEditorConnectionInfo(null, scrap, scrap);
        SQLEditorStorageEditorInput editorStorageEditorInput = new SQLEditorStorageEditorInput(scrap, scrap);
        editorStorageEditorInput.setStorage((IStorage)new SQLEditorStorage(stream.toString()));
        editorStorageEditorInput.setConnectionInfo(SQLFileUtil.getConnectionInfo4Scrapbook((ISQLEditorConnectionInfo)editorConnectionInfo));
        IWorkbenchWindow window = UiUtil.getWorkbenchWindow();
        IEditorReference[] editors = window.getActivePage().getEditorReferences();
        int suffix = 0;
        ArrayList<String> editorNameList = new ArrayList<String>();
        int i = 0;
        while (i < editors.length) {
            editorNameList.add(editors[i].getName());
            ++i;
        }
        while (true) {
            String name;
            if (!editorNameList.contains(name = "SQL Scrapbook" + Integer.toString(suffix))) {
                editorStorageEditorInput.setName(name);
                try {
                    window.getActivePage().openEditor((IEditorInput)editorStorageEditorInput, "org.eclipse.datatools.sqltools.sqlscrapbook.SQLScrapbookEditor");
                }
                catch (PartInitException e) {
                    SqlscrapbookPlugin.log((Throwable)e);
                }
                break;
            }
            ++suffix;
        }
    }

    public boolean finish() {
        try {
            switch (this.exportChoice) {
                case FILE: {
                    this.exportToFile();
                    break;
                }
                case CLIPBOARD: {
                    this.exportToClipboard();
                    break;
                }
                case SQL: {
                    this.exportToSQLWorkbook();
                }
            }
            IDialogSettings settings = this.getDialogSettings();
            settings.put(USE_NAMES_IN_SOURCE_CHECKBOX, this.useNamesInSourceCheckBox.getSelection());
            settings.put(USE_NATIVE_TYPE_CHECKBOX, this.useNativeTypeCheckBox.getSelection());
            WidgetUtil.saveSettings((IDialogSettings)settings, (String)FILE_LABEL, (Combo)this.fileCombo);
            return true;
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            Util.log(err);
            WidgetUtil.showError((String)EXPORT_ERROR_MESSAGE);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (CLIPBOARD == null) {
            CLIPBOARD = new Clipboard(workbench.getDisplay());
        }
        this.invalidSelection = false;
        if (!SelectionUtilities.isSingleSelection((ISelection)selection)) {
            this.invalidSelection = true;
        } else if (!SelectionUtilities.isAllIResourceObjects((ISelection)selection)) {
            this.invalidSelection = true;
        } else {
            IResource iRes;
            Object obj = SelectionUtilities.getSelectedObject((ISelection)selection);
            if (obj instanceof IResource && !ModelIdentifier.isRelationalSourceModel(iRes = (IResource)obj) && !ModelIdentifier.isRelationalViewModel(iRes)) {
                this.invalidSelection = true;
            }
        }
        this.selection = selection;
        this.selections = new ModelWorkspaceSelections();
        this.writer = DdlPlugin.getInstance().createDdlWriter();
        this.pg = new AbstractWizardPage(ExportDdlWizard.class.getSimpleName(), PAGE_TITLE){

            public void createControl(Composite parent) {
                this.setControl((Control)ExportDdlWizard.this.createPageControl(parent));
            }
        };
        this.pg.setPageComplete(false);
        this.addPage((IWizardPage)this.pg);
    }

    private void createExportToSection(Composite pg, IDialogSettings settings) {
        Group exportToGroup = WidgetFactory.createGroup((Composite)pg, (String)FILE_GROUP, (int)768, (int)1, (int)1);
        Composite buttonComposite = new Composite((Composite)exportToGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).applyTo(buttonComposite);
        final Composite exportToFilePanel = new Composite((Composite)exportToGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 50).applyTo((Control)exportToFilePanel);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(exportToFilePanel);
        Button clipboardButton = WidgetFactory.createButton((Composite)buttonComposite, (String)ExportChoice.CLIPBOARD.getLabel(), (int)576, (int)1, (int)16);
        clipboardButton.setToolTipText(ExportDdlWizard.getString("clipboardTooltip"));
        clipboardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDdlWizard.this.exportChoice = ExportChoice.CLIPBOARD;
                ExportDdlWizard.this.validatePage();
                exportToFilePanel.setVisible(false);
            }
        });
        Button fileButton = WidgetFactory.createButton((Composite)buttonComposite, (String)ExportChoice.FILE.getLabel(), (int)576, (int)1, (int)16);
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDdlWizard.this.exportChoice = ExportChoice.FILE;
                ExportDdlWizard.this.validatePage();
                exportToFilePanel.setVisible(true);
            }
        });
        Button sqlButton = WidgetFactory.createButton((Composite)buttonComposite, (String)ExportChoice.SQL.getLabel(), (int)576, (int)1, (int)16);
        sqlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDdlWizard.this.exportChoice = ExportChoice.SQL;
                ExportDdlWizard.this.validatePage();
                exportToFilePanel.setVisible(false);
            }
        });
        WidgetFactory.createLabel((Composite)exportToFilePanel, (String)FILE_LABEL);
        this.fileCombo = WidgetFactory.createCombo((Composite)exportToFilePanel, (int)0, (int)768, (Object[])settings.getArray(FILE_LABEL));
        this.fileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExportDdlWizard.this.fileModified();
            }
        });
        WidgetFactory.createButton((Composite)exportToFilePanel, (String)FILE_BUTTON).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportDdlWizard.this.fileButtonSelected();
            }
        });
        exportToFilePanel.setVisible(false);
    }

    Composite createPageControl(Composite parent) {
        StyleRegistry registry = DdlPlugin.getStyleRegistry();
        registry.getStyles();
        Composite pg = new Composite(parent, 0);
        pg.setLayout((Layout)new GridLayout());
        Group group = WidgetFactory.createGroup((Composite)pg, (String)METADATA_GROUP, (int)1808);
        this.viewer = WidgetFactory.createTreeViewer((Composite)group, (int)34);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        final ModelWorkspaceView view = new ModelWorkspaceView();
        view.getModelWorkspaceFilters().add(new ModelWorkspaceFilter(){

            public boolean select(Object parent, Object node) {
                if (node instanceof ModelResource) {
                    try {
                        MetamodelDescriptor mmdesc = ((ModelResource)node).getPrimaryMetamodelDescriptor();
                        if (mmdesc != null) {
                            String uri = mmdesc.getNamespaceURI();
                            return "http://www.metamatrix.com/metamodels/Relational".equals(uri);
                        }
                    }
                    catch (Throwable err) {
                        Util.log(err);
                    }
                    return false;
                }
                if (node instanceof ModelWorkspaceItem) {
                    return true;
                }
                return node instanceof RelationalEntity && !(node instanceof Procedure) && !(node instanceof Index);
            }
        });
        this.selections.setModelWorkspaceView(view);
        this.selectionFilter = new ModelWorkspaceSelectionFilter(){

            public boolean isSelectable(Object node) {
                if (node instanceof ModelWorkspaceItem) {
                    return true;
                }
                EObject parent = ((RelationalEntity)node).eContainer();
                return !(parent instanceof Table) && !(parent instanceof Procedure) && !(parent instanceof Index);
            }
        };
        this.selections.getModelWorkspaceSelectionFilters().add(this.selectionFilter);
        ITreeContentProvider treeContentProvider = new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object node) {
                try {
                    return view.getChildren(node);
                }
                catch (ModelWorkspaceException err) {
                    Util.log((Throwable)err);
                    return EMPTY_STRING_ARRAY;
                }
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object getParent(Object node) {
                return view.getParent(node);
            }

            public boolean hasChildren(Object node) {
                try {
                    return view.hasChildren(node);
                }
                catch (ModelWorkspaceException err) {
                    Util.log((Throwable)err);
                    return false;
                }
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.viewer.setContentProvider((IContentProvider)treeContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            final ModelExplorerLabelProvider workbenchProvider = new ModelExplorerLabelProvider();

            public Image getImage(Object node) {
                if (node instanceof EObject) {
                    return ModelUtilities.getEMFLabelProvider().getImage(node);
                }
                return this.workbenchProvider.getImage(((ModelWorkspaceItem)node).getResource());
            }

            public String getText(Object node) {
                if (node instanceof EObject) {
                    return ModelUtilities.getEMFLabelProvider().getText(node);
                }
                return this.workbenchProvider.getText(((ModelWorkspaceItem)node).getResource());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ExportDdlWizard.this.nodeDoubleClicked(event);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                ExportDdlWizard.this.mouseClicked(event);
            }
        });
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                ExportDdlWizard.this.nodeExpandedOrCollapsed(event);
            }

            public void treeExpanded(TreeExpansionEvent event) {
                ExportDdlWizard.this.nodeExpanded(event);
            }
        });
        this.viewer.setInput((Object)ModelerCore.getModelWorkspace());
        new LabelProvider(){

            public String getText(Object style) {
                return ((Style)style).getName();
            }
        };
        DdlOptions options = this.writer.getOptions();
        IDialogSettings settings = this.getDialogSettings();
        options.setNameInSourceUsed(settings.getBoolean(USE_NAMES_IN_SOURCE_CHECKBOX));
        options.setNativeTypeUsed(settings.getBoolean(USE_NATIVE_TYPE_CHECKBOX));
        group = WidgetFactory.createGroup((Composite)pg, (String)OPTIONS_GROUP, (int)768, (int)1, (int)2);
        this.useNamesInSourceCheckBox = WidgetFactory.createCheckBox((Composite)group, (String)USE_NAMES_IN_SOURCE_CHECKBOX, (int)0, (int)2, (boolean)options.isNameInSourceUsed());
        this.useNamesInSourceCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportDdlWizard.this.useNamesInSourceCheckBoxSelected();
            }
        });
        this.useNativeTypeCheckBox = WidgetFactory.createCheckBox((Composite)group, (String)USE_NATIVE_TYPE_CHECKBOX, (int)0, (int)2, (boolean)options.isNativeTypeUsed());
        this.useNativeTypeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportDdlWizard.this.useNativeTypeCheckBoxSelected();
            }
        });
        this.createExportToSection(pg, settings);
        if (this.selection != null && !this.invalidSelection) {
            ArrayList<Object> objs = new ArrayList<Object>(this.selection.size());
            for (Object obj : this.selection) {
                IPath path = obj instanceof IResource ? ((IResource)obj).getFullPath() : view.getPath(obj);
                try {
                    objs.add(view.findObject(path));
                }
                catch (ModelWorkspaceException err) {
                    Util.log((Throwable)err);
                    WidgetUtil.showError((Throwable)err);
                }
            }
            if (!objs.isEmpty()) {
                this.viewer.setSelection((ISelection)new StructuredSelection(objs), true);
                TreeItem[] items = this.viewer.getTree().getSelection();
                int ndx = items.length;
                while (--ndx >= 0) {
                    this.toggleSelection(items[ndx]);
                }
            }
            this.pg.setMessage(INITIAL_MESSAGE);
        } else {
            this.pg.setMessage(INVALID_SELECTION_INITIAL_MESSAGE);
        }
        return pg;
    }

    private void infoCommentsCheckBoxSelected() {
        this.writer.getOptions().setGenerateInfoComments(this.infoCommentsCheckBox.getSelection());
    }

    private void tableCommentsCheckBoxSelected() {
        this.writer.getOptions().setGenerateTableComments(this.tableCommentsCheckBox.getSelection());
    }

    private void columnCommentsCheckBoxSelected() {
        this.writer.getOptions().setGenerateColumnComments(this.columnCommentsCheckBox.getSelection());
    }

    private void dropStatementsCheckBoxSelected() {
        this.writer.getOptions().setGenerateDropStatements(this.dropStatementsCheckBox.getSelection());
    }

    private void useNamesInSourceCheckBoxSelected() {
        this.writer.getOptions().setNameInSourceUsed(this.useNamesInSourceCheckBox.getSelection());
    }

    private void useNativeTypeCheckBoxSelected() {
        this.writer.getOptions().setNativeTypeUsed(this.useNativeTypeCheckBox.getSelection());
    }

    private void enforceUniqueNamesCheckBoxSelected() {
        this.writer.getOptions().setUniqueNamesEnforced(this.enforceUniqueNamesCheckBox.getSelection());
    }

    private void fileButtonSelected() {
        FileDialog dlg = new FileDialog(this.getShell(), 8196);
        dlg.setFilterExtensions(new String[]{"*.ddl", "*.sql", "*.*"});
        dlg.setText(FILE_DIALOG_TITLE);
        String file = dlg.open();
        if (file != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(file);
            if (file.indexOf(46) < 0) {
                buffer.append(DDL_EXTENSION);
            }
            this.fileCombo.setText(buffer.toString());
            this.file = new File(file);
        }
        this.validatePage();
    }

    private void fileModified() {
        String file = this.fileCombo.getText();
        if (file != null && file.length() > 0) {
            char lastChr = file.charAt(file.length() - 1);
            if (file.indexOf(FILE_EXTENSION_SEPARATOR) < 0 && lastChr != ':' && lastChr != '\\' && lastChr != '/') {
                file = String.valueOf(file) + DDL_EXTENSION;
            }
            this.file = new File(file);
        }
        this.validatePage();
    }

    private void mouseClicked(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        TreeItem item = this.viewer.getTree().getItem(new Point(event.x, event.y));
        if (item != null) {
            Object node = item.getData();
            this.viewer.setSelection((ISelection)new StructuredSelection(node));
            if (event.x < item.getBounds().x - item.getImage().getBounds().width - 5 && this.selectionFilter.isSelectable(node)) {
                this.toggleSelection(item);
            } else {
                this.updateCheckBox(item);
            }
        }
    }

    private void nodeDoubleClicked(DoubleClickEvent event) {
        Object node;
        this.viewer.setExpandedState(node, !this.viewer.getExpandedState(node = ((IStructuredSelection)event.getSelection()).getFirstElement()));
    }

    private void nodeExpanded(TreeExpansionEvent event) {
        this.nodeExpandedOrCollapsed(event);
        this.updateCheckBoxes(this.viewer.getTree().getSelection()[0].getItems());
    }

    private void nodeExpandedOrCollapsed(TreeExpansionEvent event) {
        this.viewer.setSelection((ISelection)new StructuredSelection(event.getElement()));
    }

    private void schemasCheckBoxSelected() {
        this.writer.getOptions().setGenerateSchema(this.schemaCheckBox.getSelection());
    }

    private void typeModified() {
        Style style = DdlPlugin.getStyleRegistry().getStyle(this.typeCombo.getText());
        this.writer.getOptions().setStyle(style);
        if (style != null) {
            this.typeCombo.setToolTipText(style.getDescription());
        }
        this.validatePage();
    }

    private void toggleSelection(TreeItem item) {
        Object node = item.getData();
        boolean select = this.selections.getSelectionMode(node) != 1;
        try {
            this.selections.setSelected(node, select);
        }
        catch (ModelWorkspaceException err) {
            Util.log((Throwable)err);
        }
        this.updateCheckBox(item);
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            this.updateCheckBox(parent);
            parent = parent.getParentItem();
        }
        this.updateCheckBoxes(item.getItems());
        this.validatePage();
    }

    private void updateCheckBox(TreeItem item) {
        Object node = item.getData();
        if (node == null) {
            return;
        }
        int mode = this.selections.getSelectionMode(node);
        item.setChecked(mode != 0);
        item.setGrayed(mode == 2);
    }

    private void updateCheckBoxes(TreeItem[] items) {
        int ndx = items.length;
        while (--ndx >= 0) {
            TreeItem item = items[ndx];
            this.updateCheckBoxes(item.getItems());
            this.updateCheckBox(item);
        }
    }

    private void validatePage() {
        if (!this.selections.hasSelectionModes()) {
            WizardUtil.setPageComplete((WizardPage)this.pg, (String)NO_SELECTIONS_MESSAGE, (int)3);
        } else if (this.exportChoice == null) {
            WizardUtil.setPageComplete((WizardPage)this.pg, (String)NO_EXPORT_TO_CHOICE_MESSAGE, (int)3);
        } else if (ExportChoice.FILE.equals((Object)this.exportChoice)) {
            if (this.file == null) {
                WizardUtil.setPageComplete((WizardPage)this.pg, (String)NO_FILE_MESSAGE, (int)3);
            } else if (this.file.isDirectory()) {
                WizardUtil.setPageComplete((WizardPage)this.pg, (String)INVALID_FILE_MESSAGE, (int)3);
            } else if (this.file.exists()) {
                WizardUtil.setPageComplete((WizardPage)this.pg, (String)WidgetUtil.getFileExistsMessage((File)this.file), (int)2);
            } else {
                WizardUtil.setPageComplete((WizardPage)this.pg);
            }
        } else {
            WizardUtil.setPageComplete((WizardPage)this.pg);
        }
    }

    static /* synthetic */ String access$0(String string) {
        return ExportDdlWizard.getString(string);
    }

    private static enum ExportChoice {
        CLIPBOARD(ExportDdlWizard.access$0("clipboardChoiceLabel")),
        FILE(ExportDdlWizard.access$0("fileChoiceLabel")),
        SQL(ExportDdlWizard.access$0("sqlChoiceLabel"));

        private final String label;

        private ExportChoice(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

