/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.ui.UiPlugin;

public class TranslatorPropertyLabelProvider
extends ColumnLabelProvider {
    private final boolean nameColumn;

    public TranslatorPropertyLabelProvider(boolean nameColumn) {
        this.nameColumn = nameColumn;
    }

    public Image getImage(Object element) {
        TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
        String overridenValue = property.getOverriddenValue();
        Image image = null;
        if (!this.nameColumn) {
            if (property.getDefinition().isValidValue(overridenValue) == null) {
                if (!(!property.hasOverridenValue() || property.isCustom() && property.getDefinition().getDefaultValue().equals(overridenValue))) {
                    image = UiPlugin.getDefault().getImage("icons/full/ctool16/restore-default-value.png");
                }
            } else {
                image = UiPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
        }
        return image;
    }

    public String getText(Object element) {
        TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
        if (this.nameColumn) {
            return property.getDefinition().getDisplayName();
        }
        boolean masked = property.getDefinition().isMasked();
        if (property.hasOverridenValue()) {
            return masked ? "*****" : property.getOverriddenValue();
        }
        return masked ? "*****" : property.getDefinition().getDefaultValue();
    }

    public String getToolTipText(Object element) {
        TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
        if (this.nameColumn) {
            return property.getDefinition().getDescription();
        }
        if (!(!property.hasOverridenValue() || property.isCustom() && property.getDefinition().getDefaultValue().equals(property.getOverriddenValue()))) {
            return property.getDefinition().isValidValue(property.getOverriddenValue());
        }
        return "Using default value";
    }
}

