/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.OSPlatformUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelProjectImpl;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.dialog.FileUiUtils;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;

public class NewModelProjectWorker {
    private static final String[] MODEL_NATURES = new String[]{"org.teiid.designer.core.modelNature"};

    public IProject createNewProject(IPath newPath, String name, IProgressMonitor monitor) {
        IProject newProject = ModelerCore.getWorkspace().getRoot().getProject(name);
        IWorkspace workspace = ModelerCore.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(newProject.getName());
        description.setLocation(newPath);
        try {
            boolean doit = false;
            if (!newProject.exists()) {
                if (newPath != null && OSPlatformUtil.isWindows()) {
                    Path path = new Path(FileUiUtils.INSTANCE.getExistingCaseVariantFileName(newPath));
                    newProject = ModelerCore.getWorkspace().getRoot().getProject(path.lastSegment());
                    description.setLocation((IPath)path);
                    doit = !newProject.exists();
                } else {
                    doit = true;
                }
                if (doit) {
                    this.createProject(description, newProject, monitor);
                }
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 275) {
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)newProject.getName()));
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, null, (IStatus)e.getStatus());
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        this.configureProject(newProject);
        return newProject;
    }

    private void configureProject(IProject newProject) {
        try {
            String productName;
            IProjectDescription desc = newProject.getDescription();
            desc.setNatureIds(new String[0]);
            newProject.setDescription(desc, null);
            desc.setNatureIds(MODEL_NATURES);
            if (ProductCustomizerMgr.getInstance() != null && !CoreStringUtil.isEmpty((String)(productName = ProductCustomizerMgr.getInstance().getProductName()))) {
                desc.setComment(String.valueOf(productName) + ", version " + ModelerCore.ILicense.VERSION);
            }
            newProject.setDescription(desc, null);
            if (!ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
                newProject.close(null);
            }
            newProject.open(null);
        }
        catch (CoreException err) {
            UiConstants.Util.log(4, (Throwable)err, err.getMessage());
        }
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        projectHandle.open(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        ModelWorkspace mWorkspace = ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace();
        ModelProjectImpl mProject = new ModelProjectImpl(projectHandle, (ModelWorkspaceItem)mWorkspace);
        ArrayList iResources = new ArrayList();
        this.addMembersToList((IContainer)projectHandle, iResources);
        for (IResource iResource : iResources) {
            ModelWorkspaceManager.create((IResource)iResource, (ModelProject)mProject);
        }
    }

    private void addMembersToList(IContainer iContainer, List iResources) throws CoreException {
        if (iContainer != null) {
            IResource[] members = iContainer.members();
            int i = 0;
            while (i != members.length) {
                IResource member = members[i];
                if (!iResources.contains(member)) {
                    iResources.add(member);
                }
                if (member instanceof IContainer) {
                    this.addMembersToList((IContainer)member, iResources);
                }
                ++i;
            }
        }
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }
}

