/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.EObjectSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.ui.viewsupport.PropertiesDialog;

public class ModelWorkspaceDialog
extends ElementTreeSelectionDialog
implements ISelectionChangedListener {
    private static final String DEFAULT_TITLE = UiConstants.Util.getString("ModelWorkspaceDialog.title", new Object[0]);
    private static final String PROPERTIES_BUTTON_TEXT = UiConstants.Util.getString("ModelWorkspaceDialog.propertiesButton.text", new Object[0]);
    private IWorkspaceRoot root;
    private Button btnProperties;
    private int PROPERTIES_BUTTON_ID = 10234;
    EObject selectedEObject;
    private boolean bShowPropertiesButton = true;

    public ModelWorkspaceDialog(Shell parent) {
        this(parent, DEFAULT_TITLE, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
    }

    public ModelWorkspaceDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        this(parent, null, labelProvider, contentProvider);
    }

    public ModelWorkspaceDialog(Shell parent, String title, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.init(title);
    }

    protected void init(String title) {
        this.addFilter((ViewerFilter)new ModelingResourceFilter());
        if (title == null) {
            this.setTitle(DEFAULT_TITLE);
        } else {
            this.setTitle(title);
        }
        super.setValidator((ISelectionStatusValidator)new EObjectSelectionValidator());
        if (this.root != null) {
            this.setInput(this.root);
        } else {
            this.setInput(ModelerCore.getWorkspace().getRoot());
        }
    }

    public void addViewerFilter(ViewerFilter filter) {
        super.getTreeViewer().addFilter(filter);
    }

    public void setValidator(ISelectionStatusValidator validator) {
        super.setValidator(validator);
    }

    public void setShowPropertiesButton(boolean b) {
        this.bShowPropertiesButton = b;
        this.btnProperties.setVisible(this.bShowPropertiesButton);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer result = super.createTreeViewer(parent);
        result.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).isOpen();
                }
                return true;
            }
        });
        result.expandToLevel(2);
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnProperties = this.createButton(parent, this.PROPERTIES_BUTTON_ID, PROPERTIES_BUTTON_TEXT, false);
        super.createButtonsForButtonBar(parent);
        this.btnProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PropertiesDialog dlg = new PropertiesDialog(ModelWorkspaceDialog.this.selectedEObject, null);
                dlg.open();
            }
        });
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)this.getTreeViewer().getSelection();
        if (sel.getFirstElement() instanceof EObject) {
            this.selectedEObject = (EObject)sel.getFirstElement();
            this.btnProperties.setEnabled(true);
        } else {
            this.selectedEObject = null;
            this.btnProperties.setEnabled(false);
        }
    }
}

