/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.ResourceNameUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.search.runtime.ResourceImportRecord;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.metamodels.relational.extension.CoreModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.CoreModelExtensionConstants;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.editors.OpenEditorMap;
import org.teiid.designer.ui.properties.ModelObjectAdapterFactoryContentProvider;
import org.teiid.designer.ui.properties.ModelObjectPropertySourceProvider;
import org.teiid.designer.ui.util.DiagramProxy;
import org.teiid.designer.ui.viewsupport.MarkerUtilities;
import org.teiid.designer.ui.viewsupport.ModelFileCache;
import org.teiid.designer.ui.viewsupport.ModelObjectLabelProvider;

public abstract class ModelUtilities
implements UiConstants {
    private static Container workspaceContainer;
    private static AdapterFactoryContentProvider emfContentProvider;
    private static ModelObjectAdapterFactoryContentProvider modelContentProvider;
    private static AdapterFactoryLabelProvider emfLabelProvider;
    private static AdapterFactoryItemDelegator emfItemDelegator;
    private static ModelObjectPropertySourceProvider propertySourceProvider;
    private static ILabelProvider labelProvider;
    private static ModelFileCache modelFileCache;
    public static final String MODEL_FILE_EXTENSION = "xmi";
    public static final String VDB_FILE_EXTENSION = "vdb";
    public static final String XSD_FILE_EXTENSION = "xsd";
    public static final String MED_FILE_EXTENSION = "mxd";
    public static final String DOT_MODEL_FILE_EXTENSION = ".xmi";
    public static final String DOT_VDB_FILE_EXTENSION = ".vdb";
    public static final String DOT_XSD_FILE_EXTENSION = ".xsd";
    private static final String I18N_PREFIX;
    private static final String FILE_DOES_NOT_EXIST_TITLE;
    private static final String FILE_DOES_NOT_EXIST_MSG_KEY = "fileDoesNotExist.message";
    private static final String CLOSED_PROJECT_TITLE;
    private static final String CLOSED_PROJECT_MSG_KEY = "projectClosed.message";
    private static final String MODEL_CHANGES_PENDING_TITLE;
    private static final String MODEL_CHANGES_PENDING_MSG_KEY = "modelChangesPending.message";
    private static final String MODEL_ERRORS_TITLE;
    private static final String MODEL_ERRORS_MSG_KEY = "modelHasErrors.message";
    private static final String MODEL_NOT_VALIDATED_TITLE;
    private static final String MODEL_NOT_VALIDATED_MSG_KEY = "modelNotValidated.message";
    private static final String MODEL_RESOURCE_NOT_FOUND_MSG_KEY = "modelResourceNotFound.message";
    private static final String MODEL_IMPORTED_NOT_FOUND_TITLE;
    private static final String MODEL_IMPORTED_NOT_FOUND_MSG_KEY = "modelHasMissingImports.message";
    private static final String MODEL_IMPORTED_PROBLEM_MSG_KEY = "importedError";

    static {
        modelFileCache = new ModelFileCache();
        I18N_PREFIX = I18nUtil.getPropertyPrefix(ModelUtilities.class);
        FILE_DOES_NOT_EXIST_TITLE = ModelUtilities.getString("fileDoesNotExist.title");
        CLOSED_PROJECT_TITLE = ModelUtilities.getString("projectClosed.title");
        MODEL_CHANGES_PENDING_TITLE = ModelUtilities.getString("modelChangesPending.title");
        MODEL_ERRORS_TITLE = ModelUtilities.getString("modelHasErrors.title");
        MODEL_NOT_VALIDATED_TITLE = ModelUtilities.getString("modelNotValidated.title");
        MODEL_IMPORTED_NOT_FOUND_TITLE = ModelUtilities.getString("modelHasMissingImports.title");
    }

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, String arg) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, (Object)arg);
    }

    public static ITreeContentProvider getModelContentProvider() {
        if (modelContentProvider == null) {
            AdapterFactory factory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
            modelContentProvider = new ModelObjectAdapterFactoryContentProvider(factory);
        }
        return modelContentProvider;
    }

    public static AdapterFactoryContentProvider getEmfAdapterFactoryContentProvider() {
        if (emfContentProvider == null) {
            AdapterFactory factory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
            emfContentProvider = new AdapterFactoryContentProvider(factory);
        }
        return emfContentProvider;
    }

    public static AdapterFactoryItemDelegator getEMFItemDelegator() {
        if (emfItemDelegator == null) {
            AdapterFactory factory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
            emfItemDelegator = new AdapterFactoryItemDelegator(factory);
        }
        return emfItemDelegator;
    }

    public static AdapterFactoryLabelProvider getAdapterFactoryLabelProvider() {
        if (emfLabelProvider == null) {
            AdapterFactory factory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
            emfLabelProvider = new AdapterFactoryLabelProvider(factory);
        }
        return emfLabelProvider;
    }

    public static ILabelProvider getEMFLabelProvider() {
        if (labelProvider == null) {
            labelProvider = new ModelObjectLabelProvider();
        }
        return labelProvider;
    }

    public static ModelObjectLabelProvider getModelObjectLabelProvider() {
        if (labelProvider == null) {
            labelProvider = new ModelObjectLabelProvider();
        }
        return (ModelObjectLabelProvider)labelProvider;
    }

    public static IPropertySourceProvider getEmfPropertySourceProvider() {
        if (modelContentProvider == null) {
            AdapterFactory factory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
            modelContentProvider = new ModelObjectAdapterFactoryContentProvider(factory);
        }
        return modelContentProvider;
    }

    public static boolean isModelFile(IResource resource) {
        return modelFileCache.isModelFile(resource);
    }

    public static boolean isModelingRelatedFile(IResource theResource) {
        CoreArgCheck.isNotNull((Object)theResource);
        return theResource instanceof IFile && (ModelUtilities.isModelFile(theResource) || ModelUtilities.isVdbFile(theResource) || ModelUtilities.isWsdlFile(theResource));
    }

    public static boolean isVdbFile(IResource resource) {
        String ext;
        boolean result = false;
        if (resource instanceof IFile && (ext = ((IFile)resource).getFileExtension()) != null && ext.equals(VDB_FILE_EXTENSION)) {
            result = true;
        }
        return result;
    }

    public static boolean isWsdlFile(IResource theResource) {
        String ext;
        boolean result = false;
        if (theResource instanceof IFile && (ext = ((IFile)theResource).getFileExtension()) != null && ext.equalsIgnoreCase("wsdl")) {
            result = true;
        }
        return result;
    }

    public static boolean isWsdlFile(File theFile) {
        String name = theFile.getName();
        return name.toLowerCase().endsWith(".wsdl");
    }

    public static boolean isMedFile(IResource resource) {
        String ext;
        boolean result = false;
        if (resource instanceof IFile && (ext = ((IFile)resource).getFileExtension()) != null && ext.equals(MED_FILE_EXTENSION)) {
            result = true;
        }
        return result;
    }

    public static boolean isModelProjectResource(IResource resource) {
        IProject proj;
        return resource != null && (proj = resource.getProject()) != null && ModelerCore.hasModelNature((IProject)proj);
    }

    public static boolean isAllModelProjectMembers(ISelection selection) {
        if (SelectionUtilities.isEmptySelection((ISelection)selection) || !(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IResource && !ModelUtilities.isModelProjectResource((IResource)obj)) {
                return false;
            }
            if (obj instanceof EObject && ModelUtilities.getModelResourceForModelObject((EObject)obj) == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static IFile getModelFile(String containerPath, String modelName) throws ModelWorkspaceException {
        ModelWorkspaceItem item;
        if (containerPath == null || modelName == null) {
            return null;
        }
        IPath modelPath = new Path(containerPath).append(modelName);
        if (!modelPath.toString().toLowerCase().endsWith(DOT_MODEL_FILE_EXTENSION)) {
            modelPath = modelPath.addFileExtension(MODEL_FILE_EXTENSION);
        }
        if ((item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)) != null) {
            return (IFile)item.getCorrespondingResource();
        }
        return null;
    }

    public static ModelResource getModelResource(Resource resource, boolean forceOpen) {
        if (resource == null) {
            return null;
        }
        return ModelerCore.getModelEditor().findModelResource(resource);
    }

    public static ModelResource getModelResourceForIFile(IFile modelFile, boolean forceOpen) {
        if (modelFile == null) {
            return null;
        }
        ModelResource mr = null;
        try {
            mr = ModelUtil.getModelResource((IFile)modelFile, (boolean)forceOpen);
        }
        catch (ModelWorkspaceException err1) {
            String message = UiConstants.Util.getString("ModelUtilities.errorFindingModelResource", (Object)modelFile);
            UiConstants.Util.log(4, (Throwable)err1, message);
        }
        return mr;
    }

    public static ModelResource getModelResourceForModelObject(EObject modelObject) {
        if (modelObject == null) {
            return null;
        }
        if (modelObject instanceof DiagramProxy) {
            ModelResource modelResource = ((DiagramProxy)modelObject).getModelResource();
            if (modelResource != null) {
                return modelResource;
            }
            return ModelerCore.getModelEditor().findModelResource(((DiagramProxy)modelObject).getTarget());
        }
        return ModelerCore.getModelEditor().findModelResource(modelObject);
    }

    public static ModelResource getModelResource(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ModelResource) {
            return (ModelResource)object;
        }
        if (object instanceof IFile) {
            return ModelUtilities.getModelResourceForIFile((IFile)object, true);
        }
        if (object instanceof EObject) {
            return ModelUtilities.getModelResourceForModelObject((EObject)object);
        }
        if (object instanceof Resource) {
            ModelResource mr = null;
            mr = ModelUtilities.getModelResource((Resource)object, true);
            return mr;
        }
        return null;
    }

    public static IProject getProject(Object object) {
        ModelResource mr = ModelUtilities.getModelResource(object);
        try {
            return mr.getCorrespondingResource().getProject();
        }
        catch (ModelWorkspaceException ex) {
            String message = "[ModelUtilities.getProject()] ERROR: exception finding project";
            UiConstants.Util.log(4, (Throwable)ex, message);
            return null;
        }
    }

    public static String getModelName(EObject modelObject) {
        try {
            return ModelUtilities.getModelResource(modelObject).getCorrespondingResource().getName();
        }
        catch (Exception ex) {
            String message = "[ModelUtilities.getModelName()] ERROR: exception finding model name";
            UiConstants.Util.log(4, (Throwable)ex, message);
            return null;
        }
    }

    public static Container getWorkspaceContainer() throws CoreException {
        if (workspaceContainer == null) {
            workspaceContainer = ModelerCore.getModelContainer();
        }
        return workspaceContainer;
    }

    public static boolean isModelInWorkspace(String theUuid) throws CoreException, ModelWorkspaceException {
        if (theUuid == null || theUuid.length() == 0) {
            return false;
        }
        boolean result = false;
        IWorkspace workspace = ModelerCore.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        if (projects != null && projects.length > 0) {
            int i = 0;
            block0: while (i < projects.length) {
                IResource[] resources = projects[i].members();
                if (resources != null && resources.length > 0) {
                    int j = 0;
                    while (j < resources.length) {
                        ModelResource modelResource;
                        String uuid;
                        if (ModelUtilities.isModelFile(resources[j]) && (uuid = (modelResource = ModelUtil.getModelResource((IFile)((IFile)resources[j]), (boolean)false)).getUuid()) != null && uuid.equals(theUuid)) {
                            result = true;
                            break block0;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public static void addNotifyChangedListener(INotifyChangedListener listener) {
        try {
            Container workspaceContainer = ModelUtilities.getWorkspaceContainer();
            if (workspaceContainer == null) {
                return;
            }
            ChangeNotifier changeNotifier = workspaceContainer.getChangeNotifier();
            if (changeNotifier == null) {
                return;
            }
            if (changeNotifier.contains((Object)listener)) {
                return;
            }
            changeNotifier.addListener(listener);
        }
        catch (CoreException e) {
            e.printStackTrace(System.err);
        }
    }

    public static void removeNotifyChangedListener(INotifyChangedListener listener) {
        try {
            ModelUtilities.getWorkspaceContainer().getChangeNotifier().removeListener(listener);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static ModelObjectPropertySourceProvider getPropertySourceProvider() {
        if (propertySourceProvider == null) {
            propertySourceProvider = new ModelObjectPropertySourceProvider();
        }
        return propertySourceProvider;
    }

    public static boolean supportsModelDescription(IResource resource) {
        boolean result = false;
        if (ModelUtilities.isModelFile(resource)) {
            result = true;
            if (ModelUtil.isXsdFile((IResource)resource)) {
                result = false;
            }
        }
        return result;
    }

    public static void setModelDescription(ModelResource modelResource, String description) {
        if (!ModelUtilities.isReadOnly(modelResource)) {
            try {
                ModelAnnotation annotation = modelResource.getModelAnnotation();
                if (annotation != null) {
                    annotation.setDescription(description);
                } else {
                    UiConstants.Util.log(4, ModelUtilities.getString("ModelUtilities.nullModelAnnotation", modelResource.getPath().toString()));
                }
            }
            catch (ModelWorkspaceException ex) {
                String message = ModelUtilities.getString("ModelUtilities.setModelDescriptionError", modelResource.toString());
                UiConstants.Util.log(4, (Throwable)ex, message);
            }
        }
    }

    public static String getModelDescription(ModelResource model) {
        String result = "";
        try {
            result = model.getDescription();
        }
        catch (ModelWorkspaceException ex) {
            String message = ModelUtilities.getString("ModelUtilities.getModelDescriptionError", model.toString());
            UiConstants.Util.log(4, (Throwable)ex, message);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static boolean isVirtual(ModelResource modelResource) {
        boolean virtualState = false;
        if (modelResource != null) {
            try {
                virtualState = modelResource.getModelType().getValue() == ModelType.VIRTUAL;
            }
            catch (ModelWorkspaceException e) {
                String message = "[ModelUtilities.isVirtual()] ERROR: exception accessing ModelType";
                UiConstants.Util.log(4, (Throwable)e, message);
            }
        }
        return virtualState;
    }

    public static boolean isPhysical(ModelResource modelResource) {
        boolean physicalState = false;
        if (modelResource != null) {
            try {
                physicalState = modelResource.getModelType().getValue() == ModelType.PHYSICAL;
            }
            catch (ModelWorkspaceException e) {
                String message = "[ModelUtilities.isPhysical()] ERROR: exception accessing ModelType";
                UiConstants.Util.log(4, (Throwable)e, message);
            }
        }
        return physicalState;
    }

    public static boolean isLogical(ModelResource modelResource) {
        boolean result = false;
        if (modelResource != null) {
            try {
                result = modelResource.getModelType().getValue() == ModelType.LOGICAL;
            }
            catch (ModelWorkspaceException e) {
                String message = "[ModelUtilities.isVirtual()] ERROR: exception accessing ModelType";
                UiConstants.Util.log(4, (Throwable)e, message);
            }
        }
        return result;
    }

    public static boolean isReadOnly(ModelResource modelResource) {
        boolean result = true;
        if (modelResource != null && OpenEditorMap.getInstance().isEditorOpen(modelResource)) {
            result = modelResource.isReadOnly();
        }
        return result;
    }

    public static boolean existsOnFilesystem(IResource theResource) {
        boolean result = false;
        if (theResource != null && theResource.getLocation() != null) {
            result = new File(theResource.getLocation().toOSString()).exists();
        }
        return result;
    }

    public static boolean areModelResourcesSame(EObject eObj1, EObject eObj2) {
        ModelResource mr1 = ModelUtilities.getModelResourceForModelObject(eObj1);
        ModelResource mr2 = ModelUtilities.getModelResourceForModelObject(eObj2);
        return mr1 != null && mr2 != null && mr1.equals(mr2);
    }

    public static boolean supportsDiagrams(ModelResource modelResource) {
        boolean result = false;
        if (modelResource != null) {
            MetamodelDescriptor md = null;
            try {
                md = modelResource.getPrimaryMetamodelDescriptor();
            }
            catch (ModelWorkspaceException e) {
                String message = "[ModelUtilities.supportsDiagrams()] ERROR: finding supports diagrams.  Resource = " + modelResource;
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            if (md != null) {
                result = md.supportsDiagrams();
            }
        }
        return result;
    }

    public static boolean supportsDiagrams(Object input) {
        MetamodelDescriptor md = null;
        boolean result = false;
        if (input != null) {
            try {
                ModelResource mr;
                if (input instanceof EObject && ((EObject)input).eResource() != null) {
                    md = ModelerCore.getModelEditor().getMetamodelDescriptor((EObject)input);
                } else if (input instanceof ModelResource) {
                    md = (MetamodelDescriptor)input;
                } else if (input instanceof IFile) {
                    ModelResource mr2 = ModelUtil.getModelResource((IFile)((IFile)input), (boolean)false);
                    if (mr2 != null) {
                        md = mr2.getPrimaryMetamodelDescriptor();
                    }
                } else if (input instanceof Resource && (mr = ModelUtilities.getModelResource((Resource)input, false)) != null) {
                    md = mr.getPrimaryMetamodelDescriptor();
                }
                if (md != null) {
                    result = md.supportsDiagrams();
                }
            }
            catch (ModelWorkspaceException e) {
                String message = "[ModelUtilities.supportsDiagrams(Object)] ERROR: finding supports diagrams.  Object = " + input;
                UiConstants.Util.log(4, (Throwable)e, message);
            }
        }
        return result;
    }

    public static String modelNameReservedValidation(String proposedName) {
        boolean invalid = ResourceNameUtil.isReservedModelName((String)proposedName);
        if (invalid) {
            return Util.getString("ModelUtilities.modelNameIsReservedError", (Object)proposedName);
        }
        return null;
    }

    public static String schemaNameReservedValidation(String proposedName) {
        boolean invalid = ResourceNameUtil.isReservedSchemaName((String)proposedName);
        if (invalid) {
            return Util.getString("ModelUtilities.schemaNameIsReservedError", (Object)proposedName);
        }
        return null;
    }

    public static String vdbNameReservedValidation(String proposedName) {
        boolean invalid = ResourceNameUtil.isReservedVdbName((String)proposedName);
        if (invalid) {
            return Util.getString("ModelUtilities.vdbNameIsReservedError", (Object)proposedName);
        }
        return null;
    }

    public static Collection getResourcesUsedBy(IResource targetIFile) {
        if (targetIFile == null) {
            return Collections.EMPTY_LIST;
        }
        List modelImports = null;
        ArrayList<IFile> result = Collections.EMPTY_LIST;
        ModelResource targetModelResource = null;
        try {
            targetModelResource = ModelUtil.getModelResource((IFile)((IFile)targetIFile), (boolean)false);
            if (targetModelResource != null) {
                modelImports = targetModelResource.getModelImports();
            }
        }
        catch (ModelWorkspaceException err) {
            String message = Util.getString("ModelUtilities.errorFindingImports", (Object)targetModelResource);
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        if (modelImports != null && !modelImports.isEmpty()) {
            result = new ArrayList<IFile>(modelImports.size());
            for (Object importObject : modelImports) {
                IFile resource;
                String modelPath = null;
                if (importObject instanceof ModelImport) {
                    modelPath = ((ModelImport)importObject).getPath();
                } else if (importObject instanceof ResourceImportRecord) {
                    modelPath = ((ResourceImportRecord)importObject).getImportedPath();
                }
                if (modelPath == null || WorkspaceResourceFinderUtil.isGlobalResource((String)modelPath) || (resource = WorkspaceResourceFinderUtil.findIResource((String)modelPath)) == null || resource.equals((Object)targetIFile)) continue;
                result.add(resource);
            }
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public static Collection getResourcesUsedBy(ModelResource targetModelResource) {
        if (targetModelResource == null) {
            return Collections.EMPTY_LIST;
        }
        List modelImports = null;
        ArrayList<Object> result = Collections.EMPTY_LIST;
        try {
            modelImports = targetModelResource.getModelImports();
        }
        catch (ModelWorkspaceException err) {
            String message = Util.getString("ModelUtilities.errorFindingImports", (Object)targetModelResource);
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        if (modelImports != null && !modelImports.isEmpty()) {
            result = new ArrayList<Object>(modelImports.size());
            for (Object importObject : modelImports) {
                String modelPath = null;
                if (importObject instanceof ModelImport) {
                    modelPath = ((ModelImport)importObject).getPath();
                } else if (importObject instanceof ResourceImportRecord) {
                    modelPath = ((ResourceImportRecord)importObject).getImportedPath();
                }
                if (modelPath == null || WorkspaceResourceFinderUtil.isGlobalResource((String)modelPath)) continue;
                IFile resource = WorkspaceResourceFinderUtil.findIResource((String)modelPath);
                Object mr = null;
                if (resource != null) {
                    try {
                        mr = ModelUtil.getModelResource((IFile)resource, (boolean)false);
                    }
                    catch (ModelWorkspaceException err1) {
                        String message = Util.getString("ModelUtilities.errorFindingModelResource", (Object)resource);
                        UiConstants.Util.log(4, (Throwable)err1, message);
                    }
                }
                if (mr == null || mr.equals(targetModelResource)) continue;
                result.add(mr);
            }
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public static boolean allDependenciesOpenInWorkspace(ModelResource targetModelResource) {
        if (targetModelResource == null) {
            return true;
        }
        boolean result = true;
        List modelImports = null;
        try {
            modelImports = targetModelResource.getModelImports();
        }
        catch (ModelWorkspaceException err) {
            String message = "[ModelUtilities.allDependenciesOpenInWorkspace()] ERROR: finding model inports.  Resource = " + targetModelResource;
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        if (modelImports != null && !modelImports.isEmpty()) {
            for (Object importObject : modelImports) {
                String modelPath = null;
                if (importObject instanceof ModelImport) {
                    modelPath = ((ModelImport)importObject).getPath();
                } else if (importObject instanceof ResourceImportRecord) {
                    modelPath = ((ResourceImportRecord)importObject).getImportedPath();
                }
                if (modelPath == null || WorkspaceResourceFinderUtil.isGlobalResource((String)modelPath)) continue;
                IFile resource = WorkspaceResourceFinderUtil.findIResource((String)modelPath);
                ModelResource mr = null;
                if (resource != null) {
                    try {
                        mr = ModelUtil.getModelResource((IFile)resource, (boolean)false);
                    }
                    catch (ModelWorkspaceException err1) {
                        String message = "[ModelUtilities.allDependenciesOpenInWorkspace()] ERROR: finding model resource.  IFile = " + resource;
                        UiConstants.Util.log(4, (Throwable)err1, message);
                    }
                    if (mr == null) {
                        result = false;
                    }
                } else {
                    result = false;
                }
                if (!result) break;
            }
        }
        return result;
    }

    public static boolean isDependent(ModelResource targetModelResource, ModelResource dependentModelResource) {
        if (targetModelResource == null) {
            return false;
        }
        return ModelUtilities.getResourcesUsedBy(targetModelResource).contains(dependentModelResource);
    }

    public static boolean isDependent(IResource targetResource, IResource dependentResource) {
        if (targetResource == null) {
            return false;
        }
        return ModelUtilities.getResourcesUsedBy(targetResource).contains(dependentResource);
    }

    public static boolean verifyWorkspaceValidationState(Collection iFiles, Object source, String failString) {
        boolean result = true;
        Collection dirtyModels = ModelEditorManager.getDirtyResources();
        Iterator iter = iFiles.iterator();
        while (iter.hasNext() && result) {
            String message;
            IFile file = (IFile)iter.next();
            if (file == null) continue;
            if (!file.exists()) {
                message = String.valueOf(ModelUtilities.getString(FILE_DOES_NOT_EXIST_MSG_KEY, file.getFullPath().makeRelative().toString())) + failString;
                MessageDialog.openError(null, (String)FILE_DOES_NOT_EXIST_TITLE, (String)message);
                result = false;
                continue;
            }
            if (!file.getProject().isOpen()) {
                message = String.valueOf(ModelUtilities.getString(CLOSED_PROJECT_MSG_KEY, file.getFullPath().makeRelative().toString())) + failString;
                MessageDialog.openError(null, (String)CLOSED_PROJECT_TITLE, (String)message);
                result = false;
                continue;
            }
            if (dirtyModels.contains(file)) {
                message = String.valueOf(ModelUtilities.getString(MODEL_CHANGES_PENDING_MSG_KEY, file.getFullPath().makeRelative().toString())) + failString;
                MessageDialog.openError(null, (String)MODEL_CHANGES_PENDING_TITLE, (String)message);
                result = false;
                continue;
            }
            if (ModelUtilities.requiresValidation(file)) {
                message = String.valueOf(ModelUtilities.getString(MODEL_NOT_VALIDATED_MSG_KEY, file.getFullPath().makeRelative().toString())) + failString;
                MessageDialog.openError(null, (String)MODEL_NOT_VALIDATED_TITLE, (String)message);
                result = false;
                continue;
            }
            if (!ModelUtilities.hasErrors(file, source)) continue;
            message = String.valueOf(ModelUtilities.getString(MODEL_ERRORS_MSG_KEY, file.getFullPath().makeRelative().toString())) + failString;
            MessageDialog.openError(null, (String)MODEL_ERRORS_TITLE, (String)message);
            result = false;
        }
        return result;
    }

    public static boolean verifyWorkspaceValidationState(IFile iFile, Object source, String failString) {
        return ModelUtilities.verifyWorkspaceValidationState(iFile, source, failString, false);
    }

    public static boolean verifyWorkspaceValidationState(IFile iFile, Object source, String failString, boolean checkDependencies) {
        return ModelUtilities.verifyWorkspaceValidationState(iFile, source, failString, checkDependencies, null, new ArrayList());
    }

    private static boolean verifyWorkspaceValidationState(IFile iFile, Object source, String failString, boolean checkDependencies, IFile instigator, List theProcessedFiles) {
        boolean result = true;
        if (iFile == null) {
            result = false;
        } else if (!iFile.exists()) {
            ModelUtilities.showVerifyErrorDialog(FILE_DOES_NOT_EXIST_TITLE, FILE_DOES_NOT_EXIST_MSG_KEY, iFile, failString, instigator);
            result = false;
        } else {
            Collection dirtyModels = ModelEditorManager.getDirtyResources();
            if (!iFile.getProject().isOpen()) {
                ModelUtilities.showVerifyErrorDialog(CLOSED_PROJECT_TITLE, CLOSED_PROJECT_MSG_KEY, iFile, failString, instigator);
                result = false;
            } else if (dirtyModels.contains(iFile)) {
                ModelUtilities.showVerifyErrorDialog(MODEL_CHANGES_PENDING_TITLE, MODEL_CHANGES_PENDING_MSG_KEY, iFile, failString, instigator);
                result = false;
            } else if (ModelUtilities.requiresValidation(iFile)) {
                ModelUtilities.showVerifyErrorDialog(MODEL_NOT_VALIDATED_TITLE, MODEL_NOT_VALIDATED_MSG_KEY, iFile, failString, instigator);
                result = false;
            } else if (ModelUtilities.hasErrors(iFile, source)) {
                ModelUtilities.showVerifyErrorDialog(MODEL_ERRORS_TITLE, MODEL_ERRORS_MSG_KEY, iFile, failString, instigator);
                result = false;
            } else if (checkDependencies && !theProcessedFiles.contains(iFile)) {
                theProcessedFiles.add(iFile);
                result = ModelUtilities.verifyDependencyWorkspaceValidationState(iFile, source, failString, instigator, theProcessedFiles);
            }
        }
        return result;
    }

    private static void showVerifyErrorDialog(String dialogTitleText, String messageKey, IFile iFile, String failString, IFile instigator) {
        String msgStr = ModelUtilities.getString(messageKey, iFile.getFullPath().makeRelative().toString());
        String fullMessage = instigator != null ? String.valueOf(ModelUtilities.getString(MODEL_IMPORTED_PROBLEM_MSG_KEY, instigator.getFullPath().makeRelative().toString())) + msgStr + failString : String.valueOf(msgStr) + failString;
        MessageDialog.openError(null, (String)dialogTitleText, (String)fullMessage);
    }

    private static boolean verifyDependencyWorkspaceValidationState(IFile iFile, Object source, String failString, IFile instigator, List theProcessedFiles) {
        if (instigator == null) {
            instigator = iFile;
        } else if (instigator.equals((Object)iFile)) {
            return true;
        }
        try {
            boolean allDepsPresent = ModelUtilities.allDependenciesOpenInWorkspace(ModelUtil.getModelResource((IFile)iFile, (boolean)true));
            if (!allDepsPresent) {
                String message = String.valueOf(ModelUtilities.getString(MODEL_IMPORTED_NOT_FOUND_MSG_KEY, instigator.getFullPath().makeRelative().toString())) + failString;
                MessageDialog.openError(null, (String)MODEL_IMPORTED_NOT_FOUND_TITLE, (String)message);
                return false;
            }
        }
        catch (ModelWorkspaceException ex) {
            String message = Util.getString("ModelUtilities.errorFindingDependents", (Object)iFile);
            UiConstants.Util.log(4, (Throwable)ex, message);
        }
        Collection c = ModelUtilities.getResourcesUsedBy((IResource)iFile);
        for (IFile depFile : c) {
            if (ModelUtilities.verifyWorkspaceValidationState(depFile, source, failString, true, instigator, theProcessedFiles)) continue;
            return false;
        }
        return true;
    }

    public static Collection getAllWorkspaceResources() {
        if (ModelerCore.getModelWorkspace() == null) {
            return Collections.emptyList();
        }
        if (ModelerCore.getWorkspace() == null || ModelerCore.getWorkspace().getRoot() == null) {
            return Collections.emptyList();
        }
        WorkspaceResourceFinderUtil.FileResourceCollectorVisitor visitor = new WorkspaceResourceFinderUtil.FileResourceCollectorVisitor(){

            public boolean visit(IResource resource) {
                if (!resource.exists() || !this.getResourceFilter().accept(resource)) {
                    return false;
                }
                IPath path = resource.getFullPath();
                if (path.lastSegment().charAt(0) == '.') {
                    return false;
                }
                if (ModelUtilities.isModelFile(resource)) {
                    this.addResource(resource);
                }
                return true;
            }
        };
        WorkspaceResourceFinderUtil.getProjectFileResources((IResourceVisitor)visitor);
        return visitor.getFileResources();
    }

    public static IResource findModelByName(String modelNameWithExtension) {
        Collection allWorkspaceModels = ModelUtilities.getAllWorkspaceResources();
        if (!allWorkspaceModels.isEmpty()) {
            IResource theIResource2 = null;
            for (IResource theIResource2 : allWorkspaceModels) {
                if (!theIResource2.getName().equalsIgnoreCase(modelNameWithExtension)) continue;
                return theIResource2;
            }
        }
        return null;
    }

    public static Collection getResourcesThatUse(ModelResource resource) {
        ArrayList<ModelResource> result = Collections.EMPTY_LIST;
        IResource theResource = resource.getResource();
        Collection dependants = WorkspaceResourceFinderUtil.getResourcesThatUse((IResource)theResource, (int)0);
        Iterator it = dependants.iterator();
        IResource nextRes = null;
        ModelResource mo = null;
        try {
            while (it.hasNext()) {
                nextRes = (IResource)it.next();
                mo = ModelUtil.getModelResource((IFile)((IFile)nextRes), (boolean)true);
                if (mo == null) continue;
                if (result.isEmpty()) {
                    result = new ArrayList<ModelResource>();
                }
                result.add(mo);
            }
        }
        catch (ModelWorkspaceException err) {
            String message = ModelUtilities.getString(MODEL_RESOURCE_NOT_FOUND_MSG_KEY, nextRes == null ? "" : nextRes.getFullPath().toString());
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        return result;
    }

    public static void getDependentPhysicalModelResources(ModelResource modelResource, Collection resources) throws ModelWorkspaceException {
        ModelUtil.getDependentModelResources((ModelResource)modelResource, (Collection)resources, (boolean)false);
    }

    public static Collection getDependentResources(ModelResource resource) throws ModelWorkspaceException {
        return ModelUtil.getDependentResources((ModelResource)resource);
    }

    public static boolean requiresValidation(IFile file) {
        ModelResource mr = null;
        try {
            mr = ModelUtil.getModelResource((IFile)file, (boolean)false);
        }
        catch (ModelWorkspaceException err) {
            String message = ModelUtilities.getString(MODEL_RESOURCE_NOT_FOUND_MSG_KEY, file.toString());
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        if (mr != null) {
            return ModelUtilities.requiresValidation(mr);
        }
        return false;
    }

    public static boolean requiresValidation(ModelResource targetModelResource) {
        if (targetModelResource == null) {
            return false;
        }
        if (ModelUtil.isXsdFile((IResource)targetModelResource.getResource())) {
            return false;
        }
        boolean isIndexModified = ModelUtilities.isIndexFileLastModifiedAfterResourceFile(targetModelResource);
        return targetModelResource.getIndexType() == 0 && isIndexModified;
    }

    private static boolean isIndexFileLastModifiedAfterResourceFile(ModelResource targetModelResource) {
        File rsrcIndexFile = new File(IndexUtil.INDEX_PATH, IndexUtil.getRuntimeIndexFileName((ModelResource)targetModelResource));
        if (!rsrcIndexFile.exists()) {
            return false;
        }
        IPath path = ((IFile)targetModelResource.getResource()).getLocation();
        long resourceLastModified = path.toFile().lastModified();
        long indexLastModified = rsrcIndexFile.lastModified();
        return indexLastModified < resourceLastModified;
    }

    public static boolean hasErrors(IFile file, Object source) {
        ModelResource mr = null;
        boolean foundError = false;
        try {
            mr = ModelUtil.getModelResource((IFile)file, (boolean)false);
        }
        catch (ModelWorkspaceException err) {
            String message = ModelUtilities.getString(MODEL_RESOURCE_NOT_FOUND_MSG_KEY, file.toString());
            UiConstants.Util.log(4, (Throwable)err, message);
        }
        if (mr != null) {
            IMarker[] mrkrs = null;
            boolean errorOccurred = false;
            try {
                mrkrs = mr.getResource().findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            }
            catch (CoreException ex) {
                Util.log((Throwable)ex);
                errorOccurred = true;
            }
            if (!errorOccurred) {
                IMarker[] markers = mrkrs;
                boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, null, (Object)source);
                boolean succeeded = false;
                try {
                    int ndx = markers.length;
                    while (--ndx >= 0) {
                        int severity;
                        Object attr = MarkerUtilities.getMarkerAttribute(markers[ndx], "severity");
                        if (attr == null || (severity = ((Integer)attr).intValue()) != 2) continue;
                        foundError = true;
                        break;
                    }
                    succeeded = true;
                }
                finally {
                    if (startedTxn) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
        return foundError;
    }

    public static void initializeModelContainers(ModelResource modelResource, String txnLabel, Object source) {
        block9: {
            boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)txnLabel, (Object)source);
            boolean succeeded = false;
            try {
                try {
                    ModelerCore.getModelEditor().getAllContainers(modelResource.getEmfResource());
                    succeeded = true;
                }
                catch (ModelWorkspaceException err) {
                    String message = ModelUtilities.getString("ModelUtilities.initializeModelContainersError", modelResource.toString());
                    UiConstants.Util.log(4, (Throwable)err, message);
                    if (!started) break block9;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block9;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static boolean hasMetamodelWithURI(ModelResource modelResource, String uri) throws ModelWorkspaceException {
        if (modelResource == null || uri == null) {
            return false;
        }
        List allMetamodelDescriptors = modelResource.getAllMetamodelDescriptors();
        int i = 0;
        while (i < allMetamodelDescriptors.size()) {
            MetamodelDescriptor mmdesc = (MetamodelDescriptor)allMetamodelDescriptors.get(i);
            if (uri.equals(mmdesc.getNamespaceURI())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasJdbcSource(ModelResource modelResource) throws ModelWorkspaceException {
        if (modelResource == null) return false;
        if (!modelResource.isLoaded()) {
            return ModelUtilities.hasMetamodelWithURI(modelResource, "http://www.metamatrix.com/metamodels/JDBC");
        }
        try {
            EObject eObj;
            Resource resource = modelResource.getEmfResource();
            Iterator iter = resource.getContents().iterator();
            do {
                if (iter.hasNext()) continue;
                return false;
            } while (!((eObj = (EObject)iter.next()) instanceof JdbcSource));
            return true;
        }
        catch (ModelWorkspaceException err) {
            Util.log((Throwable)err);
            WidgetUtil.showError((String)err.getLocalizedMessage());
        }
        return false;
    }

    public static boolean isRelationalModel(ModelResource rsrc) throws ModelWorkspaceException {
        if (rsrc == null || rsrc.getPrimaryMetamodelDescriptor() == null) {
            return false;
        }
        return "http://www.metamatrix.com/metamodels/Relational".equals(rsrc.getPrimaryMetamodelDescriptor().getNamespaceURI());
    }

    public static void saveModelResource(ModelResource modelResource, IProgressMonitor monitor, boolean force, Object source) throws Exception {
        modelResource.save(monitor, force);
    }

    public static boolean modelIsLocked(ModelResource modelResource) throws Exception {
        if (modelResource != null) {
            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
            CoreModelExtensionAssistant assistant = (CoreModelExtensionAssistant)registry.getModelExtensionAssistant(CoreModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            return assistant.isModelLocked(modelResource);
        }
        return false;
    }

    public static boolean isVdbSourceModel(ModelResource modelResource) {
        if (modelResource != null) {
            try {
                ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
                CoreModelExtensionAssistant assistant = (CoreModelExtensionAssistant)registry.getModelExtensionAssistant(CoreModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
                if (assistant != null) {
                    return assistant.isVdbSourceModel(modelResource);
                }
            }
            catch (Exception ex) {
                UiConstants.Util.log(4, (Throwable)ex, ex.getMessage());
            }
        }
        return false;
    }

    public static boolean isVdbSourceModel(IFile modelFile) {
        if (modelFile != null) {
            try {
                ModelResource mr = ModelUtilities.getModelResource(modelFile);
                return ModelUtilities.isVdbSourceModel(mr);
            }
            catch (Exception ex) {
                UiConstants.Util.log(4, (Throwable)ex, ex.getMessage());
            }
        }
        return false;
    }

    public static String getVdbName(ModelResource modelResource) throws Exception {
        if (modelResource != null) {
            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
            CoreModelExtensionAssistant assistant = (CoreModelExtensionAssistant)registry.getModelExtensionAssistant(CoreModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            return assistant.getVdbName(modelResource);
        }
        return null;
    }

    public static IStatus doesModelNameExistInProject(String name, IResource res) {
        IStatus status = Status.OK_STATUS;
        try {
            IProject proj = res.getProject();
            IResource[] iResourceArray = proj.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iRes = iResourceArray[n2];
                if (iRes instanceof IContainer ? ModelUtilities.containsModelWithName(name, (IContainer)iRes) : iRes.getName().equals(name)) {
                    return new Status(4, "org.teiid.designer.ui", Util.getString("modelNameValidation.sameNameModelExistsInProjectMessage", (Object)name));
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            status = new Status(4, "org.teiid.designer.ui", Util.getString("sameNameModelExistsInProjectMessage", (Object)name));
            UiConstants.Util.log(4, (Throwable)ex, ex.getMessage());
        }
        return status;
    }

    private static boolean containsModelWithName(String name, IContainer container) throws CoreException {
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getUniqueName(String containerPath, String modelName, String targetName, boolean isTable, boolean overwrite) {
        String uniqueName = targetName;
        try {
            ModelResource mr;
            IFile modelFile = ModelUtilities.getModelFile(containerPath, modelName);
            if (modelFile != null && (mr = ModelUtilities.getModelResourceForIFile(modelFile, false)) != null) {
                uniqueName = ModelUtilities.getUniqueName(mr, targetName, isTable, overwrite);
            }
        }
        catch (ModelWorkspaceException ex) {
            UiConstants.Util.log((Throwable)ex);
        }
        return uniqueName;
    }

    public static String getUniqueName(ModelResource mr, String targetName, boolean isTable, boolean overwrite) {
        String uniqueName = targetName;
        if (mr != null && !overwrite) {
            RelationalStringNameValidator nameValidator = new RelationalStringNameValidator(isTable);
            try {
                for (Object eObj : mr.getEObjects()) {
                    String name = ModelerCore.getModelEditor().getName((EObject)eObj);
                    nameValidator.addExistingName(name);
                }
                uniqueName = nameValidator.createValidUniqueName(targetName);
            }
            catch (ModelWorkspaceException ex) {
                UiConstants.Util.log((Throwable)ex);
            }
        }
        return uniqueName;
    }

    public static boolean eObjectExists(String containerPath, String modelName, String childName) {
        return ModelUtilities.getExistingEObject(containerPath, modelName, childName) != null;
    }

    public static EObject getExistingEObject(String containerPath, String modelName, String childName) {
        try {
            ModelResource mr;
            IFile modelFile = ModelUtilities.getModelFile(containerPath, modelName);
            if (modelFile != null && (mr = ModelUtilities.getModelResourceForIFile(modelFile, false)) != null) {
                for (Object eObj : mr.getEObjects()) {
                    String name = ModelerCore.getModelEditor().getName((EObject)eObj);
                    if (!name.equals(childName)) continue;
                    return (EObject)eObj;
                }
            }
        }
        catch (ModelWorkspaceException ex) {
            UiConstants.Util.log((Throwable)ex);
        }
        return null;
    }

    public static boolean isModelDiagramLocked(Object object) {
        boolean result = false;
        try {
            ModelResource mr = ModelUtilities.getModelResource(object);
            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
            CoreModelExtensionAssistant assistant = (CoreModelExtensionAssistant)registry.getModelExtensionAssistant(CoreModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            ModelAnnotation modelAnnotation = mr.getModelAnnotation();
            String value = assistant.getPropertyValue((Object)modelAnnotation, CoreModelExtensionConstants.PropertyIds.DIAGRAM_LOCKED);
            result = Boolean.parseBoolean(value);
        }
        catch (ModelWorkspaceException ex) {
            UiConstants.Util.log((Throwable)ex);
        }
        catch (Exception ex) {
            UiConstants.Util.log((Throwable)ex);
        }
        return result;
    }

    public static void lockModelDiagrams(Object object) {
        try {
            ModelResource mr = ModelUtilities.getModelResource(object);
            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
            CoreModelExtensionAssistant assistant = (CoreModelExtensionAssistant)registry.getModelExtensionAssistant(CoreModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            ModelAnnotation modelAnnotation = mr.getModelAnnotation();
            assistant.setPropertyValue((Object)modelAnnotation, CoreModelExtensionConstants.PropertyIds.DIAGRAM_LOCKED, Boolean.TRUE.toString());
        }
        catch (ModelWorkspaceException ex) {
            UiConstants.Util.log((Throwable)ex);
        }
        catch (Exception ex) {
            UiConstants.Util.log((Throwable)ex);
        }
    }

    public static void unlockModelDiagrams(Object object) {
        try {
            ModelResource mr = ModelUtilities.getModelResource(object);
            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
            CoreModelExtensionAssistant assistant = (CoreModelExtensionAssistant)registry.getModelExtensionAssistant(CoreModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            ModelAnnotation modelAnnotation = mr.getModelAnnotation();
            assistant.setPropertyValue((Object)modelAnnotation, CoreModelExtensionConstants.PropertyIds.DIAGRAM_LOCKED, Boolean.FALSE.toString());
        }
        catch (ModelWorkspaceException ex) {
            UiConstants.Util.log((Throwable)ex);
        }
        catch (Exception ex) {
            UiConstants.Util.log((Throwable)ex);
        }
    }

    public static void warnIfUnsupportedModelInfoWontBeCopied(ModelResource mr) {
        if (mr == null) {
            return;
        }
        ArrayList<ModelObjectExtensionAssistant> assistants = new ArrayList<ModelObjectExtensionAssistant>();
        for (String namespacePrefix : ExtensionPlugin.getInstance().getRegistry().getAllNamespacePrefixes()) {
            ModelExtensionAssistant assistant = ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(namespacePrefix);
            if (!(assistant instanceof ModelObjectExtensionAssistant)) continue;
            assistants.add((ModelObjectExtensionAssistant)assistant);
        }
        boolean doWarn = false;
        try {
            TreeIterator iter = mr.getEmfResource().getAllContents();
            doWarn = false;
            while (iter.hasNext()) {
                EObject eObj = (EObject)iter.next();
                for (ModelObjectExtensionAssistant nextAss : assistants) {
                    if (!nextAss.supportsMyNamespace((Object)eObj)) continue;
                    Properties props = nextAss.getOverriddenValues((Object)eObj);
                    if (props != null && !props.isEmpty()) {
                        doWarn = true;
                    }
                    if (doWarn) break;
                }
                if (!doWarn) {
                    continue;
                }
                break;
            }
        }
        catch (ModelWorkspaceException e) {
            UiConstants.Util.log((Throwable)e);
        }
        catch (Exception e) {
            UiConstants.Util.log((Throwable)e);
        }
        if (doWarn) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)UiConstants.Util.getString("StructuralCopyWizardPage.modelContainsExtensionPropertiesWarningTitle", new Object[0]), (String)UiConstants.Util.getString("StructuralCopyWizardPage.modelContainsExtensionPropertiesWarningMsg", (Object)mr.getItemName()));
        }
    }
}

