/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.xsd.XsdUtil;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.properties.ModelObjectAdapterFactoryContentProvider;
import org.teiid.designer.ui.properties.ModelObjectPropertyDescriptor;
import org.teiid.designer.ui.viewsupport.DatatypeUtilities;
import org.teiid.designer.ui.viewsupport.MarkerUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public abstract class ModelObjectUtilities {
    public static final String SET_DESCRIPTION = UiConstants.Util.getString("ModelObjectUtilities.setDescription", new Object[0]);
    public static final String DELETE = UiConstants.Util.getString("ModelObjectUtilities.delete", new Object[0]);
    public static final String DELETES = UiConstants.Util.getString("ModelObjectUtilities.deletePlural", new Object[0]);
    public static final String RENAME = UiConstants.Util.getString("ModelObjectUtilities.rename", new Object[0]);
    public static final String BACK_SLASH = "/";
    private static final HashMap iconMap = new HashMap();
    private static ComposedAdapterFactory adapterFactory;
    private static final String CREATE = "create";
    private static final String ADAPTER = "Adapter";
    private static final Class[] NO_CLASSES;
    private static final Object[] NO_ARGS;
    public static IPropertySourceProvider propertySourceProvider;

    static {
        NO_CLASSES = new Class[0];
        NO_ARGS = new Object[0];
    }

    public static boolean isReadOnly(EObject theEObject) {
        boolean result = true;
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject(theEObject);
        if (modelResource != null) {
            result = ModelUtil.isIResourceReadOnly((IResource)modelResource.getResource());
        }
        return result;
    }

    public static MetamodelAspect getUmlAspect(EObject eObject) {
        return AspectManager.getUmlDiagramAspect((EObject)eObject);
    }

    public static MetamodelAspect getSqlAspect(EObject eObject) {
        return AspectManager.getSqlAspect((EObject)eObject);
    }

    public static IPropertySourceProvider getEmfPropertySourceProvider() {
        if (propertySourceProvider == null) {
            AdapterFactory factory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
            propertySourceProvider = new ModelObjectAdapterFactoryContentProvider(factory);
        }
        return propertySourceProvider;
    }

    public static boolean supportsDescription(EObject eObject) {
        if (eObject.eResource() instanceof XSDResourceImpl) {
            if (eObject instanceof XSDConcreteComponent) {
                return XsdUtil.canAnnotate((XSDConcreteComponent)((XSDConcreteComponent)eObject));
            }
            return false;
        }
        return true;
    }

    public static String getDescription(EObject eObject) {
        String result = "";
        try {
            DatatypeManager manager;
            String description = null;
            description = eObject instanceof XSDSimpleTypeDefinition ? ((manager = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true)).isBuiltInDatatype(eObject) ? manager.getDescription(eObject) : XsdUtil.getDescription((XSDConcreteComponent)((XSDConcreteComponent)eObject))) : (eObject instanceof XSDConcreteComponent ? XsdUtil.getDescription((XSDConcreteComponent)((XSDConcreteComponent)eObject)) : ModelerCore.getModelEditor().getDescription(eObject));
            if (description != null) {
                result = description;
            }
        }
        catch (ModelerCoreException ex) {
            String message = UiConstants.Util.getString("ModelObjectUtilities.getDescriptionError", (Object)eObject.toString());
            UiConstants.Util.log(4, (Throwable)ex, message);
        }
        return result;
    }

    public static void setDescription(EObject eObject, String description, Object eventSource) {
        block13: {
            if (!ModelObjectUtilities.isReadOnly(eObject)) {
                boolean requiredStart = ModelerCore.startTxn((String)SET_DESCRIPTION, (Object)eventSource);
                boolean succeeded = false;
                try {
                    try {
                        if (eObject.eResource() instanceof XSDResourceImpl) {
                            if (eObject instanceof XSDConcreteComponent) {
                                XsdUtil.addUserInfoAttribute((XSDConcreteComponent)((XSDConcreteComponent)eObject), (String)description);
                            }
                        } else {
                            ModelerCore.getModelEditor().setDescription(eObject, description);
                        }
                        succeeded = true;
                    }
                    catch (ModelerCoreException ex) {
                        String message = UiConstants.Util.getString("ModelObjectUtilities.errorSetDescription", (Object)eObject.toString());
                        UiConstants.Util.log(4, (Throwable)ex, message);
                        if (!requiredStart) break block13;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                            break block13;
                        }
                        ModelerCore.rollbackTxn();
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    public static String getName(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject, (String)"eObject");
        return ModelerCore.getModelEditor().getName(eObject);
    }

    public static boolean isVirtual(EObject eObject) {
        File newFile;
        XMIHeader header;
        URI theUri;
        Resource resource = eObject.eResource();
        if (resource instanceof EmfResource) {
            return ModelType.VIRTUAL_LITERAL.equals(((EmfResource)resource).getModelAnnotation().getModelType());
        }
        return resource == null && eObject.eIsProxy() && (theUri = ((InternalEObject)eObject).eProxyURI().trimFragment()).isFile() && (header = ModelFileUtil.getXmiHeader((File)(newFile = new File(theUri.toFileString())))) != null && ModelType.VIRTUAL_LITERAL.equals(ModelType.get((String)header.getModelType()));
    }

    public static boolean isLogical(EObject eObject) {
        File newFile;
        XMIHeader header;
        URI theUri;
        Resource resource = eObject.eResource();
        if (resource instanceof EmfResource) {
            return ModelType.LOGICAL_LITERAL.equals(((EmfResource)resource).getModelAnnotation().getModelType());
        }
        return resource == null && eObject.eIsProxy() && (theUri = ((InternalEObject)eObject).eProxyURI().trimFragment()).isFile() && (header = ModelFileUtil.getXmiHeader((File)(newFile = new File(theUri.toFileString())))) != null && ModelType.LOGICAL_LITERAL.equals(ModelType.get((String)header.getModelType()));
    }

    public static boolean isExtension(EObject eObject) {
        File newFile;
        XMIHeader header;
        URI theUri;
        Resource resource = eObject.eResource();
        if (resource instanceof EmfResource) {
            return ModelType.EXTENSION_LITERAL.equals(((EmfResource)resource).getModelAnnotation().getModelType());
        }
        return resource == null && eObject.eIsProxy() && (theUri = ((InternalEObject)eObject).eProxyURI().trimFragment()).isFile() && (header = ModelFileUtil.getXmiHeader((File)(newFile = new File(theUri.toFileString())))) != null && ModelType.EXTENSION_LITERAL.equals(ModelType.get((String)header.getModelType()));
    }

    public static boolean isFunction(EObject eObject) {
        File newFile;
        XMIHeader header;
        URI theUri;
        Resource resource = eObject.eResource();
        if (resource instanceof EmfResource) {
            String pmmURI;
            if (ModelType.UNKNOWN_LITERAL.equals(((EmfResource)resource).getModelAnnotation().getModelType()) && (pmmURI = ((EmfResource)resource).getModelAnnotation().getPrimaryMetamodelUri()) != null && pmmURI.equals("http://www.metamatrix.com/metamodels/MetaMatrixFunction")) {
                return true;
            }
            return ModelType.FUNCTION_LITERAL.equals(((EmfResource)resource).getModelAnnotation().getModelType());
        }
        return resource == null && eObject.eIsProxy() && (theUri = ((InternalEObject)eObject).eProxyURI().trimFragment()).isFile() && (header = ModelFileUtil.getXmiHeader((File)(newFile = new File(theUri.toFileString())))) != null && ModelType.FUNCTION_LITERAL.equals(ModelType.get((String)header.getModelType()));
    }

    public static boolean isTable(EObject eObject) {
        return TransformationHelper.isSqlTable((Object)eObject);
    }

    public static boolean isExecutable(EObject eObject) {
        if (ModelUtil.isVdbSourceObject((Object)eObject)) {
            return false;
        }
        if (TransformationHelper.isMappingClass((Object)eObject) && !TransformationHelper.isStagingTable((Object)eObject) || TransformationHelper.isSqlInputSet((Object)eObject)) {
            return false;
        }
        if (eObject instanceof Procedure && ((Procedure)eObject).isFunction()) {
            return false;
        }
        boolean hasValidQuery = true;
        if (TransformationHelper.isVirtualSqlTable((Object)eObject) && !TransformationHelper.isXmlDocument((Object)eObject) && !TransformationHelper.tableIsMaterialized((EObject)eObject)) {
            hasValidQuery = TransformationHelper.isValidQuery((Object)TransformationHelper.getTransformationMappingRoot((EObject)eObject)) || TransformationHelper.isValidSetQuery((Object)TransformationHelper.getTransformationMappingRoot((EObject)eObject));
        } else if (TransformationHelper.isOperation((Object)eObject)) {
            hasValidQuery = TransformationHelper.isValidUpdateProcedure((Object)TransformationHelper.getTransformationMappingRoot((EObject)eObject));
        }
        return hasValidQuery && (!TransformationHelper.isXmlDocument((Object)eObject) && !TransformationHelper.tableIsMaterialized((EObject)eObject) && TransformationHelper.isSqlTable((Object)eObject) || TransformationHelper.isSqlProcedure((Object)eObject));
    }

    public static String getSQL(EObject eObject, Object[] params, List accessPatternColumns) {
        if (TransformationHelper.isSqlTable((Object)eObject) || TransformationHelper.isXmlDocument((Object)eObject)) {
            StringBuffer executeSQL = new StringBuffer();
            executeSQL.append("select * from ");
            executeSQL.append(TransformationHelper.getDoubleQuotedSqlEObjectFullName((EObject)eObject));
            if (accessPatternColumns != null && !accessPatternColumns.isEmpty()) {
                executeSQL.append(" where ");
                int size = accessPatternColumns.size();
                int i = 0;
                while (i < size) {
                    EObject column = (EObject)accessPatternColumns.get(i);
                    executeSQL.append(TransformationHelper.getDoubleQuotedSqlEObjectFullName((EObject)column));
                    executeSQL.append(params[i] == null ? " IS NULL" : " = ?");
                    if (i + 1 < size) {
                        executeSQL.append(" and ");
                    }
                    ++i;
                }
            }
            return executeSQL.toString();
        }
        if (TransformationHelper.isSqlProcedure((Object)eObject)) {
            StringBuilder sb = new StringBuilder();
            sb.append("select * from ( exec ").append(TransformationHelper.getDoubleQuotedSqlEObjectFullName((EObject)eObject)).append("(");
            if (params != null && params.length > 0) {
                int i = 0;
                while (i < params.length - 1) {
                    sb.append("?,");
                    ++i;
                }
                sb.append("?");
            }
            sb.append(") ) AS X_X");
            return sb.toString();
        }
        return null;
    }

    public static String[] getDependentPhysicalModelNames(EObject eObject) throws ModelWorkspaceException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ModelResource> physicals = new ArrayList<ModelResource>();
        ModelResource model = ModelUtilities.getModelResourceForModelObject(eObject);
        if (model != null) {
            if (ModelUtilities.isPhysical(model)) {
                physicals.add(model);
            }
            ModelUtilities.getDependentPhysicalModelResources(model, physicals);
        }
        for (ModelResource physical : physicals) {
            names.add(physical.getItemName());
        }
        return names.toArray(new String[names.size()]);
    }

    public static Set<IResource> getDependentPhysicalModels(EObject eObject) throws ModelWorkspaceException {
        HashSet<IResource> result = new HashSet<IResource>();
        HashSet<ModelResource> physicalModels = new HashSet<ModelResource>();
        ModelResource model = ModelUtilities.getModelResourceForModelObject(eObject);
        if (model != null) {
            if (ModelUtilities.isPhysical(model)) {
                physicalModels.add(model);
            }
            ModelUtilities.getDependentPhysicalModelResources(model, physicalModels);
        }
        for (ModelResource mr : physicalModels) {
            result.add(mr.getCorrespondingResource());
        }
        return result;
    }

    public static boolean isPrimaryMetamodelObject(EObject eObject) {
        MetamodelDescriptor descriptor = ModelerCore.getModelEditor().getMetamodelDescriptor(eObject);
        return descriptor != null && descriptor.isPrimary();
    }

    public static List getFeaturePropertyList(EObject eObject) {
        ArrayList<Object> features = new ArrayList<Object>();
        IPropertySourceProvider provider = ModelUtilities.getEmfPropertySourceProvider();
        IPropertySource source = provider.getPropertySource((Object)eObject);
        IPropertyDescriptor[] descriptors = source.getPropertyDescriptors();
        ModelObjectPropertyDescriptor propertyDescriptor = null;
        if (descriptors != null) {
            int i = 0;
            while (i < descriptors.length) {
                EStructuralFeature feature;
                EClassifier eType;
                Object genericFeature;
                if (descriptors[i] instanceof ModelObjectPropertyDescriptor && (genericFeature = (propertyDescriptor = (ModelObjectPropertyDescriptor)descriptors[i]).getFeature()) instanceof EStructuralFeature && !((eType = (feature = (EStructuralFeature)genericFeature).getEType()) instanceof EDataType)) {
                    Object propertyValue = eObject.eGet(feature);
                    if (propertyValue instanceof List) {
                        List propertyList = (List)propertyValue;
                        Iterator iter = propertyList.iterator();
                        EObject nextEObject = null;
                        while (iter.hasNext()) {
                            nextEObject = (EObject)iter.next();
                            features.add(nextEObject);
                        }
                    } else if (propertyValue instanceof EObject) {
                        features.add(propertyValue);
                    }
                }
                ++i;
            }
        }
        if (features.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return features;
    }

    public static String getRelativePath(EObject eObject) {
        return ModelerCore.getModelEditor().getModelRelativePath(eObject).toString();
    }

    public static String getTrimmedRelativePath(EObject eObject) {
        IPath relativePath = ModelerCore.getModelEditor().getModelRelativePath(eObject);
        String relativePathString = relativePath.toString();
        int indexOfLastDot = relativePathString.lastIndexOf(47);
        if (indexOfLastDot >= 0) {
            return relativePathString.substring(0, indexOfLastDot);
        }
        return null;
    }

    public static String getTrimmedFullPath(EObject eObject) {
        IPath fullPath = ModelerCore.getModelEditor().getModelRelativePathIncludingModel(eObject);
        String fullPathString = fullPath.toString();
        int indexOfLastDot = fullPathString.lastIndexOf(47);
        if (indexOfLastDot >= 0) {
            return fullPathString.substring(0, indexOfLastDot);
        }
        return fullPathString;
    }

    public static boolean shareCommonParent(List eObjectList) {
        if (eObjectList == null || eObjectList.isEmpty()) {
            return false;
        }
        if (eObjectList.size() == 1) {
            return true;
        }
        boolean sameParent = true;
        EObject firstParent = ((EObject)eObjectList.get(0)).eContainer();
        int nObjects = eObjectList.size();
        if (firstParent == null) {
            firstParent = ((EObject)eObjectList.get(0)).eResource();
            int i = 1;
            while (i < nObjects) {
                EObject containerParent = ((EObject)eObjectList.get(i)).eContainer();
                if (containerParent != null || firstParent == null || !((EObject)eObjectList.get(i)).eResource().equals(firstParent)) {
                    sameParent = false;
                    break;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < nObjects) {
                if (firstParent == null || !((EObject)eObjectList.get(i)).eContainer().equals(firstParent)) {
                    sameParent = false;
                    break;
                }
                ++i;
            }
        }
        return sameParent;
    }

    public static boolean isDescendant(EObject possibleAncestor, EObject possibleDescendant) {
        boolean isDescendant = false;
        if (possibleAncestor != null && possibleDescendant != null) {
            if (possibleAncestor == possibleDescendant) {
                isDescendant = true;
            } else {
                EObject curParent = possibleDescendant.eContainer();
                while (!isDescendant && curParent != null) {
                    if (curParent == possibleAncestor) {
                        isDescendant = true;
                        continue;
                    }
                    curParent = curParent.eContainer();
                }
            }
        }
        return isDescendant;
    }

    public static boolean isJdbcSource(EObject eObject) {
        return eObject instanceof JdbcSource;
    }

    public static boolean isNonDrawableEObject(EObject eObject) {
        boolean result = false;
        if (ModelObjectUtilities.isJdbcSource(eObject)) {
            result = true;
        }
        return result;
    }

    public static void delete(EObject eObject, boolean significance, boolean undoable, Object source) {
        CoreArgCheck.isNotNull((Object)eObject);
        ModelObjectUtilities.delete(eObject, significance, undoable, source, true);
    }

    public static void delete(EObject eObject, boolean significance, boolean undoable, Object source, boolean checkResource) {
        block9: {
            CoreArgCheck.isNotNull((Object)eObject);
            boolean requiredStart = ModelerCore.startTxn((boolean)significance, (boolean)undoable, (String)DELETE, (Object)source);
            boolean succeeded = false;
            try {
                try {
                    ModelerCore.getModelEditor().delete(eObject, checkResource);
                    succeeded = true;
                }
                catch (ModelerCoreException ex) {
                    String message = UiConstants.Util.getString("ModelObjectUtilities.errorDelete", (Object)eObject.toString());
                    UiConstants.Util.log(4, (Throwable)ex, message);
                    if (!requiredStart) break block9;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block9;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void delete(List eObjectList, boolean significance, boolean undoable, Object source) {
        ModelObjectUtilities.delete(eObjectList, significance, undoable, source, true);
    }

    public static void delete(List eObjectList, boolean significance, boolean undoable, Object source, boolean checkResource) {
        block10: {
            boolean requiredStart = ModelerCore.startTxn((boolean)significance, (boolean)undoable, (String)DELETES, (Object)source);
            boolean succeeded = false;
            try {
                try {
                    Iterator iter = eObjectList.iterator();
                    EObject nextEObject = null;
                    while (iter.hasNext()) {
                        nextEObject = (EObject)iter.next();
                        ModelerCore.getModelEditor().delete(nextEObject, checkResource);
                    }
                    succeeded = true;
                }
                catch (ModelerCoreException ex) {
                    String message = UiConstants.Util.getString("ModelObjectUtilities.errorDelete", eObjectList.toArray());
                    UiConstants.Util.log(4, (Throwable)ex, message);
                    if (!requiredStart) break block10;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block10;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void rename(EObject eObject, String newName, Object source) {
        block10: {
            CoreArgCheck.isNotNull((Object)eObject);
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)RENAME, (Object)source);
            boolean succeeded = false;
            try {
                try {
                    if (!DatatypeUtilities.renameSqlColumn(eObject, newName)) {
                        ModelerCore.getModelEditor().rename(eObject, newName);
                    }
                    succeeded = true;
                }
                catch (ModelerCoreException ex) {
                    String message = UiConstants.Util.getString("ModelObjectUtilities.errorRename", (Object)eObject.toString());
                    UiConstants.Util.log(4, (Throwable)ex, message);
                    if (!requiredStart) break block10;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block10;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static Image getImageFromObject(Object object) {
        return ExtendedImageRegistry.getInstance().getImage(object);
    }

    public static Image getImage(EClass eClass) {
        Image result = null;
        if (adapterFactory == null) {
            adapterFactory = (ComposedAdapterFactory)ModelerCore.getMetamodelRegistry().getAdapterFactory();
        }
        if (eClass != null && (result = (Image)iconMap.get(eClass)) == null) {
            Adapter adapter = null;
            EPackage ePackage = eClass.getEPackage();
            ArrayList<Object> types = new ArrayList<Object>();
            types.add(ePackage);
            types.add(IItemLabelProvider.class);
            AdapterFactory delegateAdapterFactory = adapterFactory.getFactoryForTypes(types);
            if (delegateAdapterFactory != null) {
                String methodName = CREATE + eClass.getName() + ADAPTER;
                Method m = null;
                try {
                    m = delegateAdapterFactory.getClass().getMethod(methodName, NO_CLASSES);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                if (m != null) {
                    try {
                        adapter = (Adapter)m.invoke((Object)delegateAdapterFactory, NO_ARGS);
                    }
                    catch (IllegalArgumentException e1) {
                        e1.printStackTrace();
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                    catch (InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                    if (adapter instanceof ItemProviderAdapter) {
                        Object o = null;
                        try {
                            o = ((ItemProviderAdapter)adapter).getImage((Object)eClass);
                        }
                        catch (ClassCastException classCastException) {
                            EObject eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
                            o = ((ItemProviderAdapter)adapter).getImage((Object)eObject);
                        }
                        if (o instanceof Image) {
                            result = (Image)o;
                        } else if (o instanceof URL) {
                            result = ExtendedImageRegistry.getInstance().getImage(o);
                        }
                    }
                }
            }
            if (result != null) {
                iconMap.put(eClass, result);
            }
        }
        return result;
    }

    public static EObject getMarkedEObject(IMarker iMarker) {
        URI theURI;
        EObject target = null;
        String uri = (String)MarkerUtilities.getMarkerAttribute(iMarker, "org.teiid.designer.core.markerURI");
        if (uri != null && (theURI = URI.createURI((String)uri)) != null) {
            try {
                target = ModelerCore.getModelContainer().getEObject(theURI, true);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
        return target;
    }

    public static String getUuid(EObject eObj) {
        int index;
        String fullUri = ModelerCore.getModelEditor().getUri(eObj).toString();
        if (fullUri != null && (index = fullUri.lastIndexOf(BACK_SLASH) + 1) <= fullUri.length()) {
            return fullUri.substring(index);
        }
        return null;
    }

    public static String getFullUuid(EObject eObj) {
        return ModelerCore.getModelEditor().getUri(eObj).toString();
    }

    public static EObject getRealEObject(EObject eObj) {
        EObject realEObj = null;
        if (eObj != null) {
            try {
                realEObj = eObj.eIsProxy() ? EcoreUtil.resolve((EObject)eObj, (ResourceSet)ModelerCore.getModelContainer()) : eObj;
                if (realEObj.eIsProxy()) {
                    realEObj = null;
                }
            }
            catch (CoreException ce) {
                UiConstants.Util.log(4, (Throwable)ce, ce.getMessage());
            }
        }
        return realEObj;
    }

    public static boolean isStale(EObject eObj) {
        CoreArgCheck.isNotNull((Object)eObj);
        return eObj.eResource() == null;
    }

    public static boolean didResourceContainAny(IResource res, Collection eobjs) {
        for (EObject e : eobjs) {
            if (!ModelObjectUtilities.didResourceContain(res, e)) continue;
            return true;
        }
        return false;
    }

    public static boolean didResourceContain(IResource res, EObject e) {
        ModelResource editorMR = ModelUtilities.getModelResourceForModelObject(e);
        if (editorMR == null) {
            EObject realEObject = ModelObjectUtilities.getRealEObject(e);
            editorMR = ModelUtilities.getModelResourceForModelObject(realEObject);
        }
        if (editorMR != null) {
            if (editorMR.getResource().equals((Object)res)) {
                return true;
            }
        } else {
            URI u = ModelerCore.getModelEditor().getUri(e);
            if (u != null && u.isFile()) {
                Path pth = new Path(u.device(), u.path());
                try {
                    if (pth.equals((Object)ModelUtil.getLocation((IResource)res))) {
                        return true;
                    }
                }
                catch (CoreException ex) {
                    UiConstants.Util.log((Throwable)ex);
                }
            }
        }
        return false;
    }

    public static boolean isVdbSourceModel(EObject eObject) {
        ModelResource modelResource = ModelUtilities.getModelResource(eObject);
        if (modelResource != null) {
            return ModelUtilities.isVdbSourceModel(modelResource);
        }
        return false;
    }

    public static boolean shareCommonProject(EObject eObj_1, EObject eObj_2) {
        ModelResource mr_1 = ModelUtilities.getModelResourceForModelObject(eObj_1);
        ModelResource mr_2 = ModelUtilities.getModelResourceForModelObject(eObj_2);
        if (mr_1 != null && mr_2 != null) {
            try {
                IResource res_1 = mr_1.getCorrespondingResource();
                IResource res_2 = mr_2.getCorrespondingResource();
                if (res_1 != null && res_2 != null) {
                    return res_1.getProject().getName().equals(res_2.getProject().getName());
                }
            }
            catch (ModelWorkspaceException ex) {
                UiConstants.Util.log(4, (Throwable)ex, ex.getMessage());
            }
        }
        return false;
    }
}

