/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.views;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.teiid.designer.ui.common.eventsupport.SelectionProvider;
import org.teiid.designer.ui.properties.ModelObjectPropertySourceProvider;
import org.teiid.designer.ui.undo.IUndoManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.StatusBarUpdater;

public abstract class ModelerView
extends ViewPart {
    protected ModelObjectPropertySourceProvider propertySourceProvider;
    protected ISelectionProvider selectionProvider = new SelectionProvider();
    protected ISelectionListener selectionListener;
    protected StatusBarUpdater statusBarListener;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.setSelectionProvider(this.selectionProvider);
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part != ModelerView.this && !(part instanceof PropertySheet)) {
                    ModelerView.this.selectionProvider.setSelection(selection);
                }
            }
        };
        site.getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
    }

    protected ISelectionChangedListener getStatusBarListener() {
        return this.statusBarListener;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            if (this.propertySourceProvider == null) {
                this.propertySourceProvider = ModelUtilities.getPropertySourceProvider();
            }
            return this.propertySourceProvider.getPropertySheetPage();
        }
        if (key.equals(IUndoManager.class)) {
            return this.getUndoManager();
        }
        return super.getAdapter(key);
    }

    protected IUndoManager getUndoManager() {
        return null;
    }

    public void createPartControl(Composite parent) {
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.statusBarListener = new StatusBarUpdater(slManager);
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.statusBarListener);
        ISelection selection = this.getSite().getWorkbenchWindow().getSelectionService().getSelection();
        if (selection != null) {
            this.selectionProvider.setSelection(selection);
        }
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
        super.dispose();
    }
}

