/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.search;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.search.ISearchEngine;
import org.teiid.designer.core.search.runtime.ResourceObjectRecord;
import org.teiid.designer.core.search.runtime.SearchRecord;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.search.MetadataMatch;
import org.teiid.designer.ui.search.MetadataMatchInfo;
import org.teiid.designer.ui.search.MetadataSearchPage;
import org.teiid.designer.ui.search.MetadataSearchResult;

public class MetadataSearchQuery
implements ISearchQuery,
UiConstants {
    private ISearchEngine searchEngine;
    private MetadataSearchResult result;

    public MetadataSearchQuery(ISearchEngine searchEngine) {
        this.searchEngine = searchEngine;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    protected MetadataSearchResult constructEmptyResults() {
        return new MetadataSearchResult(this);
    }

    public String getLabel() {
        return Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(MetadataSearchPage.class)) + "query.msg", new Object[0]);
    }

    public String getSearchCriteria() {
        return this.searchEngine.getSearchCriteria();
    }

    public ISearchResult getSearchResult() {
        if (this.result == null) {
            this.result = this.constructEmptyResults();
        }
        return this.result;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        IStatus status = this.searchEngine.canExecute();
        if (status.isOK()) {
            status = this.searchEngine.execute(monitor);
            this.processSearchEngineResults(this.searchEngine.getResults());
        }
        return status;
    }

    protected void processSearchEngineResults(List<SearchRecord> records) {
        MetadataSearchResult result = (MetadataSearchResult)this.getSearchResult();
        for (SearchRecord record : records) {
            ResourceObjectRecord ror = (ResourceObjectRecord)record;
            MetadataMatch match = new MetadataMatch(new MetadataMatchInfo(ror.getResourcePath(), result), ror);
            result.addMatch(match);
        }
    }
}

