/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.search.ISearchEngine;
import org.teiid.designer.core.search.MetadataSearch;
import org.teiid.designer.metamodels.xsd.util.RuntimeType;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.search.MetadataSearchQuery;
import org.teiid.designer.ui.search.SearchPageUtil;
import org.teiid.designer.ui.viewsupport.DatatypeSelectionDialog;
import org.teiid.designer.ui.viewsupport.MetamodelSelectionDialog;
import org.teiid.designer.ui.viewsupport.MetamodelTreeViewer;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public final class MetadataSearchPage
extends DialogPage
implements ISearchPage,
UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(MetadataSearchPage.class);
    private ISearchPageContainer searchPageContainer;
    private EClass metaclass;
    private List metaclassMru;
    private ILabelProvider labelProvider;
    private String runtimeType;
    private MetadataSearch searchMgr = ModelerCore.createMetadataSearch();
    private IDialogSettings settings;
    private XSDSimpleTypeDefinition simpleType;
    private Button btnAnyDataType;
    private Button btnAnyObjectType;
    private Button btnBrowseMetaclass;
    private Button btnBrowseSimpleType;
    private Button btnContains;
    private Button btnMetaclass;
    private Button btnNotContain;
    private Button btnRuntimeType;
    private Button btnSimpleType;
    private Combo cbxMetaclass;
    private Combo cbxProperties;
    private Combo cbxRuntimeType;
    private Combo cbxTextPattern;
    private Button chkExactMatch;
    private Button chkIncludeProperty;
    private Button chkIncludeSubtypes;
    private Text txfSimpleType;

    public MetadataSearchPage() {
        this.metaclassMru = new ArrayList();
    }

    public void createControl(Composite parent) {
        this.initializeDialogSettings();
        this.setControl((Control)this.createControlImpl(parent));
        this.restoreState();
    }

    private Composite createControlImpl(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        pnlMain.setLayout((Layout)new GridLayout(1, false));
        Group pnl = WidgetFactory.createGroup((Composite)pnlMain, (String)Util.getString(String.valueOf(PREFIX) + "group.criteria", new Object[0]), (int)1808, (int)1, (int)4);
        pnl.setFont(JFaceResources.getDefaultFont());
        this.createPropertiesPanelContents((Composite)pnl, 4);
        pnl = WidgetFactory.createGroup((Composite)pnlMain, (String)Util.getString(String.valueOf(PREFIX) + "group.objectType", new Object[0]), (int)1808, (int)1, (int)3);
        pnl.setFont(JFaceResources.getDefaultFont());
        this.createObjectTypePanelContents((Composite)pnl, 3);
        pnl = WidgetFactory.createGroup((Composite)pnlMain, (String)Util.getString(String.valueOf(PREFIX) + "group.dataType", new Object[0]), (int)1808, (int)1, (int)3);
        pnl.setFont(JFaceResources.getDefaultFont());
        this.createDataTypePanelContents((Composite)pnl, 3);
        return pnlMain;
    }

    private void createDataTypePanelContents(Composite theParent, int theColumnCount) {
        this.btnAnyDataType = WidgetFactory.createRadioButton((Composite)theParent, (String)Util.getString(String.valueOf(PREFIX) + "radioButton.anyDataType", new Object[0]), (int)0, (int)theColumnCount, (boolean)false);
        this.btnAnyDataType.setToolTipText(Util.getString(String.valueOf(PREFIX) + "radioButton.anyDataType.tip", new Object[0]));
        this.btnAnyDataType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleAnyDataTypeSelected();
            }
        });
        this.btnSimpleType = WidgetFactory.createRadioButton((Composite)theParent, (String)Util.getString(String.valueOf(PREFIX) + "radioButton.simpleType", new Object[0]), (boolean)false);
        this.btnSimpleType.setToolTipText(Util.getString(String.valueOf(PREFIX) + "radioButton.simpleType.tip", new Object[0]));
        this.btnSimpleType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleSimpleTypeSelected();
            }
        });
        this.txfSimpleType = WidgetFactory.createTextField((Composite)theParent, (int)768);
        this.txfSimpleType.setToolTipText(Util.getString(String.valueOf(PREFIX) + "text.simpleType.tip", new Object[0]));
        this.txfSimpleType.setEditable(false);
        this.txfSimpleType.setEnabled(false);
        this.txfSimpleType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                MetadataSearchPage.this.handleSimpleTypeChanged();
            }
        });
        this.btnBrowseSimpleType = WidgetFactory.createButton((Composite)theParent, (String)InternalUiConstants.Widgets.BROWSE_BUTTON);
        this.btnBrowseSimpleType.setToolTipText(Util.getString(String.valueOf(PREFIX) + "button.browseSimpleType.tip", new Object[0]));
        this.btnBrowseSimpleType.setEnabled(false);
        this.btnBrowseSimpleType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleBrowseSimpleType();
            }
        });
        this.chkIncludeSubtypes = WidgetFactory.createCheckBox((Composite)theParent, (String)Util.getString(String.valueOf(PREFIX) + "checkBox.includeSubtypes", new Object[0]), (int)16384, (int)theColumnCount);
        ((GridData)this.chkIncludeSubtypes.getLayoutData()).horizontalIndent = 20;
        this.chkIncludeSubtypes.setToolTipText(Util.getString(String.valueOf(PREFIX) + "checkBox.includeSubtypes.tip", new Object[0]));
        this.chkIncludeSubtypes.setEnabled(false);
        this.chkIncludeSubtypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleIncludeSubtypesSelected();
            }
        });
        this.btnRuntimeType = WidgetFactory.createRadioButton((Composite)theParent, (String)Util.getString(String.valueOf(PREFIX) + "radioButton.runtimeType", new Object[0]));
        this.btnRuntimeType.setToolTipText(Util.getString(String.valueOf(PREFIX) + "radioButton.runtimeType.tip", new Object[0]));
        this.btnRuntimeType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleRuntimeTypeSelected();
            }
        });
        this.cbxRuntimeType = WidgetFactory.createCombo((Composite)theParent, (int)8, (int)256, (int)(theColumnCount - 1));
        this.cbxRuntimeType.setToolTipText(Util.getString(String.valueOf(PREFIX) + "combo.runtimeType.tip", new Object[0]));
        this.cbxRuntimeType.setEnabled(false);
        WidgetUtil.setComboItems((Combo)this.cbxRuntimeType, (Collection)RuntimeType.VALUES, (ILabelProvider)new LabelProvider(), (boolean)true);
        this.cbxRuntimeType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleRuntimeTypeChanged();
            }
        });
    }

    private void createObjectTypePanelContents(Composite theParent, int theColumnCount) {
        this.btnAnyObjectType = WidgetFactory.createRadioButton((Composite)theParent, (String)Util.getString(String.valueOf(PREFIX) + "radioButton.anyObjectType", new Object[0]), (int)0, (int)theColumnCount, (boolean)false);
        this.btnAnyObjectType.setToolTipText(Util.getString(String.valueOf(PREFIX) + "radioButton.anyObjectType.tip", new Object[0]));
        this.btnAnyObjectType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleAnyObjectTypeSelected();
            }
        });
        this.btnMetaclass = WidgetFactory.createRadioButton((Composite)theParent, (String)Util.getString(String.valueOf(PREFIX) + "radioButton.metaclass", new Object[0]));
        this.btnMetaclass.setToolTipText(Util.getString(String.valueOf(PREFIX) + "radioButton.metaclass.tip", new Object[0]));
        this.btnMetaclass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleMetaclassSelected();
            }
        });
        this.cbxMetaclass = WidgetFactory.createCombo((Composite)theParent, (int)8, (int)768);
        this.cbxMetaclass.setToolTipText(Util.getString(String.valueOf(PREFIX) + "combo.metaclass.tip", new Object[0]));
        this.cbxMetaclass.setEnabled(false);
        this.cbxMetaclass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleMetaclassChanged();
            }
        });
        this.btnBrowseMetaclass = WidgetFactory.createButton((Composite)theParent, (String)InternalUiConstants.Widgets.BROWSE_BUTTON);
        this.btnBrowseMetaclass.setToolTipText(Util.getString(String.valueOf(PREFIX) + "button.browseMetaclass.tip", new Object[0]));
        this.btnBrowseMetaclass.setEnabled(false);
        this.btnBrowseMetaclass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleBrowseMetaclass();
            }
        });
    }

    private void createPropertiesPanelContents(Composite theParent, int theColumnCount) {
        this.chkIncludeProperty = WidgetFactory.createCheckBox((Composite)theParent, (String)Util.getString(String.valueOf(PREFIX) + "checkBox.includeProperty", new Object[0]), (int)16384);
        this.chkIncludeProperty.setToolTipText(Util.getString(String.valueOf(PREFIX) + "checkBox.includeProperty.tip", new Object[0]));
        this.chkIncludeProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleIncludePropertySelected();
            }
        });
        this.cbxProperties = WidgetFactory.createCombo((Composite)theParent, (int)8, (int)256, (int)(theColumnCount - 1));
        this.cbxProperties.setItems(this.searchMgr.getFeaturesNames());
        this.cbxProperties.setToolTipText(Util.getString(String.valueOf(PREFIX) + "combo.properties.tip", new Object[0]));
        this.cbxProperties.setEnabled(false);
        this.cbxProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handlePropertySelected();
            }
        });
        boolean enable = this.cbxProperties.getItemCount() > 0;
        this.chkIncludeProperty.setEnabled(enable);
        if (enable) {
            this.cbxProperties.select(0);
        }
        this.btnContains = WidgetFactory.createRadioButton((Composite)theParent, (String)Util.getString(String.valueOf(PREFIX) + "radioButton.contains", new Object[0]));
        this.btnContains.setToolTipText(Util.getString(String.valueOf(PREFIX) + "radioButton.contains.tip", new Object[0]));
        this.btnContains.setEnabled(enable);
        this.btnContains.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleContainsSelected();
            }
        });
        ((GridData)this.btnContains.getLayoutData()).horizontalIndent = 20;
        this.btnNotContain = WidgetFactory.createRadioButton((Composite)theParent, (String)Util.getString(String.valueOf(PREFIX) + "radioButton.notContain", new Object[0]));
        this.btnNotContain.setToolTipText(Util.getString(String.valueOf(PREFIX) + "radioButton.notContain.tip", new Object[0]));
        this.btnNotContain.setEnabled(enable);
        this.btnNotContain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleNotContainSelected();
            }
        });
        this.chkExactMatch = WidgetFactory.createCheckBox((Composite)theParent, (String)Util.getString(String.valueOf(PREFIX) + "checkBox.exactMatch", new Object[0]), (int)768);
        this.chkExactMatch.setToolTipText(Util.getString(String.valueOf(PREFIX) + "checkBox.exactMatch.tip", new Object[0]));
        this.chkExactMatch.setEnabled(false);
        this.chkExactMatch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                MetadataSearchPage.this.handleExactMatchSelected();
            }
        });
        Label lbl = WidgetFactory.createLabel((Composite)theParent, (int)32, (int)theColumnCount, (String)Util.getString(String.valueOf(PREFIX) + "label.textPattern", new Object[0]));
        ((GridData)lbl.getLayoutData()).horizontalIndent = 20;
        this.cbxTextPattern = WidgetFactory.createCombo((Composite)theParent, (int)0, (int)768, (int)(theColumnCount - 1));
        this.cbxTextPattern.setToolTipText(Util.getString(String.valueOf(PREFIX) + "combo.textPattern.tip", new Object[0]));
        this.cbxTextPattern.setEnabled(enable);
        this.cbxTextPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                MetadataSearchPage.this.handleTextPatternModified();
            }
        });
        ((GridData)this.cbxTextPattern.getLayoutData()).horizontalIndent = 20;
    }

    private ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            MetamodelSelectionDialog dialog = (MetamodelSelectionDialog)MetamodelTreeViewer.createSelectionDialog(this.getShell(), false);
            this.labelProvider = (ILabelProvider)dialog.getViewerLabelProvider();
        }
        return this.labelProvider;
    }

    private EClass getMetaclass(String theUri) {
        EClass result = null;
        if (theUri != null && theUri.length() > 0) {
            try {
                EObject temp = ModelUtilities.getWorkspaceContainer().getEObject(URI.createURI((String)theUri), true);
                if (temp != null && temp instanceof EClass) {
                    result = (EClass)temp;
                } else {
                    Util.log((Object)("Not EClass. URI = " + temp));
                }
            }
            catch (CoreException theException) {
                Util.log((Throwable)theException);
            }
        }
        return result;
    }

    private String getMetaclassText(String theMetaclassUri) {
        return this.getMetaclass(theMetaclassUri).getName();
    }

    private String getMetaclassUri(EClass theMetaclass) {
        return ModelerCore.getModelEditor().getUri((EObject)theMetaclass).toString();
    }

    void handleAnyDataTypeSelected() {
        if (this.btnAnyDataType.getSelection()) {
            this.txfSimpleType.setEnabled(false);
            this.btnBrowseSimpleType.setEnabled(false);
            this.chkIncludeSubtypes.setEnabled(false);
            this.cbxRuntimeType.setEnabled(false);
            this.searchMgr.setDatatype(null, false);
            this.searchMgr.setRuntimeType(null);
            this.updateSearchState();
        }
    }

    void handleAnyObjectTypeSelected() {
        if (this.btnAnyObjectType.getSelection()) {
            this.cbxMetaclass.setEnabled(false);
            this.btnBrowseMetaclass.setEnabled(false);
            this.setDataTypePanelEnabled(true);
            this.searchMgr.setMetaClass(null);
            this.updateSearchState();
        }
    }

    void handleBrowseMetaclass() {
        MetamodelSelectionDialog dialog = (MetamodelSelectionDialog)MetamodelTreeViewer.createSelectionDialog(this.getShell(), false);
        if (this.labelProvider == null) {
            this.labelProvider = (ILabelProvider)dialog.getViewerLabelProvider();
        }
        dialog.setAllowMultiple(false);
        if (this.metaclass != null) {
            dialog.setInitialSelection(this.metaclass);
        }
        if (dialog.open() == 0) {
            this.updateMetaclass((EClass)dialog.getResult()[0]);
            this.updateDataTypePanelEnable();
        }
    }

    void handleBrowseSimpleType() {
        DatatypeSelectionDialog dialog = new DatatypeSelectionDialog(this.getShell());
        if (this.simpleType != null) {
            dialog.setInitialSelections(new Object[]{this.simpleType});
        }
        if (dialog.open() == 0) {
            this.updateSimpleType((XSDSimpleTypeDefinition)dialog.getResult()[0]);
        }
    }

    void handleContainsSelected() {
        if (this.btnContains.getSelection()) {
            this.updatePropertyCriteria();
        }
    }

    void handleExactMatchSelected() {
        if (this.cbxProperties.getText().equals(MetadataSearch.OBJECT_URI_FEATURE) && !this.chkExactMatch.getSelection()) {
            this.chkExactMatch.setSelection(true);
        }
        this.updatePropertyCriteria();
    }

    void handleIncludeSubtypesSelected() {
        this.handleSimpleTypeChanged();
    }

    void handleIncludePropertySelected() {
        boolean enable = this.chkIncludeProperty.getSelection() && this.chkIncludeProperty.getEnabled();
        this.cbxProperties.setEnabled(enable);
        this.btnContains.setEnabled(enable);
        this.btnNotContain.setEnabled(enable);
        this.chkExactMatch.setEnabled(enable);
        this.cbxTextPattern.setEnabled(enable);
        this.handlePropertySelected();
    }

    void handleMetaclassChanged() {
        int index = this.cbxMetaclass.getSelectionIndex();
        this.metaclass = this.getMetaclass((String)this.metaclassMru.get(index));
        this.handleMetaclassSelected();
    }

    void handleMetaclassSelected() {
        if (this.btnMetaclass.getSelection()) {
            this.btnBrowseMetaclass.setEnabled(true);
            this.cbxMetaclass.setEnabled(true);
            this.searchMgr.setMetaClass(this.metaclass);
            this.updateDataTypePanelEnable();
            this.updateSearchState();
        }
    }

    private void updateDataTypePanelEnable() {
        boolean enable = false;
        if (this.metaclass != null) {
            enable = this.searchMgr.isTypedMetaClass(this.metaclass);
            this.cbxMetaclass.setToolTipText(this.getLabelProvider().getText((Object)this.metaclass));
        }
        this.setDataTypePanelEnabled(enable);
    }

    void handleNotContainSelected() {
        if (this.btnNotContain.getSelection()) {
            this.updatePropertyCriteria();
        }
    }

    void handlePropertySelected() {
        if (this.cbxProperties.getText().equals(MetadataSearch.OBJECT_URI_FEATURE)) {
            this.chkExactMatch.setSelection(true);
            this.btnContains.setEnabled(false);
            this.btnNotContain.setEnabled(false);
        } else {
            this.btnContains.setEnabled(true);
            this.btnNotContain.setEnabled(true);
        }
        this.updatePropertyCriteria();
    }

    void handleRuntimeTypeChanged() {
        this.runtimeType = this.cbxRuntimeType.getText();
        this.searchMgr.setRuntimeType(this.runtimeType);
        this.updateSearchState();
    }

    void handleRuntimeTypeSelected() {
        if (this.btnRuntimeType.getSelection()) {
            this.txfSimpleType.setEnabled(false);
            this.chkIncludeSubtypes.setEnabled(false);
            this.btnBrowseSimpleType.setEnabled(false);
            this.cbxRuntimeType.setEnabled(true);
            this.searchMgr.setRuntimeType(this.runtimeType);
            this.searchMgr.setDatatype(null, false);
            this.updateSearchState();
        }
    }

    void handleSimpleTypeChanged() {
        this.searchMgr.setDatatype((EObject)this.simpleType, this.chkIncludeSubtypes.getSelection());
        this.updateSearchState();
    }

    void handleSimpleTypeSelected() {
        if (this.btnSimpleType.getSelection()) {
            this.cbxRuntimeType.setEnabled(false);
            this.txfSimpleType.setEnabled(true);
            this.btnBrowseSimpleType.setEnabled(true);
            this.chkIncludeSubtypes.setEnabled(true);
            this.searchMgr.setDatatype((EObject)this.simpleType, this.chkIncludeSubtypes.getSelection());
            this.searchMgr.setRuntimeType(null);
            this.updateSearchState();
        }
    }

    void handleTextPatternModified() {
        this.updatePropertyCriteria();
    }

    private void initButtonSelected(Button theButton) {
        this.initButtonSelected(theButton, true);
    }

    private void initButtonSelected(final Button theButton, final boolean theSelectFlag) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                theButton.setSelection(theSelectFlag);
                Event event = new Event();
                event.widget = theButton;
                theButton.notifyListeners(13, event);
            }
        });
    }

    private void initializeDialogSettings() {
        IDialogSettings tempSettings = UiPlugin.getDefault().getDialogSettings();
        this.settings = tempSettings.getSection(this.getClass().getSimpleName());
        if (this.settings == null) {
            this.settings = tempSettings.addNewSection(this.getClass().getSimpleName());
        }
    }

    private boolean isSearchStateValid() {
        boolean result = false;
        boolean useMgr = true;
        if (this.getControl() != null && this.btnMetaclass.getSelection()) {
            if (this.metaclass == null) {
                result = false;
                useMgr = false;
            } else if (this.searchMgr.isTypedMetaClass(this.metaclass)) {
                if (this.btnSimpleType.getSelection() && this.simpleType == null) {
                    result = false;
                    useMgr = false;
                } else if (this.btnRuntimeType.getSelection() && this.runtimeType == null) {
                    result = false;
                    useMgr = false;
                }
            }
        }
        if (useMgr) {
            result = this.searchMgr.canExecute().isOK();
        }
        return result;
    }

    public boolean performAction() {
        this.searchMgr.setModelScope(SearchPageUtil.getModelWorkspaceScope(this.searchPageContainer));
        this.saveState();
        NewSearchUI.runQueryInBackground((ISearchQuery)new MetadataSearchQuery((ISearchEngine)this.searchMgr));
        return true;
    }

    private void restoreState() {
        String[] patterns;
        if (this.settings.getBoolean("anyObjectType")) {
            this.initButtonSelected(this.btnAnyObjectType);
        } else if (this.settings.getBoolean("metaclassType")) {
            this.initButtonSelected(this.btnMetaclass);
        } else {
            this.initButtonSelected(this.btnAnyObjectType);
        }
        this.metaclassMru.clear();
        String[] mru = this.settings.getArray("metaclassMru");
        if (mru != null && mru.length > 0) {
            int i = 0;
            while (i < mru.length) {
                this.metaclassMru.add(mru[i]);
                this.cbxMetaclass.add(this.getMetaclassText(mru[i]));
                ++i;
            }
            String uri = this.settings.get("lastUsedMetaclass");
            if (uri != null && uri.length() > 0) {
                EClass metaclass;
                int index = this.metaclassMru.indexOf(uri);
                if (index == -1) {
                    this.metaclassMru.add(uri);
                    index = 0;
                }
                if ((metaclass = this.getMetaclass(uri)) != null) {
                    this.updateMetaclass(metaclass);
                }
            }
        }
        if (this.settings.getBoolean("includeSubTypes")) {
            this.initButtonSelected(this.chkIncludeSubtypes);
        } else if (this.settings.get("includeSubTypes") == null) {
            // empty if block
        }
        String selectedRuntimeType = this.settings.get("selectedRuntimeType");
        this.updateRuntimeType(selectedRuntimeType);
        if (this.settings.getBoolean("anyDataType")) {
            this.initButtonSelected(this.btnAnyDataType);
        } else if (this.settings.getBoolean("simpleDataType")) {
            this.initButtonSelected(this.btnSimpleType);
        } else if (this.settings.getBoolean("runtimeType")) {
            this.initButtonSelected(this.btnRuntimeType);
        } else {
            this.initButtonSelected(this.btnAnyDataType);
        }
        String uri = this.settings.get("selectedSimpleType");
        if (uri != null && uri.length() > 0) {
            try {
                EObject type = ModelUtilities.getWorkspaceContainer().getEObject(URI.createURI((String)uri), false);
                if (type != null && type instanceof XSDSimpleTypeDefinition) {
                    this.updateSimpleType((XSDSimpleTypeDefinition)type);
                } else {
                    this.settings.put("selectedSimpleType", null);
                }
            }
            catch (CoreException theException) {
                Util.log((Throwable)theException);
            }
        }
        if ((patterns = this.settings.getArray("textPattern")) != null && patterns.length > 0) {
            this.cbxTextPattern.setItems(patterns);
            String txt = this.settings.get("lastUsedTextPattern");
            if (txt != null && txt.length() > 0) {
                this.cbxTextPattern.setText(txt);
            }
        }
        if (this.settings.getBoolean("containsText")) {
            this.initButtonSelected(this.btnContains);
        } else if (this.settings.getBoolean("notContainText")) {
            this.initButtonSelected(this.btnNotContain);
        } else {
            this.initButtonSelected(this.btnContains);
        }
        if (this.settings.getBoolean("exactMatch")) {
            this.initButtonSelected(this.chkExactMatch);
        }
        if (this.settings.getBoolean("includeProperty")) {
            this.initButtonSelected(this.chkIncludeProperty);
        } else if (this.settings.get("includeProperty") == null) {
            this.initButtonSelected(this.chkIncludeProperty);
        } else {
            this.handleIncludePropertySelected();
        }
        if (this.cbxProperties.getItemCount() == 0) {
            this.chkIncludeProperty.setEnabled(false);
            this.handleIncludePropertySelected();
        } else {
            int index;
            String selectedProperty = this.settings.get("selectedProperty");
            if (selectedProperty != null && (index = this.cbxProperties.indexOf(selectedProperty)) != -1) {
                this.cbxProperties.select(index);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MetadataSearchPage.this.handlePropertySelected();
                    }
                });
            }
        }
    }

    private void saveState() {
        int index;
        this.settings.put("anyObjectType", this.btnAnyObjectType.getSelection());
        this.settings.put("metaclassType", this.btnMetaclass.getSelection());
        this.settings.put("anyDataType", this.btnAnyDataType.getSelection());
        this.settings.put("simpleDataType", this.btnSimpleType.getSelection());
        this.settings.put("includeSubTypes", this.chkIncludeSubtypes.getSelection());
        this.settings.put("runtimeType", this.btnRuntimeType.getSelection());
        this.settings.put("includeProperty", this.chkIncludeProperty.getSelection());
        this.settings.put("containsText", this.btnContains.getSelection());
        this.settings.put("notContainText", this.btnNotContain.getSelection());
        this.settings.put("exactMatch", this.chkExactMatch.getSelection());
        this.settings.put("selectedRuntimeType", this.cbxRuntimeType.getText());
        this.settings.put("selectedProperty", this.cbxProperties.getText());
        WidgetUtil.saveSettings((IDialogSettings)this.settings, (String)"textPattern", (Combo)this.cbxTextPattern, (int)20);
        this.settings.put("lastUsedTextPattern", this.cbxTextPattern.getText());
        UiUtil.save((IDialogSettings)this.settings, (String)"metaclassMru", (List)this.metaclassMru, (int)20);
        if (this.metaclass != null && (index = this.cbxMetaclass.getSelectionIndex()) != -1) {
            this.settings.put("lastUsedMetaclass", (String)this.metaclassMru.get(index));
        }
        if (this.simpleType != null) {
            this.settings.put("selectedSimpleType", this.simpleType.getURI());
        }
    }

    public void setContainer(ISearchPageContainer container) {
        this.searchPageContainer = container;
    }

    private void setDataTypePanelEnabled(boolean theEnableFlag) {
        if (theEnableFlag) {
            this.btnAnyDataType.setEnabled(true);
            this.btnSimpleType.setEnabled(true);
            this.btnRuntimeType.setEnabled(true);
            if (this.btnAnyDataType.getSelection()) {
                this.handleAnyDataTypeSelected();
            } else if (this.btnSimpleType.getSelection()) {
                this.handleSimpleTypeSelected();
            } else if (this.btnRuntimeType.getSelection()) {
                this.handleRuntimeTypeSelected();
            }
        } else {
            this.btnAnyDataType.setEnabled(false);
            this.btnSimpleType.setEnabled(false);
            this.txfSimpleType.setEnabled(false);
            this.btnBrowseSimpleType.setEnabled(false);
            this.chkIncludeSubtypes.setEnabled(false);
            this.btnRuntimeType.setEnabled(false);
            this.cbxRuntimeType.setEnabled(false);
            this.searchMgr.setDatatype(null, false);
            this.searchMgr.setRuntimeType(null);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateSearchState();
        }
        super.setVisible(visible);
    }

    private void updatePropertyCriteria() {
        if (this.chkIncludeProperty.getSelection() && this.chkIncludeProperty.getEnabled()) {
            String pattern = this.cbxTextPattern.getText().trim();
            if (!this.chkExactMatch.getSelection() && pattern.length() > 0 && !this.cbxProperties.getText().equals(MetadataSearch.OBJECT_URI_FEATURE)) {
                if (!pattern.startsWith(MetadataSearch.TEXT_PATTERN_ANY_STRING) && !pattern.startsWith(MetadataSearch.TEXT_PATTERN_ANY_CHAR)) {
                    pattern = new StringBuffer().append(MetadataSearch.TEXT_PATTERN_ANY_STRING).append(pattern).toString();
                }
                if (!pattern.endsWith(MetadataSearch.TEXT_PATTERN_ANY_STRING) && !pattern.endsWith(MetadataSearch.TEXT_PATTERN_ANY_CHAR)) {
                    pattern = new StringBuffer().append(pattern).append(MetadataSearch.TEXT_PATTERN_ANY_STRING).toString();
                }
            }
            this.searchMgr.setFeatureCriteria(this.cbxProperties.getText(), pattern, this.btnContains.getSelection());
        } else {
            this.searchMgr.setFeatureCriteria(null, null, false);
        }
        this.updateSearchState();
    }

    private void updateMetaclass(EClass theNewMetaclass) {
        this.metaclass = theNewMetaclass;
        this.searchMgr.setMetaClass(this.metaclass);
        String txt = this.metaclass.getName();
        int index = this.cbxMetaclass.indexOf(txt);
        if (index == -1) {
            this.metaclassMru.add(this.getMetaclassUri(theNewMetaclass));
            this.cbxMetaclass.add(txt);
            index = this.cbxMetaclass.indexOf(txt);
        }
        this.cbxMetaclass.select(index);
        this.cbxMetaclass.setToolTipText(this.getLabelProvider().getText((Object)this.metaclass));
        this.updateSearchState();
    }

    private void updateRuntimeType(String selectedRuntimeType) {
        if (selectedRuntimeType != null) {
            int index = this.cbxRuntimeType.indexOf(selectedRuntimeType);
            if (index != -1) {
                this.cbxRuntimeType.select(index);
            } else if (this.cbxRuntimeType.getItemCount() > 0) {
                this.cbxRuntimeType.select(0);
            }
        } else if (this.cbxRuntimeType.getItemCount() > 0) {
            this.cbxRuntimeType.select(0);
        }
        this.runtimeType = this.cbxRuntimeType.getText();
    }

    private void updateSearchState() {
        this.searchPageContainer.setPerformActionEnabled(this.isSearchStateValid());
    }

    private void updateSimpleType(XSDSimpleTypeDefinition theNewType) {
        this.simpleType = theNewType;
        this.txfSimpleType.setText(ModelUtilities.getEMFLabelProvider().getText((Object)this.simpleType));
        this.updateSearchState();
    }

    static interface DialogSettingsConstants {
        public static final String ANY_OBJ_TYPE = "anyObjectType";
        public static final String METACLASS_TYPE = "metaclassType";
        public static final String METACLASS_MRU = "metaclassMru";
        public static final String LAST_USED_METACLASS = "lastUsedMetaclass";
        public static final String ANY_DATA_TYPE = "anyDataType";
        public static final String SIMPLE_DATA_TYPE = "simpleDataType";
        public static final String SELECTED_SIMPLE_TYPE = "selectedSimpleType";
        public static final String INCLUDE_SUBTYPES = "includeSubTypes";
        public static final String RUNTIME_TYPE = "runtimeType";
        public static final String SELECTED_RUNTIME_TYPE = "selectedRuntimeType";
        public static final String INCLUDE_PROPERTY = "includeProperty";
        public static final String SELECTED_PROPERTY = "selectedProperty";
        public static final String CONTAINS_TEXT = "containsText";
        public static final String NOT_CONTAIN_TEXT = "notContainText";
        public static final String EXACT_MATCH = "exactMatch";
        public static final String TEXT_PATTERN = "textPattern";
        public static final String LAST_USED_TEXT_PATTERN = "lastUsedTextPattern";
        public static final int MRU_LIMIT = 20;
    }
}

