/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.search.ui.text.Match;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.search.runtime.ResourceObjectRecord;
import org.teiid.designer.core.search.runtime.SearchRecord;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.search.IModelObjectMatch;
import org.teiid.designer.ui.search.MetadataMatchInfo;

public final class MetadataMatch
extends Match
implements IModelObjectMatch,
UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(MetadataMatch.class);
    private EObject eObject;
    private String parentPath;
    private final ResourceObjectRecord record;

    public MetadataMatch(MetadataMatchInfo info, ResourceObjectRecord record) {
        super((Object)info, 0, 0);
        this.record = record;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetadataMatch) {
            MetadataMatch match = (MetadataMatch)obj;
            return this.getObjectUri().equals(match.getObjectUri());
        }
        return false;
    }

    @Override
    public EObject getEObject() {
        if (this.eObject == null) {
            URI uri = URI.createURI((String)this.getObjectUri());
            try {
                this.eObject = ModelerCore.getModelContainer().getEObject(uri, true);
                this.parentPath = ModelerCore.getModelEditor().getFullPathToParent(this.eObject).toString();
            }
            catch (CoreException e) {
                Util.log((Throwable)e);
            }
        }
        return this.eObject;
    }

    @Override
    public String getMatchDescription() {
        if (this.eObject == null) {
            return Util.getString(String.valueOf(PREFIX) + "description", new Object[]{this.getName(), this.getName(), this.getMetaclassUri()});
        }
        return Util.getString(String.valueOf(PREFIX) + "description", new Object[]{this.getName(), this.getMetaclassUri(), this.getParentPath()});
    }

    private String getMetaclassUri() {
        return this.record.getMetaclassURI();
    }

    public String getName() {
        return this.record.getName();
    }

    private String getObjectUri() {
        String uri = this.record.getObjectURI();
        assert (uri != null);
        return uri;
    }

    private String getParentPath() {
        if (this.getEObject() == null) {
            return null;
        }
        return this.parentPath;
    }

    @Override
    public String getResourcePath() {
        return this.record.getResourcePath();
    }

    @Override
    public SearchRecord getSearchRecord() {
        return this.record;
    }
}

