/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.teiid.designer.core.refactor.IRefactorModelHandler;
import org.teiid.designer.core.refactor.RefactorModelExtensionManager;
import org.teiid.designer.ui.refactor.AbstractResourcesCompositeChange;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.ui.refactor.rename.RenameResourceDescriptor;
import org.teiid.designer.ui.util.ErrorHandler;

public class RenameResourceCompositeChange
extends AbstractResourcesCompositeChange {
    private final String newName;
    private final IResource resource;

    public RenameResourceCompositeChange(String name, Change[] changes, String newName, IResource resource) {
        super(name, changes);
        this.newName = newName;
        this.resource = resource;
    }

    @Override
    public ChangeDescriptor getDescriptor() {
        String project = this.resource.getProject().getName();
        String description = RefactorResourcesUtils.getString("RenameRefactoring.moveDescriptorDescription", new Object[0]);
        String comment = RefactorResourcesUtils.getString("RenameRefactoring.moveDescriptorComment", new Object[0]);
        RenameResourceDescriptor descriptor = new RenameResourceDescriptor(project, description, comment);
        descriptor.setResourceToRename(this.resource);
        descriptor.setNewName(this.newName);
        return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
    }

    @Override
    protected Change createUndoChange(Change[] childUndos) {
        return new RenameResourceCompositeChange(this.getName(), childUndos, this.newName, this.resource);
    }

    @Override
    protected void postPerform(Change change) {
        try {
            ResourceChange resourceChange;
            Object object;
            Object[] objects = change.getAffectedObjects();
            if (objects != null) {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object2 = objectArray[n2];
                    if (object2 instanceof IResource) {
                        RefactorModelExtensionManager.postProcess((IRefactorModelHandler.RefactorType)IRefactorModelHandler.RefactorType.RENAME, (IResource)((IResource)object2));
                    }
                    ++n2;
                }
            }
            if (change instanceof ResourceChange && (object = (resourceChange = (ResourceChange)change).getModifiedElement()) instanceof IResource) {
                RefactorModelExtensionManager.postProcess((IRefactorModelHandler.RefactorType)IRefactorModelHandler.RefactorType.RENAME, (IResource)((IResource)object));
            }
        }
        catch (Exception ex) {
            ErrorHandler.toExceptionDialog(ex);
        }
    }
}

