/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.extension;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.ModelExtensionAssistantAggregator;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.properties.extension.Messages;
import org.teiid.designer.ui.properties.extension.ModelExtensionPropertyDescriptor;

public class ModelExtensionPropertySource
implements IPropertySource {
    private final EObject eObject;

    public ModelExtensionPropertySource(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject, (String)"eObject is null");
        this.eObject = eObject;
    }

    public Object getEditableValue() {
        return this.eObject;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        String metaclassName = this.eObject.getClass().getName();
        ArrayList propDefns = new ArrayList();
        try {
            ModelExtensionAssistantAggregator aggregator = ExtensionPlugin.getInstance().getModelExtensionAssistantAggregator();
            propDefns.addAll(aggregator.getPropertyDefinitions((Object)this.eObject));
        }
        catch (Exception e) {
            UiConstants.Util.log(4, (Throwable)e, NLS.bind((String)Messages.errorCreatingPropertyDescriptors, (Object)metaclassName));
        }
        if (propDefns.isEmpty()) {
            return new IPropertyDescriptor[0];
        }
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[propDefns.size()];
        int i = 0;
        for (ModelExtensionPropertyDefinition propDefn : propDefns) {
            descriptors[i++] = new ModelExtensionPropertyDescriptor(this.eObject, propDefn);
        }
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (this.isExtensionProperty(id)) {
            return ((ModelExtensionPropertyDescriptor)id).getPropertyValue();
        }
        UiConstants.Util.log(4, NLS.bind((String)Messages.unexpectedPropertySourceId, (Object)id));
        return null;
    }

    public boolean isExtensionProperty(Object object) {
        CoreArgCheck.isNotNull((Object)object, (String)"object is null");
        return object instanceof ModelExtensionPropertyDescriptor;
    }

    public boolean isPropertySet(Object id) {
        return this.getPropertyValue(id) != null;
    }

    public void resetPropertyValue(Object id) {
        this.setPropertyValue(id, null);
    }

    public void setPropertyValue(Object id, Object value) {
        if (this.isExtensionProperty(id)) {
            ((ModelExtensionPropertyDescriptor)id).setPropertyValue(value);
        } else {
            UiConstants.Util.log(4, NLS.bind((String)Messages.unexpectedPropertySourceId, (Object)id.getClass().getName()));
        }
    }
}

