/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.preferences.IEditorPreferencesComponent;
import org.teiid.designer.ui.common.preferences.IEditorPreferencesValidationListener;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.table.EObjectPropertiesOrderPreferences;
import org.teiid.designer.ui.table.PropertyOrder;

public class TableEditorPreferencesComponent
implements IEditorPreferencesComponent {
    private static final String DESCRIPTION = UiPlugin.getDefault().getPluginUtil().getString("TableEditorPreferencesComponent.description", new Object[0]);
    static final String VISIBLE_HEADER = UiPlugin.getDefault().getPluginUtil().getString("TableEditorPreferencesComponent.visibleHeader", new Object[0]);
    static final String YES = UiPlugin.getDefault().getPluginUtil().getString("TableEditorPreferencesComponent.yes", new Object[0]);
    static final String NO = UiPlugin.getDefault().getPluginUtil().getString("TableEditorPreferencesComponent.no", new Object[0]);
    private static final String VALIDATION_ERROR = UiPlugin.getDefault().getPluginUtil().getString("TableEditorPreferencesComponent.validationErrorAllColumnsHidden", new Object[0]);
    private static final String TABLE_LABEL = UiPlugin.getDefault().getPluginUtil().getString("TableEditorPreferencesComponent.tableLabel", new Object[0]);
    private static final String COLUMNS_LABEL = UiPlugin.getDefault().getPluginUtil().getString("TableEditorPreferencesComponent.columnsLabel", new Object[0]);
    private static final String UP = UiPlugin.getDefault().getPluginUtil().getString("TableEditorPreferencesComponent.upLabel", new Object[0]);
    private static final String DOWN = UiPlugin.getDefault().getPluginUtil().getString("TableEditorPreferencesComponent.downLabel", new Object[0]);
    private static final String RESTORE_DEFAULTS = UiPlugin.getDefault().getPluginUtil().getString("TableEditorPreferencesComponent.restoreDefaults", new Object[0]);
    private ListViewer eObjectListViewer;
    TableViewer columnTableViewer;
    private EObjectPropertiesOrderPreferences modelTableColumnUtils;
    private Map columnArrays = new HashMap();
    ArrayList modifiedEObjects = new ArrayList();
    private String columnHeader = UiPlugin.getDefault().getPluginUtil().getString("TableEditorPreferencesComponent.columnHeader", new Object[0]);
    private ArrayList validationListeners = new ArrayList();
    private Button upButton;
    private Button downButton;

    public TableEditorPreferencesComponent() {
        this.modelTableColumnUtils = UiPlugin.getDefault().getEObjectPropertiesOrderPreferences();
        this.initializeColumnArrays();
    }

    private void initializeColumnArrays() {
        for (String eObject : this.modelTableColumnUtils.getInitializedEObjects()) {
            ArrayList columnArrayList = this.modelTableColumnUtils.getOrderedPropertyList(eObject);
            columnArrayList = this.cloneList(columnArrayList);
            PropertyOrder[] columnOrders = columnArrayList.toArray(new PropertyOrder[0]);
            this.columnArrays.put(eObject, columnOrders);
        }
    }

    private ArrayList cloneList(ArrayList list) {
        ArrayList<Object> newList = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            Object newObject = ((PropertyOrder)list.get(i)).clone();
            newList.add(newObject);
            ++i;
        }
        return newList;
    }

    void populateColumnsList() {
        String eObject = this.getEObjectSelection();
        if (eObject == null) {
            this.columnTableViewer.setInput(new ArrayList());
        } else {
            this.columnTableViewer.setInput(this.columnArrays.get(eObject));
        }
    }

    public Composite createEditorPreferencesComponent(Composite parent) {
        Composite columnComposite = new Composite(parent, 0);
        GridLayout columnLayout = new GridLayout();
        columnLayout.numColumns = 3;
        columnLayout.marginHeight = 8;
        columnLayout.marginWidth = 8;
        columnComposite.setLayout((Layout)columnLayout);
        Text text = new Text(columnComposite, 72);
        text.setText(DESCRIPTION);
        GridData textData = new GridData();
        textData.horizontalSpan = 3;
        text.setLayoutData((Object)textData);
        WidgetFactory.createLabel((Composite)columnComposite, (int)32, (String)TABLE_LABEL);
        WidgetFactory.createLabel((Composite)columnComposite, (int)32, (String)COLUMNS_LABEL);
        Composite buttonComposite = new Composite(columnComposite, 0);
        GridData buttonData = new GridData();
        buttonData.verticalSpan = 2;
        buttonData.verticalAlignment = 2;
        buttonData.horizontalAlignment = 1;
        buttonComposite.setLayoutData((Object)buttonData);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonComposite.setLayout((Layout)buttonLayout);
        this.upButton = WidgetFactory.createButton((Composite)buttonComposite, (String)UP, (int)772);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditorPreferencesComponent.this.moveColumnUp();
            }
        });
        this.downButton = WidgetFactory.createButton((Composite)buttonComposite, (String)DOWN, (int)772);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditorPreferencesComponent.this.moveColumnDown();
            }
        });
        this.eObjectListViewer = new ListViewer(columnComposite, 2048);
        this.eObjectListViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.eObjectListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.eObjectListViewer.addSelectionChangedListener((ISelectionChangedListener)new TableSelectionChangedListener());
        Menu popupMenu = new Menu(this.eObjectListViewer.getControl());
        MenuItem item = new MenuItem(popupMenu, 0);
        item.setText(RESTORE_DEFAULTS);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditorPreferencesComponent.this.performDefaults();
            }
        });
        this.eObjectListViewer.getControl().setMenu(popupMenu);
        GridData tableData = new GridData(1808);
        this.eObjectListViewer.getControl().setLayoutData((Object)tableData);
        int tableStyle = 68096;
        this.columnTableViewer = new TableViewer(columnComposite, tableStyle);
        this.columnTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.columnTableViewer.setLabelProvider((IBaseLabelProvider)new ColumnOrderLabelProvider());
        Table table = this.columnTableViewer.getTable();
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditorPreferencesComponent.this.setUpDownButtonState();
            }
        });
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(this.columnHeader);
        column1.setWidth(100);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(VISIBLE_HEADER);
        column2.setWidth(50);
        table.pack();
        GridData columnData = new GridData(1808);
        table.setLayoutData((Object)columnData);
        CellEditor[] cellEditors = new CellEditor[2];
        cellEditors[1] = new CheckboxCellEditor((Composite)table, 0);
        this.columnTableViewer.setCellEditors(cellEditors);
        this.columnTableViewer.setCellModifier((ICellModifier)new ColumnCellModifier());
        this.columnTableViewer.setColumnProperties(new String[]{this.columnHeader, VISIBLE_HEADER});
        this.refreshLists();
        this.setUpDownButtonState();
        this.validate();
        return columnComposite;
    }

    private void refreshLists() {
        ArrayList eObjects = new ArrayList(this.columnArrays.keySet());
        Collections.sort(eObjects);
        this.eObjectListViewer.setInput(eObjects);
        if (eObjects.size() > 0) {
            ((List)this.eObjectListViewer.getControl()).setSelection(0);
            this.populateColumnsList();
        } else {
            this.columnTableViewer.setInput(new ArrayList());
        }
    }

    void moveColumnUp() {
        int selectionIndex = this.getColumnOrderSelectionIndex();
        if (selectionIndex > -1) {
            PropertyOrder temp = this.getCurrentColumnOrderArray()[selectionIndex];
            this.getCurrentColumnOrderArray()[selectionIndex] = this.getCurrentColumnOrderArray()[selectionIndex - 1];
            this.getCurrentColumnOrderArray()[selectionIndex - 1] = temp;
            this.columnTableViewer.refresh();
            this.setColumnSelection(selectionIndex - 1);
            this.setUpDownButtonState();
        }
        ((Table)this.columnTableViewer.getControl()).setFocus();
        this.modifiedEObjects.add(this.getEObjectSelection());
    }

    void moveColumnDown() {
        int selectionIndex = this.getColumnOrderSelectionIndex();
        if (selectionIndex < this.getCurrentColumnOrderArray().length - 1 && selectionIndex > -1) {
            PropertyOrder temp = this.getCurrentColumnOrderArray()[selectionIndex];
            this.getCurrentColumnOrderArray()[selectionIndex] = this.getCurrentColumnOrderArray()[selectionIndex + 1];
            this.getCurrentColumnOrderArray()[selectionIndex + 1] = temp;
            this.columnTableViewer.refresh();
            this.setColumnSelection(selectionIndex + 1);
            this.setUpDownButtonState();
        }
        ((Table)this.columnTableViewer.getControl()).setFocus();
        this.modifiedEObjects.add(this.getEObjectSelection());
    }

    private void setColumnSelection(int index) {
        ((Table)this.columnTableViewer.getControl()).setSelection(index);
    }

    private PropertyOrder[] getCurrentColumnOrderArray() {
        return (PropertyOrder[])this.columnArrays.get(this.getEObjectSelection());
    }

    String getEObjectSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.eObjectListViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (String)selection.getFirstElement();
    }

    private int getColumnOrderSelectionIndex() {
        Table table = (Table)this.columnTableViewer.getControl();
        return table.getSelectionIndex();
    }

    public String getName() {
        return TABLE_LABEL;
    }

    public String getTooltip() {
        return TABLE_LABEL;
    }

    public void performDefaults() {
        String eObject = this.getEObjectSelection();
        if (eObject != null) {
            this.columnArrays.remove(eObject);
        }
        this.modifiedEObjects.add(eObject);
        this.refreshLists();
        this.setUpDownButtonState();
        this.validate();
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.modifiedEObjects.size()) {
            String eObject = (String)this.modifiedEObjects.get(i);
            if (!this.columnArrays.containsKey(eObject)) {
                this.modelTableColumnUtils.removeEObject(eObject);
            } else {
                PropertyOrder[] columns = (PropertyOrder[])this.columnArrays.get(eObject);
                int x = 0;
                while (x < columns.length) {
                    columns[x].setOrder(x + 1);
                    ++x;
                }
                this.modelTableColumnUtils.replaceColumnsList(eObject, this.getListFromArray(columns));
            }
            ++i;
        }
        this.modelTableColumnUtils.firePropertiesChanged(this.modifiedEObjects);
        UiPlugin.getDefault().extractModelTableColumnUtilsToPreferenceStore();
        return true;
    }

    private ArrayList getListFromArray(PropertyOrder[] columns) {
        ArrayList<PropertyOrder> list = new ArrayList<PropertyOrder>();
        int i = 0;
        while (i < columns.length) {
            list.add(columns[i]);
            ++i;
        }
        return list;
    }

    void setUpDownButtonState() {
        this.upButton.setEnabled(this.getColumnOrderSelectionIndex() > 0);
        this.downButton.setEnabled(this.getColumnOrderSelectionIndex() > -1 && this.getColumnOrderSelectionIndex() < this.getCurrentColumnOrderArray().length - 1);
    }

    void clearColumnSelection() {
        this.columnTableViewer.getTable().setSelection(-1);
    }

    public void addValidationListener(IEditorPreferencesValidationListener listener) {
        this.validationListeners.add(listener);
    }

    public void removeValidationListener(IEditorPreferencesValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    public void fireValidationStatus(boolean validationStatus, String message) {
        int i = 0;
        while (i < this.validationListeners.size()) {
            ((IEditorPreferencesValidationListener)this.validationListeners.get(i)).validationStatus(validationStatus, message);
            ++i;
        }
    }

    public void validate() {
        boolean valid = true;
        for (Object key : this.columnArrays.keySet()) {
            boolean eObjectValid = false;
            PropertyOrder[] columnOrders = (PropertyOrder[])this.columnArrays.get(key);
            int i = 0;
            while (i < columnOrders.length) {
                if (columnOrders[i].isVisible()) {
                    eObjectValid = true;
                    break;
                }
                ++i;
            }
            if (eObjectValid) continue;
            valid = false;
            break;
        }
        if (valid) {
            this.fireValidationStatus(valid, null);
        } else {
            this.fireValidationStatus(valid, VALIDATION_ERROR);
        }
    }

    class ColumnCellModifier
    implements ICellModifier {
        ColumnCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(VISIBLE_HEADER);
        }

        public Object getValue(Object element, String property) {
            return new Boolean(((PropertyOrder)element).isVisible());
        }

        public void modify(Object element, String property, Object value) {
            PropertyOrder columnOrder = (PropertyOrder)((TableItem)element).getData();
            columnOrder.setVisible((Boolean)value);
            TableEditorPreferencesComponent.this.columnTableViewer.update((Object)columnOrder, null);
            TableEditorPreferencesComponent.this.modifiedEObjects.add(TableEditorPreferencesComponent.this.getEObjectSelection());
            TableEditorPreferencesComponent.this.validate();
        }
    }

    class ColumnOrderLabelProvider
    implements ITableLabelProvider {
        ColumnOrderLabelProvider() {
        }

        public String getText(Object element) {
            return element.toString();
        }

        public Image getImage(Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PropertyOrder columnOrder = (PropertyOrder)element;
            if (columnIndex == 0) {
                return columnOrder.getName();
            }
            return columnOrder.isVisible() ? YES : NO;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class TableLabelProvider
    implements ILabelProvider {
        TableLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return CoreStringUtil.computePluralForm((String)CoreStringUtil.computeDisplayableForm((String)element.toString()));
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class TableSelectionChangedListener
    implements ISelectionChangedListener {
        TableSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TableEditorPreferencesComponent.this.clearColumnSelection();
            TableEditorPreferencesComponent.this.populateColumnsList();
            TableEditorPreferencesComponent.this.setUpDownButtonState();
        }
    }
}

