/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.preferences.IGeneralPreferencePageContributor;

public final class GeneralPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
UiConstants,
UiConstants.ExtensionPoints {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(GeneralPreferencePage.class);
    private static final String DEFAULT_CATEGORY_ID = "generalPreference.defaultCategory.id";
    private static final String DEFAULT_CATEGORY_NAME = Util.getStringOrKey(String.valueOf(PREFIX) + "defaultCategory.name");
    private static final PreferenceCategory DEFAULT_CATEGORY = new PreferenceCategory();
    private Map<String, PreferenceCategory> categoryMap;
    private Map<String, GeneralPreference> preferenceMap;

    static {
        GeneralPreferencePage.DEFAULT_CATEGORY.id = DEFAULT_CATEGORY_ID;
        GeneralPreferencePage.DEFAULT_CATEGORY.name = DEFAULT_CATEGORY_NAME;
    }

    public GeneralPreferencePage() {
        this.setDescription(Util.getStringOrKey(String.valueOf(PREFIX) + "description"));
        this.categoryMap = new HashMap<String, PreferenceCategory>();
        this.preferenceMap = new TreeMap<String, GeneralPreference>();
        this.processExtensions();
    }

    private Group constructGroup(Composite theParent, String theName) {
        Group result = WidgetFactory.createGroup((Composite)theParent, (String)theName, (int)768);
        result.setLayoutData((Object)new GridData(768));
        result.setText(theName);
        return result;
    }

    protected Control createContents(Composite theParent) {
        Composite pnlMain = new Composite(theParent, 0);
        pnlMain.setLayout((Layout)new GridLayout());
        pnlMain.setLayoutData((Object)new GridData(1808));
        this.createExtensionContents(pnlMain);
        return theParent;
    }

    private void createExtensionContents(Composite theParent) {
        TreeMap<String, Group> groupMap = new TreeMap<String, Group>();
        for (GeneralPreference pref : this.preferenceMap.values()) {
            Group group = (Group)groupMap.get(pref.categoryId);
            if (group == null) {
                PreferenceCategory category = this.categoryMap.get(pref.categoryId);
                if (category == null) {
                    category = DEFAULT_CATEGORY;
                    group = (Group)groupMap.get(category.id);
                    Object[] params = new Object[]{pref.categoryId, pref.id};
                    Util.log(4, Util.getString(String.valueOf(PREFIX) + "invalidCategoryId", params));
                }
                if (group == null) {
                    group = this.constructGroup(theParent, category.name);
                }
                groupMap.put(category.id, group);
            }
            try {
                pref.contributor.createPreferenceEditor((Composite)group);
            }
            catch (Exception exception) {
                Util.log(4, Util.getString(String.valueOf(PREFIX) + "preferenceEditorError", (Object)pref.contributor.getClass().getName()));
            }
        }
    }

    public void init(IWorkbench theWorkbench) {
        for (GeneralPreference pref : this.preferenceMap.values()) {
            try {
                pref.contributor.setWorkbench(theWorkbench);
            }
            catch (Exception theException) {
                Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "unexpectedErrorSettingWorkbench", (Object)pref.id));
            }
        }
    }

    public boolean performCancel() {
        boolean result = true;
        for (GeneralPreference pref : this.preferenceMap.values()) {
            try {
                boolean successful = pref.contributor.performCancel();
                if (successful) continue;
                result = false;
            }
            catch (Exception theException) {
                result = false;
                Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "performCancelError", (Object)pref.id));
            }
        }
        return result;
    }

    protected void performDefaults() {
        for (GeneralPreference pref : this.preferenceMap.values()) {
            try {
                pref.contributor.performDefaults();
            }
            catch (Exception theException) {
                Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "performDefaultsError", (Object)pref.id));
            }
        }
        super.performDefaults();
    }

    public boolean performOk() {
        boolean result = true;
        for (GeneralPreference pref : this.preferenceMap.values()) {
            try {
                boolean successful = pref.contributor.performOk();
                if (successful) continue;
                result = false;
            }
            catch (Exception theException) {
                Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "performOkError", (Object)pref.id));
                result = false;
            }
        }
        return result;
    }

    private boolean processCategory(IConfigurationElement theExtension) {
        boolean result = true;
        String categoryId = null;
        String categoryName = null;
        try {
            Object[] params;
            categoryId = theExtension.getAttribute("id");
            if (CoreStringUtil.isEmpty((String)categoryId)) {
                Util.log(4, Util.getString(String.valueOf(PREFIX) + "nullCategoryId", (Object)theExtension.getDeclaringExtension().getExtensionPointUniqueIdentifier()));
                result = false;
            }
            if (result && this.categoryMap.get(categoryId) != null) {
                params = new Object[]{categoryId, theExtension.getDeclaringExtension().getExtensionPointUniqueIdentifier()};
                Util.log(4, Util.getString(String.valueOf(PREFIX) + "duplicateCategoryId", params));
                result = false;
            }
            if (result && CoreStringUtil.isEmpty((String)(categoryName = theExtension.getAttribute("name")))) {
                params = new Object[]{categoryId, theExtension.getDeclaringExtension().getExtensionPointUniqueIdentifier()};
                Util.log(4, Util.getString(String.valueOf(PREFIX) + "nullCategoryName", params));
                result = false;
            }
        }
        catch (Exception exception) {
            Util.log(4, Util.getString(String.valueOf(PREFIX) + "unexpectedCategoryError", (Object)theExtension.getDeclaringExtension().getExtensionPointUniqueIdentifier()));
            result = false;
        }
        if (result) {
            PreferenceCategory category = new PreferenceCategory();
            category.id = categoryId;
            category.name = categoryName;
            this.categoryMap.put(category.id, category);
        }
        return result;
    }

    private void processExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "generalPreferenceContributor");
        CoreArgCheck.isNotNull((Object)extensionPoint, (String)Util.getString(String.valueOf(PREFIX) + "noExtensionPointFound", (Object)"generalPreferenceContributor"));
        try {
            IExtension[] extensions = extensionPoint.getExtensions();
            if (extensions.length != 0) {
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        if (elements[j].getName().equals("category")) {
                            this.processCategory(elements[j]);
                        } else if (elements[j].getName().equals("preference")) {
                            this.processPreference(elements[j]);
                        } else {
                            CoreArgCheck.isTrue((boolean)false, (String)Util.getString(String.valueOf(PREFIX) + "unknownConfigurationElement", (Object)elements[j].getName()));
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception theException) {
            Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "unexpectedErrorProcessingExtensions", (Object)"generalPreferenceContributor"));
        }
    }

    private boolean processPreference(IConfigurationElement theExtension) {
        boolean result = true;
        String prefId = null;
        String categoryId = null;
        IGeneralPreferencePageContributor contributor = null;
        try {
            prefId = theExtension.getAttribute("id");
            if (CoreStringUtil.isEmpty((String)prefId)) {
                Util.log(4, Util.getString(String.valueOf(PREFIX) + "nullPreferenceId", (Object)theExtension.getDeclaringExtension().getExtensionPointUniqueIdentifier()));
                result = false;
            }
            if (result && this.preferenceMap.get(prefId) != null) {
                Object[] params = new Object[]{prefId, theExtension.getDeclaringExtension().getExtensionPointUniqueIdentifier()};
                Util.log(4, Util.getString(String.valueOf(PREFIX) + "duplicatePreferenceId", params));
                result = false;
            }
            if (result && CoreStringUtil.isEmpty((String)(categoryId = theExtension.getAttribute("categoryId")))) {
                categoryId = DEFAULT_CATEGORY_ID;
            }
            if (result) {
                Object obj = theExtension.createExecutableExtension("class");
                if (obj instanceof IGeneralPreferencePageContributor) {
                    contributor = (IGeneralPreferencePageContributor)obj;
                } else {
                    Object[] params = new Object[]{theExtension.getClass().getName(), theExtension.getDeclaringExtension().getExtensionPointUniqueIdentifier()};
                    Util.log(4, Util.getString(String.valueOf(PREFIX) + "incorrectClass", params));
                    result = false;
                }
            }
        }
        catch (Exception exception) {
            Util.log(4, Util.getString(String.valueOf(PREFIX) + "unexpectedPreferenceError", (Object)theExtension.getDeclaringExtension().getExtensionPointUniqueIdentifier()));
            result = false;
        }
        if (result) {
            GeneralPreference pref = new GeneralPreference();
            pref.id = prefId;
            pref.categoryId = categoryId;
            pref.contributor = contributor;
            this.preferenceMap.put(pref.id, pref);
        }
        return result;
    }

    public void setTitle(String theTitle) {
        String title = theTitle;
        String key = String.valueOf(PREFIX) + "title";
        if (Util.keyExists(key)) {
            title = Util.getString(key, new Object[0]);
        }
        super.setTitle(title);
    }

    class GeneralPreference {
        String id;
        String categoryId;
        IGeneralPreferencePageContributor contributor;

        GeneralPreference() {
        }
    }

    static class PreferenceCategory {
        String id;
        String name;

        PreferenceCategory() {
        }
    }
}

