/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.forms;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class FormUtil {
    public static final String HTML_BEGIN = "<form><p>";
    public static final String HTML_END = "</p></form>";

    public static Section createSection(final IManagedForm managedForm, FormToolkit toolkit, Composite parent, String title, String description, int style, boolean shouldGiveUpVerticalSpaceWhenFolded) {
        final Section section = toolkit.createSection(parent, style);
        section.setText(title);
        section.setDescription(description);
        section.getDescriptionControl().setFont(JFaceResources.getBannerFont());
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        section.clientVerticalSpacing = 5;
        section.descriptionVerticalSpacing = 5;
        section.marginHeight = 5;
        section.titleBarTextMarginWidth = 5;
        managedForm.addPart((IFormPart)new SectionPart(section));
        if (shouldGiveUpVerticalSpaceWhenFolded) {
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    GridData gridData = (GridData)section.getLayoutData();
                    gridData.grabExcessVerticalSpace = e.getState();
                }
            });
        }
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                managedForm.reflow(true);
            }
        });
        return section;
    }

    public static Button[] createSectionToolBar(Section section, FormToolkit toolkit, Image[] buttonImages) {
        Composite toolBar = FormUtil.createSectionToolBar(section, toolkit);
        Image backgroundImage = section.getBackgroundImage();
        Button[] buttons = new Button[buttonImages.length];
        int i = 0;
        Image[] imageArray = buttonImages;
        int n = buttonImages.length;
        int n2 = 0;
        while (n2 < n) {
            Image image = imageArray[n2];
            Button button = toolkit.createButton(toolBar, null, 0x800000);
            button.setBackgroundImage(backgroundImage);
            button.setImage(image);
            buttons[i++] = button;
            ++n2;
        }
        return buttons;
    }

    public static Button[] createSectionToolBar(Section section, FormToolkit toolkit, Object[] buttonObjects, int[] buttonStyles) {
        Composite toolBar = toolkit.createComposite((Composite)section, 0);
        GridLayout layout = new GridLayout(buttonObjects.length, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        toolBar.setLayout((Layout)layout);
        section.setTextClient((Control)toolBar);
        Image backgroundImage = section.getBackgroundImage();
        Button[] buttons = new Button[buttonObjects.length];
        int i = 0;
        Object[] objectArray = buttonObjects;
        int n = buttonObjects.length;
        int n2 = 0;
        while (n2 < n) {
            GridData gd;
            Button button;
            Object obj = objectArray[n2];
            if (obj instanceof Image) {
                button = toolkit.createButton(toolBar, null, buttonStyles[i]);
                button.setBackgroundImage(backgroundImage);
                button.setImage((Image)obj);
                buttons[i++] = button;
                gd = new GridData(1, 2, false, false);
                gd.heightHint = 20;
                button.setLayoutData((Object)gd);
            } else if (obj instanceof String) {
                button = toolkit.createButton(toolBar, null, buttonStyles[i]);
                button.setText((String)obj);
                buttons[i++] = button;
                gd = new GridData(1, 2, false, false);
                gd.heightHint = 20;
                button.setLayoutData((Object)gd);
            }
            ++n2;
        }
        return buttons;
    }

    public static Composite createSectionToolBar(Section section, FormToolkit toolkit) {
        Composite toolBar = toolkit.createComposite((Composite)section, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.spacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        toolBar.setLayout((Layout)layout);
        section.setTextClient((Control)toolBar);
        return toolBar;
    }

    public static Button[] createSectionToolBar(Section section, FormToolkit toolkit, String[] actions) {
        Composite toolBar = FormUtil.createSectionToolBar(section, toolkit);
        Button[] buttons = new Button[actions.length];
        int i = 0;
        String[] stringArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            Button button = toolkit.createButton(toolBar, null, 0x800000);
            button.setText(text);
            buttons[i++] = button;
            ++n2;
        }
        return buttons;
    }

    public static boolean safeEquals(Object leftVal, Object rightVal) {
        if (leftVal == null) {
            return rightVal == null;
        }
        return leftVal.equals(rightVal);
    }

    public static boolean safeEquals(String leftVal, String rightVal, boolean treatNullAsEmpty) {
        if (leftVal == null) {
            return rightVal == null || treatNullAsEmpty && rightVal.length() == 0;
        }
        if (leftVal.length() == 0) {
            if (rightVal == null) {
                return treatNullAsEmpty;
            }
            return rightVal.length() == 0;
        }
        return leftVal.equals(rightVal);
    }

    public static ScrolledForm getScrolledForm(Control c) {
        Composite parent = c.getParent();
        while (parent != null) {
            if (parent instanceof ScrolledForm) {
                return (ScrolledForm)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static void tweakColors(FormToolkit ftk, Display display) {
        ftk.refreshHyperlinkColors();
        HyperlinkGroup hlg = ftk.getHyperlinkGroup();
        if (hlg.getActiveForeground() == null) {
            hlg.setActiveForeground(display.getSystemColor(3));
            hlg.setForeground(display.getSystemColor(9));
        }
    }
}

