/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.forms;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.teiid.designer.ui.forms.ComponentSetEvent;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.DialogProvider;
import org.teiid.designer.ui.forms.FormTextObjectEditor;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.forms.SimpleComponentSet;

public class FormTextComponentSet
extends SimpleComponentSet {
    FormTextObjectEditor fText;
    ComponentSetMonitor mon;
    private final String addText;
    private final boolean valueClickable;
    final DialogProvider provider;

    public FormTextComponentSet(String id, String labelName, String addText, boolean valueClickable, DialogProvider provider) {
        super(id, labelName);
        this.addText = addText;
        this.valueClickable = valueClickable;
        this.provider = provider;
    }

    @Override
    protected void addControls(Composite parent, FormToolkit ftk) {
        this.fText = new FormTextObjectEditor(this.addText, this.provider.getLaunchButtonText(), this.valueClickable){

            @Override
            protected Object changeValue(Object startingValue) {
                Object newVal;
                FormTextComponentSet.this.provider.showDialog(FormTextComponentSet.this.fText.getFormText().getShell(), startingValue);
                if (!FormTextComponentSet.this.provider.wasCancelled() && !FormUtil.safeEquals(newVal = FormTextComponentSet.this.provider.getValue(), startingValue)) {
                    ComponentSetEvent componentSetEvent = null;
                    if (FormTextComponentSet.this.mon != null) {
                        componentSetEvent = new ComponentSetEvent(FormTextComponentSet.this, newVal == null, newVal);
                        FormTextComponentSet.this.mon.update(componentSetEvent);
                    }
                    if (componentSetEvent == null || componentSetEvent.doit) {
                        return newVal;
                    }
                }
                return startingValue;
            }

            @Override
            protected void valueClicked(Object value) {
                FormTextComponentSet.this.valueClicked(value);
            }

            @Override
            protected String getDisplayString(Object value) {
                return FormTextComponentSet.this.getUserDisplayString(value);
            }
        };
        Control c = this.fText.addControl(FormUtil.getScrolledForm((Control)parent), parent, ftk);
        TableWrapData twd = new TableWrapData(256, 16);
        c.setLayoutData((Object)twd);
    }

    @Override
    protected void addMonitor(ComponentSetMonitor monitor) {
        this.mon = monitor;
    }

    @Override
    protected void removeMonitor(ComponentSetMonitor monitor) {
        this.mon = null;
    }

    @Override
    public boolean isUserSet() {
        return this.fText.getValue() != null;
    }

    @Override
    public void setValue(Object o) {
        this.fText.setValue(o);
    }

    @Override
    public void reset() {
        this.fText.setValue(null);
    }

    protected String getUserDisplayString(Object o) {
        return o.toString();
    }

    protected void valueClicked(Object value) {
    }

    @Override
    public void setEditible(boolean enabled) {
        super.setEditible(enabled);
        this.fText.getFormText().setEnabled(true);
        this.fText.setEditible(enabled);
    }
}

