/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.part.PageBook;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;

public class ModelObjectEditorPanel
implements IAdaptable,
FocusListener,
IPropertyListener {
    static final String RESTORE = UiConstants.Util.getString("ModelObjectEditorPanel.restore", new Object[0]);
    static final String MAXIMIZE = UiConstants.Util.getString("ModelObjectEditorPanel.maximize", new Object[0]);
    static final String CLOSE = UiConstants.Util.getString("ModelObjectEditorPanel.close", new Object[0]);
    private static final char DIRTY_CHAR = '*';
    private MultiPageModelEditor modelEditor;
    CLabel titleLabel;
    ToolBar toolBar;
    private ToolBarManager toolBarMgr;
    private MenuManager menuMgr;
    boolean isZoomed = false;
    private Action closeAction;
    private ViewForm control;
    private ArrayList editorList = new ArrayList();
    private PageBook pageBook;
    ModelObjectEditorPage activeEditor;
    private List focusListeners = new ArrayList();

    public ModelObjectEditorPanel(MultiPageModelEditor modelEditor, Composite parent, int style) {
        this.modelEditor = modelEditor;
        this.createControl(parent);
        modelEditor.addPropertyListener(this);
    }

    public void createControl(Composite parent) {
        if (this.control != null && !this.control.isDisposed()) {
            return;
        }
        this.control = new ViewForm(parent, 2048);
        this.control.setLayoutData((Object)new GridData(1808));
        this.control.marginWidth = 0;
        this.control.marginHeight = 0;
        this.createTitleBar();
        this.createToolBar();
        this.createPageBook();
        if (this.control.getContent() == null) {
            this.control.setTabList(new Control[]{this.toolBar});
        } else {
            this.control.setTabList(new Control[]{this.toolBar, this.control.getContent()});
        }
    }

    protected void createPageBook() {
        this.pageBook = new PageBook((Composite)this.control, 0);
        this.control.setContent((Control)this.pageBook);
        this.setVisible(false);
    }

    private void addModelObjectEditor(ModelObjectEditorPage editor) {
        if (!this.editorList.contains(editor)) {
            editor.createControl((Composite)this.pageBook);
            this.editorList.add(editor);
        }
    }

    public void activateModelObjectEditor(ModelObjectEditorPage editor, Object object) {
        if (this.deactivate(false)) {
            if (editor == this.activeEditor) {
                this.activeEditor.edit(object);
                this.toolBarMgr.update(true);
                this.updateTitles();
            } else {
                this.addModelObjectEditor(editor);
                editor.edit(object);
                this.activeEditor = editor;
                this.pageBook.showPage(editor.getControl());
                editor.contributeToolbarActions(this.toolBarMgr);
                if (editor.canClose()) {
                    this.toolBarMgr.add((IAction)this.closeAction);
                }
                this.toolBarMgr.update(true);
                this.updateTitles();
                this.activeEditor.addPropertyListener(this);
            }
        }
        this.setVisible(true);
    }

    public void addFocusListener(FocusListener listener) {
        this.focusListeners.add(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.focusListeners.remove(listener);
    }

    public void firefocusGained(FocusEvent fe) {
        Iterator iter = this.focusListeners.iterator();
        while (iter.hasNext()) {
            ((FocusListener)iter.next()).focusGained(fe);
        }
        this.updateForFocus();
    }

    public void firefocusLost(FocusEvent fe) {
        Iterator iter = this.focusListeners.iterator();
        while (iter.hasNext()) {
            ((FocusListener)iter.next()).focusLost(fe);
        }
    }

    public boolean hasFocus() {
        return this.hasFocus((Control)this.control);
    }

    private boolean hasFocus(Control control) {
        if (control.isFocusControl()) {
            return true;
        }
        if (control instanceof Composite) {
            Control[] kids = ((Composite)control).getChildren();
            int i = 0;
            while (i < kids.length) {
                if (this.hasFocus(kids[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void focusLost(FocusEvent fe) {
        this.firefocusLost(fe);
    }

    public void focusGained(FocusEvent fe) {
        this.firefocusGained(fe);
    }

    public void updateForFocus() {
        if (this.getActiveEditor() != null) {
            this.getActiveEditor().updateReadOnlyState();
        }
    }

    public Object getAdapter(Class key) {
        Object oResult = null;
        if (key.equals(IFindReplaceTarget.class)) {
            Object oAdapter;
            IEditorPart editorPage;
            if (this.activeEditor != null && this.activeEditor instanceof IAdaptable) {
                oResult = ((IAdaptable)this.activeEditor).getAdapter(IFindReplaceTarget.class);
            }
            if (oResult == null && this.modelEditor != null && this.modelEditor instanceof ModelEditor && (editorPage = ((ModelEditor)this.modelEditor).getCurrentPage()) != null && (oAdapter = editorPage.getAdapter(IFindReplaceTarget.class)) != null && oAdapter instanceof IFindReplaceTarget) {
                oResult = oAdapter;
            }
        }
        return oResult;
    }

    public ActionService getActionService() {
        IEditorPart editorPage = ((ModelEditor)this.modelEditor).getCurrentPage();
        if (editorPage != null) {
            return UiPlugin.getDefault().getActionService(editorPage.getSite().getPage());
        }
        return null;
    }

    public void saveEditorState(boolean isClosing) {
        if (this.activeEditor != null && this.activeEditor.isDirty()) {
            this.activeEditor.doSave(isClosing);
        }
    }

    public boolean close() {
        return this.deactivate(true);
    }

    boolean deactivate(boolean closePanel) {
        boolean result = false;
        if (this.activeEditor != null) {
            if (this.activeEditor.deactivate()) {
                result = true;
                this.toolBarMgr.removeAll();
                if (closePanel) {
                    this.setVisible(false);
                }
                if (this.activeEditor != null) {
                    this.activeEditor.removePropertyListener(this);
                }
                this.activeEditor = null;
            }
        } else {
            result = true;
            if (closePanel) {
                this.setVisible(false);
            }
        }
        return result;
    }

    protected void createTitleBar() {
        if (this.titleLabel != null) {
            return;
        }
        this.titleLabel = new CLabel((Composite)this.control, 32);
        this.titleLabel.setAlignment(16384);
        this.titleLabel.setBackground(null, null);
        this.titleLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    ModelObjectEditorPanel.this.showPaneMenu((Control)ModelObjectEditorPanel.this.titleLabel, new Point(e.x, e.y));
                } else if (e.button == 1 && ModelObjectEditorPanel.this.overImage(e.x)) {
                    ModelObjectEditorPanel.this.showPaneMenu();
                }
            }

            public void mouseDoubleClick(MouseEvent event) {
                ModelObjectEditorPanel.this.doZoom();
            }
        });
        this.updateTitles();
        this.control.setTopLeft((Control)this.titleLabel);
    }

    public void showPaneMenu() {
        Rectangle bounds = this.titleLabel.getBounds();
        this.showPaneMenu((Control)this.titleLabel, new Point(0, bounds.height));
    }

    protected void showPaneMenu(Control parent, Point point) {
        if (this.menuMgr == null) {
            this.menuMgr = new MenuManager();
            this.menuMgr.add((IContributionItem)new PaneContribution());
        }
        Menu aMenu = this.menuMgr.createContextMenu(parent);
        point = parent.toDisplay(point);
        aMenu.setLocation(point.x, point.y);
        aMenu.setVisible(true);
    }

    protected void createToolBar() {
        this.toolBar = new ToolBar((Composite)this.control, 0x800040);
        this.control.setTopRight((Control)this.toolBar);
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (ModelObjectEditorPanel.this.toolBar.getItem(new Point(event.x, event.y)) == null) {
                    ModelObjectEditorPanel.this.doZoom();
                }
            }
        });
        this.toolBarMgr = new PaneToolBarManager(this.toolBar);
        this.closeAction = new Action(){

            public void run() {
                ModelObjectEditorPanel.this.deactivate(true);
            }
        };
        this.closeAction.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/close_view.gif"));
        this.closeAction.setToolTipText(CLOSE);
    }

    public void dispose() {
        this.deactivate(true);
        if (this.toolBarMgr != null) {
            this.toolBarMgr.dispose();
        }
        if (this.menuMgr != null) {
            this.menuMgr.dispose();
        }
    }

    public void doZoom() {
        this.isZoomed = !this.isZoomed;
        this.modelEditor.zoomObjectEditor(this.isZoomed);
    }

    private void setVisible(boolean makeVisible) {
        if (this.control != null && !this.control.isDisposed()) {
            if (makeVisible) {
                this.isZoomed = false;
                this.control.setVisible(true);
            } else {
                this.modelEditor.zoomObjectEditor(false);
                this.isZoomed = false;
                this.control.setVisible(false);
            }
            this.control.getParent().layout();
        }
    }

    public void updateTitles() {
        String text = null;
        if (this.activeEditor != null) {
            text = this.activeEditor.getTitle();
            Image image = this.activeEditor.getTitleImage();
            if (!text.equals(this.titleLabel.getText()) || image != this.titleLabel.getImage()) {
                this.titleLabel.setText(text);
                this.titleLabel.setImage(image);
                this.control.layout();
            }
            this.titleLabel.setToolTipText(this.activeEditor.getTitleToolTip());
        }
        this.titleLabel.setText(text);
        this.titleLabel.update();
    }

    boolean overImage(int x) {
        if (this.titleLabel.getImage() == null) {
            return false;
        }
        return x < this.titleLabel.getImage().getBounds().width;
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257) {
            this.markDirty();
        } else if (propId == 1) {
            this.markDirty();
        }
    }

    private void markDirty() {
        if (this.titleLabel != null && !this.titleLabel.isDisposed()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (ModelObjectEditorPanel.this.titleLabel != null && !ModelObjectEditorPanel.this.titleLabel.isDisposed()) {
                        String title = "";
                        if (ModelObjectEditorPanel.this.activeEditor != null) {
                            title = ModelObjectEditorPanel.this.activeEditor.getTitle();
                            if (ModelObjectEditorPanel.this.activeEditor.isDirty()) {
                                title = String.valueOf('*') + title;
                            }
                        }
                        ModelObjectEditorPanel.this.titleLabel.setText(title);
                    }
                }
            };
            if (Display.getDefault().getThread() == Thread.currentThread()) {
                Display.getCurrent().syncExec(runnable);
            } else {
                Display.getDefault().asyncExec(runnable);
            }
        }
    }

    public ModelObjectEditorPage getActiveEditor() {
        return this.activeEditor;
    }

    public MultiPageModelEditor getModelEditor() {
        return this.modelEditor;
    }

    public void setActiveEditor(ModelObjectEditorPage page) {
        this.activeEditor = page;
    }

    class PaneContribution
    extends ContributionItem {
        PaneContribution() {
        }

        public boolean isDynamic() {
            return true;
        }

        public void fill(Menu menu, int index) {
            MenuItem item = new MenuItem(menu, 0);
            item.setText(RESTORE);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((PaneContribution)PaneContribution.this).ModelObjectEditorPanel.this.isZoomed) {
                        ModelObjectEditorPanel.this.doZoom();
                    }
                }
            });
            item.setEnabled(ModelObjectEditorPanel.this.isZoomed);
            item = new MenuItem(menu, 0);
            item.setText(MAXIMIZE);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModelObjectEditorPanel.this.doZoom();
                }
            });
            item.setEnabled(!ModelObjectEditorPanel.this.isZoomed);
            new MenuItem(menu, 2);
            item = new MenuItem(menu, 0);
            item.setText(CLOSE);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModelObjectEditorPanel.this.close();
                }
            });
        }
    }

    class PaneToolBarManager
    extends ToolBarManager {
        public PaneToolBarManager(ToolBar paneToolBar) {
            super(paneToolBar);
        }

        protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
            toolBar.layout();
            Composite parent = toolBar.getParent();
            parent.layout();
            if (parent.getParent() != null) {
                parent.getParent().layout();
            }
        }
    }
}

