/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.CloseEditorRunnable;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.OpenModelEditorJob;
import org.teiid.designer.ui.undo.ModelerUndoManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public abstract class ModelEditorManager {
    public static final String OPEN_EDITOR_TITLE = UiConstants.Util.getString("ModelEditorManager.openModelEditorTitle", new Object[0]);
    public static final String OPEN_EDITOR_MESSAGE = UiConstants.Util.getString("ModelEditorManager.openModelEditorMessage", new Object[0]);
    private static final String ALWAY_FORCE_OPEN_MESSAGE = UiConstants.Util.getString("ModelEditorManager.alwaysForceOpenMessage", new Object[0]);
    private static final String READ_ONLY_TITLE = UiConstants.Util.getString("ModelEditorManager.alwaysForceOpenMessage", new Object[0]);
    private static final String READ_ONLY_MESSAGE = UiConstants.Util.getString("ModelEditorManager.alwaysForceOpenMessage", new Object[0]);
    static final String VR_MSG = UiConstants.Util.getString("ModelEditor.virtualRelationalNotLicensedMessage", new Object[0]);
    static final String XML_MSG = UiConstants.Util.getString("ModelEditor.xmlNotLicensedMessage", new Object[0]);
    private static final ModelerUndoManager undoManager = ModelerUndoManager.getInstance();
    static IEditorPart staticEditor;

    public static void activate(IFile modelFile, boolean forceOpen) {
        ModelEditorManager.activate(modelFile, forceOpen, true);
    }

    public static void activate(final IFile modelFile, final boolean forceOpen, boolean async) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ModelEditor modelEditor = ModelEditorManager.getModelEditorForFile(modelFile, forceOpen);
                if (modelEditor != null) {
                    modelEditor.setFocus();
                }
            }
        };
        if (async) {
            Display.getDefault().asyncExec(r);
        } else {
            Display.getDefault().syncExec(r);
        }
    }

    public static void activate(ModelResource modelResource, boolean forceOpen) {
        ModelEditorManager.activate(modelResource, forceOpen, false);
    }

    public static void activate(final ModelResource modelResource, final boolean forceOpen, final boolean maintainActivePart) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IFile file;
                ModelEditor modelEditor;
                IWorkbenchPart activePart = null;
                IWorkbenchPage activePage = null;
                if (maintainActivePart && (activePage = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                    activePart = activePage.getActivePart();
                }
                if ((modelEditor = ModelEditorManager.getModelEditorForFile(file = (IFile)modelResource.getResource(), forceOpen)) != null) {
                    ModelEditorManager.activate(modelEditor);
                }
                if (activePart != null) {
                    activePage.activate(activePart);
                }
            }
        });
    }

    public static void activate(ModelEditor editor) {
        IWorkbenchPage page = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.bringToTop((IWorkbenchPart)editor);
    }

    public static void autoSelectEditor(final ModelEditor editor, final ModelEditorPage thePage) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArrayList copyOfAllEditors = new ArrayList(editor.getAllEditors());
                for (Object nextPage : copyOfAllEditors) {
                    if (!(nextPage instanceof ModelEditorPage) || nextPage != thePage || ((ModelEditorPage)nextPage).getControl().isDisposed()) continue;
                    editor.selectPage(thePage);
                }
            }
        });
    }

    public static boolean autoOpen(Shell shell, EObject eObject, boolean showReadOnlyDialog) {
        CoreArgCheck.isNotNull((Object)eObject, (String)"eObject is null");
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject(eObject);
        if (modelResource == null) {
            return false;
        }
        if (!ModelEditorManager.isOpen(eObject)) {
            if (ModelUtil.isIResourceReadOnly((IResource)modelResource.getResource())) {
                if (showReadOnlyDialog) {
                    MessageDialog.openError((Shell)shell, (String)READ_ONLY_TITLE, (String)READ_ONLY_MESSAGE);
                }
                return false;
            }
            String autoOpen = UiPlugin.getDefault().getPreferenceStore().getString("autoOpenEditorIfNeeded");
            boolean forceOpen = "always".equals(autoOpen);
            if (!forceOpen) {
                forceOpen = ModelEditorManager.showDialogShouldOpenEditor(shell);
            }
            if (forceOpen) {
                ModelEditorManager.open(eObject, true);
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean showDialogShouldOpenEditor(Shell shell) {
        boolean shouldOpen = false;
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)shell, (String)OPEN_EDITOR_TITLE, (String)OPEN_EDITOR_MESSAGE, (String)ALWAY_FORCE_OPEN_MESSAGE, (boolean)false, (IPreferenceStore)UiPlugin.getDefault().getPreferenceStore(), (String)"autoOpenEditorIfNeeded");
        int result = dialog.getReturnCode();
        switch (result) {
            case 0: 
            case 2: {
                shouldOpen = true;
                break;
            }
            case 3: {
                shouldOpen = false;
            }
        }
        return shouldOpen;
    }

    public static void open(final EObject object, final boolean forceOpen) {
        UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                boolean forceRefresh;
                ModelEditor modelEditor;
                if (object != null && (modelEditor = ModelEditorManager.getModelEditorForObject(object, forceOpen)) != null && modelEditor.openModelObject(object, forceRefresh = forceOpen)) {
                    ModelEditorManager.activate(modelEditor);
                }
            }
        });
    }

    public static void openInEditMode(Object input, boolean forceOpen, int objectEditorValue) {
        EObject theEObject = null;
        if (input instanceof EObject) {
            theEObject = (EObject)input;
        } else if (input instanceof IFile) {
            try {
                theEObject = ModelUtilities.getModelResourceForIFile((IFile)input, true).getModelAnnotation();
            }
            catch (ModelWorkspaceException err) {
                WidgetUtil.showError((Throwable)err);
                UiConstants.Util.log((Throwable)err);
            }
        } else if (input instanceof ModelResource) {
            try {
                theEObject = ((ModelResource)input).getModelAnnotation();
            }
            catch (ModelWorkspaceException err) {
                WidgetUtil.showError((Throwable)err);
                UiConstants.Util.log((Throwable)err);
            }
        }
        if (theEObject != null) {
            ModelEditorManager.open(theEObject, true, objectEditorValue);
        }
    }

    public static void open(final EObject object, final boolean forceOpen, final int objectEditorValue) {
        UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ModelEditor modelEditor;
                if (object != null && (modelEditor = ModelEditorManager.getModelEditorForObject(object, forceOpen)) != null && modelEditor.openModelObject(object)) {
                    ModelEditorManager.activate(modelEditor);
                    ModelEditorManager.updateObjectEditor(modelEditor, object, objectEditorValue);
                    modelEditor.openComplete();
                }
            }
        });
    }

    public static void openWithJob(Object object) {
        if (object != null) {
            ModelEditorManager.openAndEditWithJob(object, null);
        }
    }

    public static void openAndEditWithJob(Object object, EObject editableObject) {
        ModelResource mr;
        if (object != null && (mr = ModelUtilities.getModelResource(object)) != null) {
            try {
                final OpenModelEditorJob openJob = new OpenModelEditorJob((IFile)mr.getCorrespondingResource(), editableObject);
                UiUtil.runInSwtThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        openJob.schedule();
                    }
                }, (boolean)true);
            }
            catch (ModelWorkspaceException theException) {
                UiConstants.Util.log((Throwable)theException);
            }
        }
    }

    public static boolean isOpen(IFile modelFile) {
        return ModelEditorManager.getModelEditorForFile(modelFile, false) != null;
    }

    public static boolean isOpen(EObject modelObject) {
        return ModelEditorManager.getModelEditorForObject(modelObject, false) != null;
    }

    public static boolean isOpenAndInitialized(IFile modelFile) {
        boolean result = false;
        ModelEditor editor = ModelEditorManager.getModelEditorForFile(modelFile, false);
        if (editor != null && editor.hasInitialized()) {
            result = true;
        }
        return result;
    }

    public static boolean close(IFile modelFile, boolean save) {
        CloseEditorRunnable runnable = new CloseEditorRunnable(modelFile, save);
        Display.getDefault().syncExec((Runnable)runnable);
        return runnable.didClose;
    }

    public static boolean save(IFile modelFile) {
        boolean bSaveDone = false;
        ModelEditor me = ModelEditorManager.getModelEditorForFile(modelFile, false);
        if (me != null) {
            bSaveDone = true;
            me.doSave((IProgressMonitor)new NullProgressMonitor());
        } else {
            bSaveDone = false;
        }
        return bSaveDone;
    }

    public static boolean canEdit(EObject object) {
        ModelEditor modelEditor;
        if (object != null && (modelEditor = ModelEditorManager.getModelEditorForObject(object, false)) != null) {
            return modelEditor.canEditModelObject(object);
        }
        return false;
    }

    public static void edit(EObject object) {
        ModelEditorManager.edit(object, null);
    }

    public static void edit(final EObject object, final String editorId) {
        UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ModelEditor modelEditor;
                if (object != null && (modelEditor = ModelEditorManager.getModelEditorForObject(object, true)) != null) {
                    Object editableObject = modelEditor.getEditableObject(object);
                    if (editorId == null) {
                        if (editableObject != null && editableObject instanceof EObject) {
                            ModelEditorManager.open((EObject)editableObject, false, 2);
                        } else {
                            ModelEditorManager.open(object, false, 2);
                        }
                    } else {
                        if (modelEditor.openModelObject(object)) {
                            ModelEditorManager.activate(modelEditor);
                        }
                        modelEditor.editModelObject(object, editorId);
                    }
                }
            }
        });
    }

    public static Collection getDirtyResources() {
        IEditorPart[] editors;
        ArrayList<IFile> result = Collections.EMPTY_LIST;
        IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
        if (page != null && (editors = page.getDirtyEditors()) != null && editors.length > 0) {
            result = new ArrayList<IFile>(editors.length);
            int i = 0;
            while (i < editors.length) {
                IEditorInput input = editors[i].getEditorInput();
                if (input instanceof IFileEditorInput) {
                    result.add(((IFileEditorInput)input).getFile());
                }
                ++i;
            }
        }
        return result;
    }

    public static Collection getOpenResources() {
        IEditorReference[] editorRefs;
        ArrayList<Object> result = Collections.EMPTY_LIST;
        IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
        if (page != null && (editorRefs = page.getEditorReferences()) != null && editorRefs.length > 0) {
            result = new ArrayList<Object>(editorRefs.length);
            int i = 0;
            while (i < editorRefs.length) {
                IEditorPart editor = editorRefs[i].getEditor(false);
                if (editor != null) {
                    IEditorInput input = editor.getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        result.add(((IFileEditorInput)input).getFile());
                    }
                } else {
                    String pathString = editorRefs[i].getTitleToolTip();
                    Path path = new Path(pathString);
                    IResource resource = ModelerCore.getWorkspace().getRoot().findMember((IPath)path);
                    if (resource instanceof IFile) {
                        result.add(resource);
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public static ModelEditor getModelEditorForFile(final IFile file, boolean forceOpen) {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        ModelEditor result = null;
        staticEditor = null;
        if (file != null && (window = UiPlugin.getDefault().getCurrentWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            IEditorReference[] editors = page.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                IEditorInput input;
                IEditorPart editor = editors[i].getEditor(false);
                if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && file.equals((Object)((IFileEditorInput)input).getFile())) {
                    if (!(editor instanceof ModelEditor)) break;
                    result = (ModelEditor)editor;
                    break;
                }
                ++i;
            }
            if (result == null && forceOpen) {
                UiUtil.runInSwtThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"modelEditor");
                            if (editor instanceof ModelEditor) {
                                staticEditor = editor;
                            }
                        }
                        catch (PartInitException e) {
                            String message = e.getStatus().getMessage();
                            if (message != null) {
                                String targetVrMsg = VR_MSG;
                                String targetXmlMsg = XML_MSG;
                                if (message.equals(targetVrMsg)) {
                                    UiConstants.Util.log(2, targetVrMsg);
                                } else if (message.equals(targetXmlMsg)) {
                                    UiConstants.Util.log(2, targetXmlMsg);
                                } else {
                                    UiConstants.Util.log(4, (Throwable)e, UiConstants.Util.getString("ModelEditorManager.getModelEditorForFile", (Object)file.toString()));
                                }
                            }
                            staticEditor = null;
                        }
                    }
                }, (boolean)true);
                result = (ModelEditor)staticEditor;
            }
        }
        staticEditor = null;
        return result;
    }

    public static IEditorReference getEditorReferenceForFile(IFile file) {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IEditorReference result = null;
        if (file != null && (window = UiPlugin.getDefault().getCurrentWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            IEditorReference[] editors = page.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                String sEditorReferenceName = editors[i].getName();
                if (sEditorReferenceName != null && file.getName().equals(sEditorReferenceName)) {
                    result = editors[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static void removeEditorReference(IEditorReference editorRef) {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        if (editorRef != null && (window = UiPlugin.getDefault().getCurrentWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            IEditorReference[] editors = page.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                if (editorRef.equals(editors[i])) {
                    IEditorReference[] editorRefsToClose = new IEditorReference[]{editorRef};
                    page.closeEditors(editorRefsToClose, false);
                    break;
                }
                ++i;
            }
        }
    }

    static ModelEditor getModelEditorForObject(EObject object, boolean forceOpen) {
        ModelEditor result = null;
        IFile file = null;
        ModelResource mdlRsrc = ModelUtilities.getModelResourceForModelObject(object);
        if (mdlRsrc != null) {
            file = (IFile)mdlRsrc.getResource();
            result = ModelEditorManager.getModelEditorForFile(file, forceOpen);
        }
        return result;
    }

    public static boolean closeObjectEditor() {
        IEditorPart activeEditor;
        boolean hasActiveObjectEditor = false;
        IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
        if (page != null && (activeEditor = page.getActiveEditor()) instanceof ModelEditor) {
            hasActiveObjectEditor = ((ModelEditor)activeEditor).getActiveObjectEditor() != null;
            ((ModelEditor)activeEditor).closeObjectEditor();
        }
        return hasActiveObjectEditor;
    }

    static void updateObjectEditor(ModelEditor modelEditor, EObject object, int objectEditorValue) {
        switch (objectEditorValue) {
            case 1: {
                if (modelEditor.getActiveObjectEditor() == null) break;
                modelEditor.closeObjectEditor();
                break;
            }
            case 2: {
                if (!modelEditor.canEditModelObject(object)) break;
                modelEditor.editModelObject(object, null);
                break;
            }
            case 3: {
                if (modelEditor.getActiveObjectEditor() == null) break;
                Object editableObject = modelEditor.getEditableObject(object);
                if (editableObject != null) {
                    if (modelEditor.getActiveObjectEditor().isEditingObject(editableObject)) break;
                    modelEditor.editModelObject(editableObject, null);
                    break;
                }
                modelEditor.closeObjectEditor();
                break;
            }
        }
    }
}

