/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions.workers;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.workers.ModelObjectWorker;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.table.ModelTableEditor;
import org.teiid.designer.ui.viewsupport.DiagramHelperManager;
import org.teiid.designer.ui.viewsupport.ModelObjectEditHelperManager;

public class CopyWorker
extends ModelObjectWorker {
    private static final String PROBLEM = "CopyWorker.problem";

    public CopyWorker(boolean enableAfterExecute) {
        super(enableAfterExecute);
    }

    @Override
    public boolean setEnabledState() {
        boolean enable = false;
        Object selection = this.getSelection();
        if (selection instanceof ISelection && this.canLegallyEditResource()) {
            ISelection iSelection = (ISelection)selection;
            if (SelectionUtilities.isSingleSelection((ISelection)iSelection)) {
                EObject obj = SelectionUtilities.getSelectedEObject((ISelection)iSelection);
                enable = obj instanceof Diagram ? DiagramHelperManager.canCopy((Diagram)obj) : obj != null && ModelObjectEditHelperManager.canCopy(obj);
            } else if (SelectionUtilities.isMultiSelection((ISelection)iSelection)) {
                List eObjectList = SelectionUtilities.getSelectedEObjects((ISelection)iSelection);
                boolean bl = enable = eObjectList != null && !eObjectList.isEmpty();
                if (enable) {
                    EObject nextEObj2 = null;
                    for (EObject nextEObj2 : eObjectList) {
                        if (ModelObjectEditHelperManager.canCopy(nextEObj2)) continue;
                        enable = false;
                        break;
                    }
                }
            }
        }
        return enable;
    }

    @Override
    public boolean execute() {
        boolean successful = false;
        Object selection = this.getSelection();
        if (selection instanceof ISelection && this.canLegallyEditResource()) {
            ISelection iSelection = (ISelection)selection;
            if (SelectionUtilities.isSingleSelection((ISelection)iSelection)) {
                EObject obj = SelectionUtilities.getSelectedEObject((ISelection)iSelection);
                try {
                    ModelerCore.getModelEditor().copyToClipboard(obj);
                    successful = true;
                }
                catch (ModelerCoreException err) {
                    String msg = UiConstants.Util.getString(PROBLEM, new Object[]{obj});
                    UiConstants.Util.log(4, (Throwable)err, msg);
                }
            } else if (SelectionUtilities.isMultiSelection((ISelection)iSelection)) {
                List eObjectList = SelectionUtilities.getSelectedEObjects((ISelection)iSelection);
                try {
                    ModelerCore.getModelEditor().copyAllToClipboard((Collection)eObjectList);
                    successful = true;
                }
                catch (ModelerCoreException err) {
                    String msg = UiConstants.Util.getString(PROBLEM, new Object[]{eObjectList});
                    UiConstants.Util.log(4, (Throwable)err, msg);
                }
            }
            this.doTableCopy();
        }
        return successful;
    }

    protected void doTableCopy() {
        ModelTableEditor mte = this.getTableEditor();
        if (mte != null) {
            mte.copySelectedToSystemClipboard();
        }
    }

    private ModelTableEditor getTableEditor() {
        ModelEditor modelEditor;
        IEditorPart subEditor;
        ModelTableEditor result = null;
        ModelEditor editor = this.getActiveEditor();
        if (editor instanceof ModelEditor && (subEditor = (modelEditor = editor).getActiveEditor()) instanceof ModelTableEditor) {
            result = (ModelTableEditor)subEditor;
        }
        return result;
    }
}

