/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.DisabledCommand;
import org.teiid.designer.core.util.NewModelObjectHelperManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ModelObjectAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelObjectLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.wizards.NewModelObjectWizardManager;

public class NewSiblingAction
extends ModelObjectAction {
    private static final String PROBLEM = "NewSiblingAction.problem";
    private static final String NONE_ALLOWED = "NewSiblingAction.noneAllowed";
    private static final ModelExplorerLabelProvider diagramProvider = new ModelExplorerLabelProvider();
    private static final ModelObjectLabelProvider provider = (ModelObjectLabelProvider)ModelUtilities.getEMFLabelProvider();
    private Command descriptor;
    private EObject sibling;

    public NewSiblingAction() {
        super(UiPlugin.getDefault());
        this.configureNoneAllowedState();
    }

    public NewSiblingAction(EObject sibling, Command theDescriptor) {
        super(UiPlugin.getDefault());
        this.sibling = sibling;
        this.setCommand(theDescriptor);
    }

    private void configureAllowedState() {
        String label;
        Object result = this.descriptor.getResult().iterator().next();
        Command cmd = this.descriptor;
        if (this.descriptor instanceof DisabledCommand) {
            cmd = ((DisabledCommand)this.descriptor).getDisabledCommand();
        }
        if ((label = cmd.getLabel()) == null || label.length() == 0 || cmd instanceof AddCommand) {
            label = provider.getText(result);
        }
        if (label != null && label.startsWith("New ")) {
            label = label.substring(4);
        }
        this.setText(label);
        if (result instanceof Diagram) {
            this.setImage(diagramProvider.getImage(result));
        } else if (result instanceof EObject) {
            this.setImage(provider.getImage((EObject)result, ModelObjectUtilities.isVirtual(this.sibling)));
        } else {
            this.setImage(provider.getImage(result));
        }
        this.setToolTipText(cmd.getDescription());
        this.setEnabled(true);
    }

    private void configureNoneAllowedState() {
        this.setText(this.getPluginUtils().getString(NONE_ALLOWED, new Object[0]));
        this.setEnabled(false);
    }

    @Override
    protected void doRun() {
        block27: {
            if (this.descriptor != null) {
                Shell shell = super.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
                ModelResource modelResource = null;
                boolean continuing = true;
                try {
                    modelResource = ModelerCore.getModelEditor().findModelResource(this.sibling);
                }
                catch (Exception ex) {
                    String msg = this.getPluginUtils().getString(PROBLEM, new Object[]{this.descriptor});
                    this.getPluginUtils().log(4, (Throwable)ex, msg);
                    continuing = false;
                }
                StructuredSelection tempSelection = null;
                if (this.sibling.eContainer() != null) {
                    tempSelection = new StructuredSelection((Object)this.sibling.eContainer());
                } else {
                    ModelResource mr = ModelUtilities.getModelResourceForModelObject(this.sibling);
                    if (mr != null) {
                        tempSelection = new StructuredSelection((Object)mr);
                    }
                }
                if (continuing) {
                    ModelUtilities.initializeModelContainers(modelResource, "New Sibling Added", (Object)this);
                    if (NewModelObjectWizardManager.isObjectDescriptorValid(shell, this.descriptor, modelResource, (ISelection)tempSelection)) {
                        NewModelObjectWizardManager.processObjectDescriptor(shell, this.descriptor, modelResource, (ISelection)tempSelection);
                    } else {
                        boolean started = ModelerCore.startTxn((boolean)true, (String)UiConstants.Util.getString("NewSiblingAction.undoLabel", (Object)this.descriptor.getLabel()), (Object)((Object)this));
                        boolean succeeded = false;
                        EObject newObj = null;
                        try {
                            try {
                                boolean undoable = true;
                                newObj = ModelerCore.getModelEditor().createNewSiblingFromCommand(this.sibling, this.descriptor);
                                List potentialReferences = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
                                undoable = !potentialReferences.isEmpty() ? NewModelObjectHelperManager.helpCreate((Object)newObj, null, (List)potentialReferences) : NewModelObjectHelperManager.helpCreate((Object)newObj, null);
                                if (!undoable) {
                                    ModelerCore.getCurrentUoW().setUndoable(false);
                                }
                                succeeded = true;
                            }
                            catch (ModelerCoreException theException) {
                                String msg = this.getPluginUtils().getString(PROBLEM, new Object[]{this.descriptor});
                                this.getPluginUtils().log(4, (Throwable)theException, msg);
                                this.setEnabled(false);
                                if (started) {
                                    if (succeeded) {
                                        String newObjName = ModelerCore.getModelEditor().getName(newObj);
                                        if (newObjName != null) {
                                            ModelerCore.getCurrentUoW().setDescription(UiConstants.Util.getString("NewSiblingAction.undoLabel", (Object)newObjName));
                                        }
                                        ModelerCore.commitTxn();
                                    } else {
                                        ModelerCore.rollbackTxn();
                                    }
                                }
                                break block27;
                            }
                        }
                        catch (Throwable throwable) {
                            if (started) {
                                if (succeeded) {
                                    String newObjName = ModelerCore.getModelEditor().getName(newObj);
                                    if (newObjName != null) {
                                        ModelerCore.getCurrentUoW().setDescription(UiConstants.Util.getString("NewSiblingAction.undoLabel", (Object)newObjName));
                                    }
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            throw throwable;
                        }
                        if (started) {
                            if (succeeded) {
                                String newObjName = ModelerCore.getModelEditor().getName(newObj);
                                if (newObjName != null) {
                                    ModelerCore.getCurrentUoW().setDescription(UiConstants.Util.getString("NewSiblingAction.undoLabel", (Object)newObjName));
                                }
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    protected boolean preRun() {
        ModelResource mr;
        if (this.requiresEditorForRun() && this.sibling != null && (mr = ModelUtilities.getModelResourceForModelObject(this.sibling)) != null) {
            ModelEditorManager.activate(mr, true, true);
        }
        return true;
    }

    @Override
    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
    }

    public void setCommand(Command theDescriptor) {
        this.descriptor = theDescriptor;
        if (this.descriptor == null || this.descriptor.getResult().isEmpty()) {
            this.configureNoneAllowedState();
        } else {
            this.configureAllowedState();
            if (this.descriptor instanceof DisabledCommand) {
                super.setEnabled(false);
            }
        }
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }
}

