/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;
import org.teiid.designer.ui.wizards.GenerateXsdWizard;

public class GenerateXsdSchemaAction2
extends SortableSelectionAction {
    static final IStatus STATUS_OK = new StatusInfo("org.teiid.designer.ui");
    static final IStatus STATUS_ERROR = new StatusInfo("org.teiid.designer.ui", 4, "Invalid selection. Must be relational models and/or tables");
    private static final String SELECTION_DIALOG_TITLE = UiConstants.Util.getString("GenerateXsdSchemaAction.selectionDialog.title", new Object[0]);
    private static final String SELECTION_DIALOG_MESSAGE = UiConstants.Util.getString("GenerateXsdSchemaAction.selectionDialog.initialMessage", new Object[0]);
    private static final String KEY_NO_SEL_DLG_MSG = "GenerateXsdSchemaAction.noSelMsg";
    private static final String NO_SEL_DLG_TITLE = UiConstants.Util.getString("GenerateXsdSchemaAction.noSelTitle", new Object[0]);
    private static final String DEFAULT_EXPLORER_TITLE = UiConstants.Util.getString("GenerateXsdSchemaAction.defaultViewName", new Object[0]);
    private boolean canIgnoreSelection = false;

    public GenerateXsdSchemaAction2() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/create_web_service.png"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        IWorkbenchWindow iww = UiPlugin.getDefault().getCurrentWorkbenchWindow();
        if (!ProductCustomizerMgr.getInstance().getProductCharacteristics().preProcess((Object)this, iww.getShell())) {
            this.notifyResult(false);
            return;
        }
        ISelection selection = this.getSelection();
        IStructuredSelection thisSelection = null;
        if (this.isValidSelection(selection)) {
            thisSelection = (IStructuredSelection)selection;
            if (!this.checkDirtyRelationalModel((ISelection)thisSelection, iww.getShell())) {
                return;
            }
        } else if (this.canIgnoreSelection) {
            this.canIgnoreSelection = false;
            ModelExplorerLabelProvider labelProvider = new ModelExplorerLabelProvider();
            ModelExplorerContentProvider contentProvider = new ModelExplorerContentProvider();
            ModelWorkspaceDialog wsDialog = new ModelWorkspaceDialog(UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell(), null, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
            wsDialog.setValidator(new Validator());
            wsDialog.setTitle(SELECTION_DIALOG_TITLE);
            wsDialog.setMessage(SELECTION_DIALOG_MESSAGE);
            wsDialog.open();
            if (wsDialog.getReturnCode() != 0) return;
            Object[] oSelectedObjects = wsDialog.getResult();
            if (oSelectedObjects.length <= 0) {
                String title = UiConstants.Util.getString("GenerateWebServiceModelAction.selectionError.title", new Object[0]);
                String dlgMsg = UiConstants.Util.getString("GenerateWebServiceModelAction.selectionError.emptySelection", new Object[0]);
                MessageDialog.openError((Shell)iww.getShell(), (String)title, (String)dlgMsg);
                this.notifyResult(false);
                return;
            }
            thisSelection = new StructuredSelection(oSelectedObjects);
            if (!this.isValidSelection((ISelection)thisSelection)) {
                String title = UiConstants.Util.getString("GenerateWebServiceModelAction.selectionError.title", new Object[0]);
                String dlgMsg = UiConstants.Util.getString("GenerateWebServiceModelAction.selectionError.wrongType", new Object[0]);
                MessageDialog.openError((Shell)iww.getShell(), (String)title, (String)dlgMsg);
                this.notifyResult(false);
            }
        } else {
            IViewReference ivr = iww.getActivePage().findViewReference(ProductCustomizerMgr.getInstance().getProductCharacteristics().getPrimaryNavigationViewId());
            String viewTitle = ivr != null ? ivr.getTitle() : DEFAULT_EXPLORER_TITLE;
            String dlgMsg = UiConstants.Util.getString(KEY_NO_SEL_DLG_MSG, (Object)viewTitle);
            MessageDialog.openError((Shell)iww.getShell(), (String)NO_SEL_DLG_TITLE, (String)dlgMsg);
            return;
        }
        final GenerateXsdWizard wizard = new GenerateXsdWizard();
        wizard.init(iww.getWorkbench(), thisSelection);
        WizardDialog dialog = new WizardDialog(wizard.getShell(), (IWizard)wizard);
        int rc = dialog.open();
        if (rc == 1) return;
        MultiStatus result = wizard.getResult();
        int severity = result.getSeverity();
        if (severity == 4) {
            String errTitle = UiConstants.Util.getString("GenerateXsdSchemaAction.errTitle", new Object[0]);
            String err = UiConstants.Util.getString("GenerateXsdSchemaAction.errFinish", new Object[0]);
            ErrorDialog.openError((Shell)wizard.getShell(), (String)errTitle, (String)err, (IStatus)result);
        } else if (severity == 2) {
            String warnTitle = UiConstants.Util.getString("GenerateXsdSchemaAction.warnTitle", new Object[0]);
            String warn = UiConstants.Util.getString("GenerateXsdSchemaAction.warnFinish", new Object[0]);
            ErrorDialog.openError((Shell)wizard.getShell(), (String)warnTitle, (String)warn, (IStatus)result);
        } else {
            final String okTitle = UiConstants.Util.getString("GenerateXsdSchemaAction.successTitle", new Object[0]);
            final String ok = UiConstants.Util.getString("GenerateXsdSchemaAction.successFinish", new Object[0]);
            ArrayList<String> msgs = new ArrayList<String>(result.getChildren().length);
            int i = 0;
            while (i < result.getChildren().length) {
                msgs.add(result.getChildren()[i].getMessage());
                ++i;
            }
            final ArrayList<String> messgs = msgs;
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ListMessageDialog.openInformation((Shell)wizard.getShell(), (String)okTitle, null, (String)ok, (List)messgs, null);
                    if (wizard.getWebServiceModel() != null) {
                        ModelEditorManager.openInEditMode(wizard.getWebServiceModel(), true, 0);
                    }
                }
            });
        }
        this.notifyResult(severity < 4);
    }

    @Override
    protected boolean isValidSelection(ISelection selection) {
        boolean isValid = true;
        if (SelectionUtilities.isEmptySelection((ISelection)selection)) {
            isValid = false;
        }
        if (!SelectionUtilities.isAllEObjects((ISelection)selection) && !SelectionUtilities.isAllIResourceObjects((ISelection)selection)) {
            isValid = false;
        }
        if (SelectionUtilities.isAllIResourceObjects((ISelection)selection) && !SelectionUtilities.isSingleSelection((ISelection)selection)) {
            isValid = false;
        }
        if (isValid) {
            List objs = SelectionUtilities.getSelectedObjects((ISelection)selection);
            Iterator selections = objs.iterator();
            while (selections.hasNext() && isValid) {
                Object next = selections.next();
                if (next instanceof Table) {
                    isValid = true;
                } else if (next instanceof Procedure) {
                    isValid = true;
                } else if (next instanceof IFile) {
                    ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)next));
                    if (modelResource != null) {
                        try {
                            isValid = ModelUtilities.isRelationalModel(modelResource) && this.hasTableOrProcedure(modelResource);
                        }
                        catch (ModelWorkspaceException err) {
                            UiConstants.Util.log((Throwable)err);
                            isValid = false;
                        }
                        catch (ModelerCoreException err) {
                            UiConstants.Util.log((Throwable)err);
                            isValid = false;
                        }
                    } else {
                        isValid = false;
                    }
                } else {
                    isValid = false;
                }
                if (!isValid) break;
            }
        }
        return isValid;
    }

    @Override
    public boolean isApplicable(ISelection selection) {
        return this.isValidSelection(selection);
    }

    private boolean checkDirtyRelationalModel(ISelection selection, Shell shell) {
        ModelEditor openEditor;
        ModelResource modelResource;
        Object obj;
        if (SelectionUtilities.isSingleSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IFile && (modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)obj))) != null && (ModelIdentifier.isRelationalSourceModel(modelResource) || ModelIdentifier.isRelationalViewModel(modelResource)) && (openEditor = ModelEditorManager.getModelEditorForFile((IFile)obj, false)) != null && openEditor.isDirty()) {
            MessageDialog.openWarning((Shell)shell, (String)UiConstants.Util.getString("GenerateXsdSchemaAction.unsavedChangesTitle", new Object[0]), (String)UiConstants.Util.getString("GenerateXsdSchemaAction.unsavedChangesMessage", (Object)modelResource.getItemName()));
            return false;
        }
        return true;
    }

    private boolean hasTableOrProcedure(ModelResource mr) throws ModelWorkspaceException, ModelerCoreException {
        TableOrProcedureFinder visitor = new TableOrProcedureFinder();
        ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor, 1);
        processor.walk(mr, 2);
        return visitor.hasTableOrProcedure();
    }

    public void setCanIgnoreSelection(boolean theCanIgnoreSelection) {
        this.canIgnoreSelection = theCanIgnoreSelection;
    }

    class TableOrProcedureFinder
    implements ModelVisitor {
        boolean hasTableOrProcedure = false;

        TableOrProcedureFinder() {
        }

        public boolean visit(EObject object) throws ModelerCoreException {
            if (object instanceof Table) {
                this.hasTableOrProcedure = true;
                return false;
            }
            if (object instanceof Procedure) {
                this.hasTableOrProcedure = true;
                return true;
            }
            if (object instanceof Catalog) {
                return true;
            }
            return object instanceof Schema;
        }

        public boolean visit(Resource resource) throws ModelerCoreException {
            return true;
        }

        public boolean hasTableOrProcedure() {
            return this.hasTableOrProcedure;
        }
    }

    class Validator
    implements ISelectionStatusValidator {
        Validator() {
        }

        public IStatus validate(Object[] theSelection) {
            StructuredSelection selection = new StructuredSelection(theSelection);
            IStatus result = STATUS_OK;
            if (!GenerateXsdSchemaAction2.this.isValidSelection((ISelection)selection)) {
                result = STATUS_ERROR;
            }
            return result;
        }
    }
}

