/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CloseModelAction
extends ActionDelegate
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private Collection selectedModelResources;

    public void run(IAction action) {
        if (this.selectedModelResources != null) {
            try {
                for (ModelResource modelResource : this.selectedModelResources) {
                    IFile modelFile = (IFile)modelResource.getResource();
                    boolean doClose = true;
                    if (ModelEditorManager.isOpen(modelFile)) {
                        doClose = ModelEditorManager.close(modelFile, true);
                    }
                    if (!doClose) continue;
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 2, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                    modelResource.close();
                    event = new ModelResourceEvent(modelResource, 3, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        List selectedObjects;
        this.selectedModelResources = Collections.EMPTY_LIST;
        boolean enable = SelectionUtilities.isAllIResourceObjects((ISelection)selection);
        if (enable && (selectedObjects = SelectionUtilities.getSelectedObjects((ISelection)selection)) != null && !selectedObjects.isEmpty()) {
            this.selectedModelResources = new ArrayList(selectedObjects.size());
            Iterator iter = selectedObjects.iterator();
            while (iter.hasNext() && enable) {
                Object obj = iter.next();
                if (obj instanceof IResource && ModelUtilities.isModelFile((IResource)obj)) {
                    try {
                        ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)obj), (boolean)false);
                        if (modelResource != null) {
                            this.selectedModelResources.add(modelResource);
                            continue;
                        }
                        enable = false;
                    }
                    catch (Exception e) {
                        UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                        enable = false;
                    }
                    continue;
                }
                enable = false;
            }
        }
        action.setEnabled(enable);
    }

    public void init(IWorkbenchWindow window) {
    }

    public void init(IViewPart view) {
    }
}

