/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.util;

public class Strings {
    public static String getOrElse(Object text) {
        return Strings.getOrElse(text, "");
    }

    public static String getOrElse(Object text, String defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        return text.toString();
    }

    public static String capitalize(String name) {
        if (name.length() > 0) {
            return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        }
        return name;
    }

    public static boolean isBlank(String text) {
        return text == null || text.trim().length() == 0;
    }

    public static String join(String[] names, String separator) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            buffer.append(name);
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            ++n2;
        }
        return buffer.toString();
    }

    public static String join(String separator, Object ... values) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            String text = Strings.getOrElse(value);
            if (!Strings.isBlank(text)) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(separator);
                }
                buffer.append(text);
            }
            ++n2;
        }
        return buffer.toString();
    }

    public static boolean contains(String filter, String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value.contains(filter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String humanize(String value) {
        String result = "";
        String cleanValue = value.trim();
        boolean lastCharUpperCase = false;
        int i = 0;
        while (i < cleanValue.length()) {
            char c = cleanValue.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!lastCharUpperCase || result.endsWith(" ID")) {
                    result = String.valueOf(result) + " ";
                }
                result = String.valueOf(result) + c;
                lastCharUpperCase = true;
            } else {
                result = i == 0 ? String.valueOf(result) + Character.toUpperCase(c) : String.valueOf(result) + cleanValue.charAt(i);
                lastCharUpperCase = false;
            }
            ++i;
        }
        return result;
    }
}

