/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.ui.views;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabSelectionListener;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.PreferencesHelper;
import org.fusesource.ide.commons.ui.views.ColumnViewSupport;
import org.fusesource.ide.commons.util.Objects;
import org.osgi.service.prefs.Preferences;

public abstract class TabFolderSupport2
extends TabbedPropertySheetPage {
    private static final String TAB_SELECTION_LABEL = "tabSelectionLabel";
    private final String contributorId;
    private List selectionQueue;
    private IViewSite viewSite;
    private PropertySheet propertySheet;

    public TabFolderSupport2(String contributorId, boolean showTitle) {
        super(new ITabbedPropertySheetPageContributor(){

            public String getContributorId() {
                return "org.fusesource.ide.commons.propertyContributor";
            }
        }, showTitle);
        this.contributorId = contributorId;
        TabbedPropertyRegistry registry = new TabbedPropertyRegistry(contributorId){

            protected ITabDescriptor[] getAllTabDescriptors() {
                return TabFolderSupport2.this.getTabDescriptors();
            }

            protected IConfigurationElement[] getConfigurationElements(String extensionPointId) {
                IConfigurationElement[] configurationElements = super.getConfigurationElements(extensionPointId);
                if (configurationElements == null || configurationElements.length == 0) {
                    configurationElements = new IConfigurationElement[]{new IConfigurationElement(){

                        public Object createExecutableExtension(String propertyName) throws CoreException {
                            return null;
                        }

                        public String getAttribute(String name) throws InvalidRegistryObjectException {
                            if (name.equals("contributorId")) {
                                return contributorId;
                            }
                            return null;
                        }

                        public String getAttribute(String attrName, String locale) throws InvalidRegistryObjectException {
                            return null;
                        }

                        public String getAttributeAsIs(String name) throws InvalidRegistryObjectException {
                            return null;
                        }

                        public String[] getAttributeNames() throws InvalidRegistryObjectException {
                            return new String[]{"contributorId"};
                        }

                        public IConfigurationElement[] getChildren() throws InvalidRegistryObjectException {
                            return new IConfigurationElement[0];
                        }

                        public IConfigurationElement[] getChildren(String name) throws InvalidRegistryObjectException {
                            return new IConfigurationElement[0];
                        }

                        public IExtension getDeclaringExtension() throws InvalidRegistryObjectException {
                            return null;
                        }

                        public String getName() throws InvalidRegistryObjectException {
                            return null;
                        }

                        public Object getParent() throws InvalidRegistryObjectException {
                            return null;
                        }

                        public String getValue() throws InvalidRegistryObjectException {
                            return null;
                        }

                        public String getValue(String locale) throws InvalidRegistryObjectException {
                            return null;
                        }

                        public String getValueAsIs() throws InvalidRegistryObjectException {
                            return null;
                        }

                        public String getNamespace() throws InvalidRegistryObjectException {
                            return null;
                        }

                        public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
                            return null;
                        }

                        public IContributor getContributor() throws InvalidRegistryObjectException {
                            return null;
                        }

                        public boolean isValid() {
                            return true;
                        }
                    }};
                }
                return configurationElements;
            }
        };
        try {
            Objects.setField((Object)this, "registry", registry, TabbedPropertySheetPage.class);
        }
        catch (Exception e) {
            Activator.getLogger().error("Failed to change the 'registry' field on " + (Object)((Object)this) + ". " + e, e);
        }
        try {
            this.selectionQueue = (List)Objects.getField((Object)this, "selectionQueue", TabbedPropertySheetPage.class);
        }
        catch (Exception e) {
            Activator.getLogger().error("Failed to get the 'selectionQueue' field on " + (Object)((Object)this) + ". " + e, e);
        }
    }

    protected abstract ITabDescriptor[] getTabDescriptors();

    protected IStructuredContentProvider getTabListContentProvider() {
        return new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return TabFolderSupport2.this.getTabDescriptors();
            }
        };
    }

    protected String getId() {
        return this.contributorId;
    }

    public IViewSite getViewSite() {
        return this.viewSite;
    }

    public PropertySheet getPropertySheet() {
        return this.propertySheet;
    }

    public void init(PropertySheet propertySheet) {
        this.propertySheet = propertySheet;
        this.viewSite = propertySheet.getViewSite();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.gotoPreviousSelectedTab();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ISection section;
        ISection[] sections;
        try {
            super.selectionChanged(part, selection);
        }
        catch (Throwable e) {
            Activator.getLogger().warning("Caught: " + e, e);
        }
        TabContents currentTab = this.getCurrentTab();
        if (currentTab != null && (sections = currentTab.getSections()) != null && sections.length > 0 && (section = sections[0]) instanceof ColumnViewSupport) {
            ColumnViewSupport cvs = (ColumnViewSupport)section;
            cvs.setSelectionProvider();
        }
    }

    protected void gotoPreviousSelectedTab() {
        String id = this.getSelectedTabLabel();
        if (id != null) {
            this.selectionQueue.remove(id);
            this.selectionQueue.add(0, id);
        }
        this.addTabSelectionListener(new ITabSelectionListener(){

            public void tabSelected(ITabDescriptor tabDescriptor) {
                if (tabDescriptor != null) {
                    TabFolderSupport2.this.setSelectedTabLabel(tabDescriptor.getLabel());
                }
            }
        });
    }

    protected String getSelectedTabLabel() {
        Preferences node = this.getConfigurationNode();
        return node.get(TAB_SELECTION_LABEL, null);
    }

    protected void setSelectedTabLabel(String label) {
        Preferences node;
        String oldValue;
        if (label != null && !Objects.equal(oldValue = (node = this.getConfigurationNode()).get(TAB_SELECTION_LABEL, null), label)) {
            node.put(TAB_SELECTION_LABEL, label);
            PreferencesHelper.flush(node);
        }
    }

    protected Preferences getConfigurationNode() {
        return PreferencesHelper.configurationNode(this.getId(), "TabFolder");
    }
}

