/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.ui.label;

import java.util.StringTokenizer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.preferences.PreferenceManager;

public enum BarColour {
    Green(5),
    DarkGreen(6),
    Yellow(7),
    Red(3),
    Blue(9);

    private final int colourId;

    private BarColour(int colourId) {
        this.colourId = colourId;
    }

    public Color create(GC gc) {
        String key = "tableHealthChartColor" + this.toString();
        String colorString = PreferenceManager.getInstance().loadPreferenceAsString(key);
        if (Strings.isBlank(colorString)) {
            Display display = Shells.getDisplay();
            Color c = display.getSystemColor(this.colourId);
            return new Color(gc.getDevice(), c.getRGB());
        }
        int r = 0;
        int g = 0;
        int b = 0;
        StringTokenizer strTok = new StringTokenizer(colorString, ",");
        int i = 0;
        while (strTok.hasMoreTokens()) {
            String tok = strTok.nextToken();
            switch (i) {
                case 0: {
                    r = Integer.parseInt(tok);
                    break;
                }
                case 1: {
                    g = Integer.parseInt(tok);
                    break;
                }
                case 2: {
                    b = Integer.parseInt(tok);
                }
            }
            ++i;
        }
        return new Color(gc.getDevice(), r, g, b);
    }
}

