/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.ui;

import java.net.URL;
import java.util.Enumeration;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.logging.RiderLogFacade;
import org.fusesource.ide.commons.ui.Shells;

public abstract class ImagesActivatorSupport
extends AbstractUIPlugin {
    protected static void showUserError(String pluginId, RiderLogFacade logger, final String title, final String message, Exception e) {
        Throwable t = ImagesActivatorSupport.unwrapException(e);
        String text = t.getMessage();
        Status errorStatus = new Status(4, pluginId, 4, text, (Throwable)e);
        Display.getDefault().asyncExec(new Runnable((IStatus)errorStatus){
            private final /* synthetic */ IStatus val$errorStatus;
            {
                this.val$errorStatus = iStatus;
            }

            @Override
            public void run() {
                ErrorDialog.openError((Shell)Shells.getShell(), (String)title, (String)message, (IStatus)this.val$errorStatus);
            }
        });
        logger.error(String.valueOf(message) + ". Exception: " + text, e);
    }

    protected static Throwable unwrapException(Exception e) {
        if (e instanceof JAXBException) {
            JAXBException jaxbe = (JAXBException)e;
            return jaxbe.getLinkedException();
        }
        return e;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        String prefix = "/icons/";
        Enumeration enu = this.getBundle().findEntries(prefix, "*", true);
        while (enu.hasMoreElements()) {
            String file;
            URL u = (URL)enu.nextElement();
            String fileName = file = u.getFile();
            if (!file.startsWith(prefix)) {
                Activator.getLogger().warning("Warning: image: " + fileName + " does not start with prefix: " + prefix);
            }
            fileName = fileName.substring(prefix.length());
            this.registerImage(reg, fileName, fileName);
        }
    }

    private void registerImage(ImageRegistry reg, String key, String fileName) {
        reg.put(key, ImagesActivatorSupport.imageDescriptorFromPlugin((String)this.getBundle().getSymbolicName(), (String)String.format("icons/%s", fileName)));
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }
}

