/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.logging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class RiderLogFacade {
    private static Map<String, RiderLogFacade> openLogs = new ConcurrentHashMap<String, RiderLogFacade>();
    private ILog log;
    private boolean isDebugEnabled = Boolean.valueOf(System.getProperty("fusesource.debugEnabled"));

    private RiderLogFacade(ILog log) {
        this.log = log;
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public void setDebugEnabled(boolean isDebug) {
        this.isDebugEnabled = isDebug;
    }

    public static RiderLogFacade getLog(ILog pluginLogger) throws IllegalArgumentException {
        if (pluginLogger == null) {
            throw new IllegalArgumentException("Log parameter must not be null!");
        }
        if (openLogs == null || pluginLogger.getBundle() == null) {
            return new RiderLogFacade(pluginLogger);
        }
        if (!openLogs.containsKey(pluginLogger.getBundle().getSymbolicName())) {
            openLogs.put(pluginLogger.getBundle().getSymbolicName(), new RiderLogFacade(pluginLogger));
        }
        return openLogs.get(pluginLogger.getBundle().getSymbolicName());
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(Throwable ex) {
        this.info(null, ex);
    }

    public void info(String message, Throwable ex) {
        this.log(1, 1, message, ex);
    }

    public void warning(String message) {
        this.warning(message, null);
    }

    public void warning(Throwable ex) {
        this.warning(null, ex);
    }

    public void warning(String message, Throwable ex) {
        this.log(2, 2, message, ex);
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(Throwable ex) {
        this.error(null, ex);
    }

    public void error(String message, Throwable ex) {
        this.log(4, 4, message, ex);
    }

    public void log(int severity, int code, String message, Throwable ex) {
        this.log(this.createStatus(severity, code, message, ex));
    }

    public IStatus createStatus(int severity, int code, String message, Throwable ex) {
        Bundle bundle = this.log.getBundle();
        String symbolicName = bundle != null ? bundle.getSymbolicName() : "nonOSGi";
        return new Status(severity, symbolicName, code, message, ex);
    }

    public void log(IStatus status) {
        if (this.isDebugEnabled) {
            this.log.log(status);
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled) {
            this.log(this.createStatus(1, 0, message, null));
        }
    }

    public void debug(String message, Throwable e) {
        if (this.isDebugEnabled) {
            this.log(this.createStatus(4, 0, message, e));
        }
    }
}

