/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.webservice.Input;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.Message;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.webservice.Output;
import org.teiid.designer.metamodels.webservice.WebServiceComponent;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlValueHolder;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.proc.IAssignmentStatement;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.webservice.WebServicePlugin;
import org.teiid.designer.webservice.procedure.DocumentGenerator;
import org.teiid.designer.webservice.procedure.XsdInstanceNode;
import org.teiid.designer.webservice.util.InputVariable;

public class WebServiceUtil {
    private static final String DEFAULT_INPUT_NAME = "NEWINPUT";
    private static final String PLACEHOLDER = WebServicePlugin.Util.getString("WebServiceUtil.chooseElementOrAttribute", new Object[0]);
    public static final String INPUT_VARIABLE_UNQUALIFIED_PREFIX = "IN_";
    public static final String INPUT_VARIABLE_PREFIX = "VARIABLES.IN_";
    public static final String XPATHVALUE = "xpathvalue";

    public static String createXPath(XsdInstanceNode node) {
        StringBuffer xpath = new StringBuffer();
        XsdInstanceNode segNode = node;
        while (segNode != null) {
            XsdInstanceNode parent = segNode.getParent();
            XSDConcreteComponent comp = segNode.getResolvedXsdComponent();
            if (!(comp instanceof XSDModelGroup)) {
                StringBuffer seg = new StringBuffer("/");
                if (comp instanceof XSDAttributeDeclaration) {
                    seg.append('@');
                }
                String name = segNode.getName();
                boolean conflict = false;
                if (parent != null) {
                    XsdInstanceNode[] siblings = parent.getChildren();
                    int ndx = siblings.length;
                    while (--ndx >= 0) {
                        XsdInstanceNode sibling = siblings[ndx];
                        if (sibling == segNode || !sibling.getName().equals(name)) continue;
                        conflict = true;
                        break;
                    }
                }
                if (conflict) {
                    seg.append("*[local-name()=\"");
                    seg.append(name);
                    seg.append("\" and namespace-uri()=\"");
                    seg.append(segNode.getTargetNamespace());
                    seg.append("\"]");
                } else {
                    seg.append("*:");
                    seg.append(name);
                }
                xpath.insert(0, seg);
            }
            segNode = parent;
        }
        return xpath.toString();
    }

    public static String generateRequestDocument(Operation operation, List<String> paramValues) {
        XsdInstanceNode node = new XsdInstanceNode(operation.getInput().getContentElement());
        return DocumentGenerator.SHARED.generate(node, paramValues);
    }

    public static XSDTypeDefinition getContentElementTypeDefn(Message message) {
        XSDElementDeclaration elem;
        XSDTypeDefinition typeDefn = null;
        if (message != null && (elem = message.getContentElement()) != null) {
            typeDefn = elem.getTypeDefinition();
        }
        return typeDefn;
    }

    public static List<EObject> getInputElements(Operation operation, boolean includeFixedValueFeatures) {
        ArrayList<EObject> elemList = new ArrayList<EObject>();
        if (operation != null) {
            WebServiceUtil.addInputElements(operation.getInput(), elemList);
        }
        return elemList;
    }

    private static void addInputElements(Input input, List variables) {
        XSDElementDeclaration element;
        if (input != null && (element = input.getContentElement()) != null) {
            WebServiceUtil.addInputElements(new XsdInstanceNode(element), variables);
        }
    }

    private static void addInputElements(XsdInstanceNode node, List variables) {
        if (node.isSelectable()) {
            variables.add(node.getResolvedXsdComponent());
        }
        XsdInstanceNode[] children = node.getChildren();
        int ndx = 0;
        while (ndx < children.length) {
            WebServiceUtil.addInputElements(children[ndx], variables);
            ++ndx;
        }
    }

    public static String getSql(Operation operation, List<String> paramValues) {
        StringBuffer sql = new StringBuffer("EXEC ");
        String rawFullName = ModelerCore.getModelEditor().getModelRelativePathIncludingModel((EObject)operation).toString();
        rawFullName = rawFullName.replace('/', '.');
        StringBuffer sb = new StringBuffer(rawFullName.length());
        sb.append('\"');
        char[] cArray = rawFullName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char nextChar = cArray[n2];
            if (nextChar != '.') {
                sb.append(nextChar);
            } else {
                sb.append('\"').append('.').append('\"');
            }
            ++n2;
        }
        sb.append('\"');
        String dquotedName = sb.toString();
        sql.append(dquotedName);
        if (!paramValues.isEmpty()) {
            sql.append("('");
            sql.append(WebServiceUtil.generateRequestDocument(operation, paramValues));
            sql.append("\n')");
        } else {
            sql.append("()");
        }
        return sql.toString();
    }

    public static MetamodelDescriptor getWebServiceModelDescriptor() {
        return ModelerCore.getMetamodelRegistry().getMetamodelDescriptor("http://www.metamatrix.com/metamodels/WebService");
    }

    public static String getXpath(IAssignmentStatement statement) {
        IFunction function = WebServiceUtil.getXpathFunction(statement);
        if (function != null && function.getArgs().length > 1) {
            return (String)((IConstant)function.getArg(1)).getValue();
        }
        return "";
    }

    public static IFunction getXpathFunction(IAssignmentStatement statement) {
        IFunction function;
        IExpression expr;
        if (statement.getExpression() != null && (expr = statement.getExpression()) != null && expr instanceof IFunction && XPATHVALUE.equalsIgnoreCase((function = (IFunction)expr).getName())) {
            return function;
        }
        return null;
    }

    public static boolean isWebServiceComponent(Object object) {
        boolean result = false;
        if (object instanceof WebServiceComponent) {
            result = true;
        }
        return result;
    }

    public static boolean isWebServiceInterface(Object object) {
        boolean result = false;
        if (object instanceof Interface) {
            result = true;
        }
        return result;
    }

    public static boolean isWebServiceModelResource(ModelResource modelResource) {
        boolean result = false;
        if (modelResource != null) {
            MetamodelDescriptor descriptor = null;
            try {
                descriptor = modelResource.getPrimaryMetamodelDescriptor();
            }
            catch (ModelWorkspaceException e) {
                e.printStackTrace();
            }
            if (descriptor != null && descriptor.getNamespaceURI().equals("http://www.metamatrix.com/metamodels/WebService")) {
                result = true;
            }
        }
        return result;
    }

    public String generateTransformationSql(Output output, XmlDocument xmlDoc) {
        if (output == null || xmlDoc == null) {
            return null;
        }
        ArrayList variables = new ArrayList();
        Operation op = output.getOperation();
        String inputName = DEFAULT_INPUT_NAME;
        if (op != null) {
            Input input = op.getInput();
            this.addInputVariables(input, variables);
            if (input.getName() != null && input.getName().trim().length() != 0) {
                inputName = this.getFullName((EObject)input);
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE VIRTUAL PROCEDURE BEGIN ");
        Iterator iter = variables.iterator();
        ArrayList<String> criteriaStrings = new ArrayList<String>();
        while (iter.hasNext()) {
            InputVariable variable = (InputVariable)iter.next();
            String name = variable.getName();
            if (name == null || name.trim().length() == 0) {
                name = "VARIABLE";
                variable.setName(name);
            }
            sb.append("DECLARE string ");
            sb.append(INPUT_VARIABLE_PREFIX);
            sb.append(variable.getName());
            sb.append("; ");
            sb.append(INPUT_VARIABLE_PREFIX);
            sb.append(variable.getName());
            sb.append(" = xpathValue(");
            sb.append(inputName);
            sb.append(",'");
            sb.append(variable.getXpath());
            sb.append("'); ");
            List xmlValueHolders = variable.getXmlDocumentEntityForCriteria();
            if (!xmlValueHolders.isEmpty()) {
                for (XmlValueHolder valueHolder : xmlValueHolders) {
                    String valueHolderPath;
                    if (valueHolder == null || (valueHolderPath = this.getFullName((EObject)valueHolder)) == null || valueHolderPath.trim().length() == 0) continue;
                    StringBuffer criteria = new StringBuffer();
                    criteria.append(valueHolderPath);
                    criteria.append(" = ");
                    criteria.append(INPUT_VARIABLE_PREFIX);
                    criteria.append(variable.getName());
                    criteriaStrings.add(criteria.toString());
                }
                continue;
            }
            String valueHolderPath = this.getFullName((EObject)xmlDoc);
            StringBuffer criteria = new StringBuffer();
            criteria.append(valueHolderPath);
            criteria.append(PLACEHOLDER);
            criteria.append(" = ");
            criteria.append(INPUT_VARIABLE_PREFIX);
            criteria.append(variable.getName());
            criteriaStrings.add(criteria.toString());
        }
        String docPath = this.getFullName((EObject)xmlDoc);
        sb.append("SELECT * FROM ");
        sb.append(docPath);
        if (criteriaStrings.size() != 0) {
            sb.append(" WHERE ");
            Iterator criteriaIter = criteriaStrings.iterator();
            boolean moreThanOne = false;
            while (criteriaIter.hasNext()) {
                String criteriaString = (String)criteriaIter.next();
                if (moreThanOne) {
                    sb.append(" AND ");
                }
                sb.append(criteriaString);
                moreThanOne = true;
            }
            sb.append(" ");
        }
        sb.append("; END");
        return sb.toString();
    }

    public String getFullName(EObject object) {
        return TransformationHelper.getSqlEObjectFullName((EObject)object);
    }

    public void addInputVariables(Input input, List variables) {
        XSDElementDeclaration element;
        if (input != null && (element = input.getContentElement()) != null) {
            this.addInputVariables(new XsdInstanceNode(element), variables);
        }
    }

    public void addInputVariables(XsdInstanceNode node, List variables) {
        if (node.isSelectable()) {
            variables.add(new InputVariable((XSDNamedComponent)node.getResolvedXsdComponent(), node.getName(), WebServiceUtil.createXPath(node)));
        }
        XsdInstanceNode[] children = node.getChildren();
        int ndx = children.length;
        while (--ndx >= 0) {
            this.addInputVariables(children[ndx], variables);
        }
    }
}

