/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.wizards.vdbs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.Messages;
import org.teiid.designer.runtime.ui.wizards.vdbs.GenerateDynamicVdbManager;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.SingleProjectOrFolderFilter;
import org.teiid.designer.vdb.VdbPlugin;

public class GenerateDynamicVdbPageOne
extends AbstractWizardPage
implements DqpUiConstants,
StringConstants {
    private Text dynamicVdbName;
    private Label dynamicVdbLocationText;
    private Text dynamicVdbFileName;
    private GenerateDynamicVdbManager vdbManager;
    private Button excludeSourceDdlButton;
    private Button suppressDefaultAttributesOption;

    public GenerateDynamicVdbPageOne(GenerateDynamicVdbManager vdbManager) {
        super(GenerateDynamicVdbPageOne.class.getSimpleName(), "");
        this.vdbManager = vdbManager;
        this.setTitle(Messages.GenerateDynamicVdbPageOne_title);
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayoutData((Object)new GridData(768));
        mainPanel.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)mainPanel);
        Group summaryGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)Messages.GenerateDynamicVdbPageOne_summaryGroupName, (int)16, (int)2);
        summaryGroup.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)summaryGroup);
        Label nameLabel = new Label((Composite)summaryGroup, 0);
        nameLabel.setText(Messages.GenerateDynamicVdbPageOne_vdb);
        Label vdbAndLocation = new Label((Composite)summaryGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)vdbAndLocation);
        vdbAndLocation.setText(this.vdbManager.getArchiveVdb().getSourceFile().getFullPath().toString());
        vdbAndLocation.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        Label vdbNameLabel = new Label((Composite)summaryGroup, 0);
        vdbNameLabel.setText(Messages.GenerateDynamicVdbPageOne_vdbName);
        Label vdbName = new Label((Composite)summaryGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)vdbName);
        vdbName.setText(this.vdbManager.getArchiveVdb().getName());
        vdbName.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        WidgetFactory.createLabel((Composite)summaryGroup, (String)Messages.GenerateDynamicVdbPageOne_version);
        Label vdbVersion = new Label((Composite)summaryGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)vdbVersion);
        vdbVersion.setText(Integer.toString(this.vdbManager.getArchiveVdb().getVersion()));
        vdbVersion.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        ((GridData)summaryGroup.getLayoutData()).widthHint = 400;
        summaryGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)Messages.GenerateDynamicVdbPageOne_dynamicVdbDefinition, (int)16, (int)2);
        summaryGroup.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)summaryGroup);
        WidgetFactory.createLabel((Composite)summaryGroup, (int)4, (String)Messages.GenerateDynamicVdbPageOne_dynamicVdbName);
        this.dynamicVdbName = WidgetFactory.createTextField((Composite)summaryGroup, (int)0, (int)768);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.dynamicVdbName);
        this.dynamicVdbName.setText(this.vdbManager.getOutputVdbName());
        this.dynamicVdbName.setToolTipText(Messages.GenerateDynamicVdbPageOne_dynamicVdbNameTooltip);
        this.dynamicVdbName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                GenerateDynamicVdbPageOne.this.vdbManager.setOutputVdbName(GenerateDynamicVdbPageOne.this.dynamicVdbName.getText());
                GenerateDynamicVdbPageOne.this.validatePage();
            }
        });
        Label vdbVersionLabel = WidgetFactory.createLabel((Composite)summaryGroup, (String)Messages.GenerateDynamicVdbPageOne_version);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)vdbVersionLabel);
        final Text vdbVersionText = WidgetFactory.createTextField((Composite)summaryGroup);
        GridDataFactory.fillDefaults().span(2, 1).align(16384, 0x1000000).applyTo((Control)vdbVersionText);
        ((GridData)vdbVersionText.getLayoutData()).widthHint = 40;
        vdbVersionText.setText(this.vdbManager.getVersion());
        vdbVersionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateDynamicVdbPageOne.this.vdbManager.setVersion(vdbVersionText.getText());
                GenerateDynamicVdbPageOne.this.validatePage();
            }
        });
        summaryGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)Messages.GenerateDynamicVdbPageOne_dynamicVdbDestination, (int)16, (int)2);
        summaryGroup.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)summaryGroup);
        Label locationLabel = new Label((Composite)summaryGroup, 0);
        locationLabel.setText(Messages.GenerateDynamicVdbPageOne_location);
        this.dynamicVdbLocationText = new Label((Composite)summaryGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.dynamicVdbLocationText);
        if (this.vdbManager.getOutputLocation() != null) {
            this.dynamicVdbLocationText.setText(this.vdbManager.getOutputLocation().getFullPath().toString());
        }
        Button browseButton = new Button((Composite)summaryGroup, 8);
        GridData buttonGridData = new GridData();
        browseButton.setLayoutData((Object)buttonGridData);
        browseButton.setText(Messages.GenerateDynamicVdbPageOne_browse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateDynamicVdbPageOne.this.handleBrowse();
            }
        });
        WidgetFactory.createLabel((Composite)summaryGroup, (int)4, (String)Messages.GenerateDynamicVdbPageOne_dynamicVdbFileName);
        this.dynamicVdbFileName = WidgetFactory.createTextField((Composite)summaryGroup, (int)0, (int)768);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.dynamicVdbFileName);
        this.dynamicVdbFileName.setText(this.vdbManager.getOutputVdbFileName());
        this.dynamicVdbFileName.setToolTipText(Messages.GenerateDynamicVdbPageOne_dynamicVdbFileNameToolTip);
        this.dynamicVdbFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                GenerateDynamicVdbPageOne.this.vdbManager.setOutputVdbFileName(GenerateDynamicVdbPageOne.this.dynamicVdbFileName.getText());
                GenerateDynamicVdbPageOne.this.validatePage();
            }
        });
        Group optionsGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)Messages.GenerateDynamicVdbPageOne_options, (int)16, (int)1);
        optionsGroup.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)optionsGroup);
        this.excludeSourceDdlButton = new Button((Composite)optionsGroup, 32);
        this.excludeSourceDdlButton.setText(Messages.GenerateDynamicVdbPageOne_excludeSourceDdlMetadata);
        this.excludeSourceDdlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GenerateDynamicVdbPageOne.this.vdbManager.setExcludeSourceMetadata(GenerateDynamicVdbPageOne.this.excludeSourceDdlButton.getSelection());
                GenerateDynamicVdbPageOne.this.validatePage();
            }
        });
        this.suppressDefaultAttributesOption = WidgetFactory.createButton((Composite)optionsGroup, (String)Messages.GenerateDynamicVdbPageOne_suppressDefaultAttributesOption, (int)768, (int)1, (int)32);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.suppressDefaultAttributesOption);
        final IEclipsePreferences preferences = VdbPlugin.singleton().getPreferences();
        this.suppressDefaultAttributesOption.setSelection(preferences.getBoolean("suppressXmlDefaultAttributes", true));
        this.suppressDefaultAttributesOption.setToolTipText(Messages.GenerateDynamicVdbPageOne_suppressDefaultAttributesOptionTooltip);
        this.suppressDefaultAttributesOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                preferences.putBoolean("suppressXmlDefaultAttributes", GenerateDynamicVdbPageOne.this.suppressDefaultAttributesOption.getSelection());
                GenerateDynamicVdbPageOne.this.vdbManager.setDynamicVdb(null);
            }
        });
        final Button overwriteExistingOption = WidgetFactory.createButton((Composite)optionsGroup, (String)Messages.GenerateDynamicVdbPageOne_overwriteFilesOptionLabel, (int)768, (int)2, (int)32);
        overwriteExistingOption.setSelection(this.vdbManager.overwriteExistingFiles());
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)overwriteExistingOption);
        overwriteExistingOption.setToolTipText(Messages.GenerateDynamicVdbPageOne_overwriteVDBOptionTooltip);
        overwriteExistingOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateDynamicVdbPageOne.this.vdbManager.setOverwriteExistingFiles(overwriteExistingOption.getSelection());
                GenerateDynamicVdbPageOne.this.validatePage();
            }
        });
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.validatePage();
        }
        super.setVisible(visible);
    }

    void handleBrowse() {
        IProject project = this.vdbManager.getArchiveVdb().getSourceFile().getProject();
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)project, (ViewerFilter)new SingleProjectOrFolderFilter(project), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.dynamicVdbLocationText != null) {
            this.vdbManager.setOutputLocation(folder);
            this.dynamicVdbLocationText.setText(folder.getFullPath().makeRelative().toString());
        }
        this.validatePage();
    }

    private void validatePage() {
        this.vdbManager.validate();
        IStatus status = this.vdbManager.getStatus();
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
            return;
        }
        if (status.getSeverity() == 2) {
            this.setErrorMessage(null);
            WizardUtil.setPageComplete((WizardPage)this, (String)status.getMessage(), (int)2);
        } else {
            this.setErrorMessage(null);
            WizardUtil.setPageComplete((WizardPage)this, (String)"", (int)0);
        }
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }
}

