/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.views.content.adapter;

import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.views.content.ITeiidContentNode;
import org.teiid.designer.runtime.ui.views.content.ITeiidResourceNode;
import org.teiid.designer.runtime.ui.views.content.TeiidServerContainerNode;

public class TeiidResourceNodeAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!(adaptableObject instanceof ITeiidResourceNode)) {
            return null;
        }
        ITeiidResourceNode teiidResourceNode = (ITeiidResourceNode)adaptableObject;
        if (ITeiidResourceNode.class == adapterType) {
            return teiidResourceNode;
        }
        if (ITeiidServer.class.isAssignableFrom(adapterType)) {
            return this.adaptToTeiidServer(teiidResourceNode);
        }
        if (TeiidServerContainerNode.class == adapterType) {
            return this.adaptToTeiidServerContainerNode(teiidResourceNode);
        }
        return null;
    }

    private ITeiidServer adaptToTeiidServer(ITeiidResourceNode teiidResourceNode) {
        return teiidResourceNode.getTeiidServer();
    }

    private TeiidServerContainerNode adaptToTeiidServerContainerNode(ITeiidResourceNode teiidResourceNode) {
        if (teiidResourceNode.hasChildren()) {
            List<ITeiidContentNode<?>> children = teiidResourceNode.getChildren();
            if (children == null) {
                return null;
            }
            ITeiidContentNode<?> child = children.get(0);
            if (child instanceof TeiidServerContainerNode) {
                return (TeiidServerContainerNode)child;
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ITeiidServer.class, ITeiidResourceNode.class, TeiidServerContainerNode.class};
    }
}

