/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.vdb;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.datatools.connection.ConnectionInfoProviderFactory;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidDataSourceFactory;
import org.teiid.designer.runtime.spi.FailedTeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbModelEntry;

public class VdbDeployer {
    static final String PREFIX = I18nUtil.getPropertyPrefix(VdbDeployer.class);
    private static final String JNDI_PROPERTY_KEY = "jndi-name";
    private static final String JNDI_CONTEXT = "java:/";
    private final ITeiidServer teiidServer;
    private final boolean autoCreateDsOnServer;
    private Exception error;
    private final Shell shell;
    private DeployStatus status;
    private final Vdb vdb;

    public VdbDeployer(Shell shell, Vdb vdbBeingDeployed, ITeiidServer defaultServer, boolean shouldAutoCreateDataSourceOnServer) {
        CoreArgCheck.isNotNull((Object)vdbBeingDeployed, (String)"Vdb is null");
        CoreArgCheck.isNotNull((Object)defaultServer, (String)"Default Teiid Instance is null");
        CoreArgCheck.isNotNull((Object)shell, (String)"Shell is null");
        this.teiidServer = defaultServer;
        this.shell = shell;
        this.vdb = vdbBeingDeployed;
        this.autoCreateDsOnServer = shouldAutoCreateDataSourceOnServer;
    }

    public Exception getException() {
        return this.error;
    }

    public DeployStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String deploy(IProgressMonitor monitor) {
        block24: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            failedModelName = null;
            try {
                if (this.vdb.getModelEntries().isEmpty()) ** GOTO lbl75
                monitor.beginTask(DqpUiConstants.UTIL.getString(String.valueOf(VdbDeployer.PREFIX) + "deployMainTask", (Object)this.getVdbName()), -1);
                hasJndiProblems = false;
                foundFirstOne = false;
                createOnServer = false;
                var7_7 = this.vdb.getModelEntries().iterator();
                if (true) ** GOTO lbl67
            }
            catch (Exception e) {
                this.status = DeployStatus.EXCEPTION;
                this.error = e;
                monitor.done();
            }
            catch (Throwable var18_19) {
                monitor.done();
                throw var18_19;
            }
lbl20:
            // 1 sources

            while (true) {
                monitor.done();
                return null;
            }
            {
                block23: {
                    do {
                        modelName = modelEntry.getPath().toFile().getName();
                        monitor.subTask(DqpUiConstants.UTIL.getString(String.valueOf(VdbDeployer.PREFIX) + "checkModelTypeTask", (Object)modelName));
                        autoCreate = false;
                        modelType = ((VdbModelEntry)modelEntry).getType();
                        sourceModel = modelType.equalsIgnoreCase(ModelType.PHYSICAL_LITERAL.getName());
                        if (sourceModel) {
                            monitor.subTask(DqpUiConstants.UTIL.getString(String.valueOf(VdbDeployer.PREFIX) + "checkModelTranslatorTask", (Object)modelName));
                            if (!this.hasValidTranslator((VdbModelEntry)modelEntry)) {
                                this.status = DeployStatus.TRANSLATOR_PROBLEM;
                                break block23;
                            }
                            modelFile = modelEntry.findFileInWorkspace();
                            if (this.vdb.isPreview() && !this.hasConnectionInfo(modelFile)) {
                                this.status = DeployStatus.SOURCE_CONNECTION_INFO_PROBLEM;
                                break block23;
                            }
                            monitor.subTask(DqpUiConstants.UTIL.getString(String.valueOf(VdbDeployer.PREFIX) + "checkModelDataSourceTask", (Object)modelName));
                            sourceName = ((VdbModelEntry)modelEntry).getSourceInfo().getSource(0).getName();
                            jndiName = ((VdbModelEntry)modelEntry).getSourceInfo().getSource(0).getJndiName();
                            if (!StringUtilities.isEmpty((String)jndiName) && !this.dataSourceWithJndiExists(jndiName)) {
                                jndiNameWithoutContext = jndiName;
                                if (jndiName.startsWith("java:/")) {
                                    jndiNameWithoutContext = jndiName.substring("java:/".length());
                                }
                                if (sourceName.equals(jndiNameWithoutContext) && this.autoCreateDsOnServer) {
                                    autoCreate = true;
                                }
                                if (!autoCreate && !foundFirstOne) {
                                    foundFirstOne = true;
                                    result = new boolean[1];
                                    this.shell.getDisplay().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (MessageDialog.openQuestion((Shell)VdbDeployer.this.getShell(), (String)DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "createDataSourcesConfirmation.title", new Object[0]), (String)DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "createDataSourcesConfirmation.message", (Object)VdbDeployer.this.getVdbName()))) {
                                                result[0] = true;
                                            }
                                        }
                                    });
                                    if (result[0]) {
                                        createOnServer = true;
                                    }
                                }
                                if ((autoCreate || createOnServer) && modelFile != null) {
                                    monitor.subTask(DqpUiConstants.UTIL.getString(String.valueOf(VdbDeployer.PREFIX) + "createModelDataSourceTask", (Object)modelName));
                                    factory = new TeiidDataSourceFactory();
                                    ds = factory.createDataSource(this.teiidServer, modelFile, jndiNameWithoutContext, false);
                                    if (ds == null) {
                                        this.status = DeployStatus.CREATE_DATA_SOURCE_FAILED;
                                        break block23;
                                    }
                                    if (ds instanceof FailedTeiidDataSource) {
                                        this.status = DeployStatus.CREATE_DATA_SOURCE_FAILED;
                                        failedModelName = FileUtils.getNameWithoutExtension((IResource)modelFile);
                                        break block23;
                                    }
                                } else if (!hasJndiProblems) {
                                    hasJndiProblems = true;
                                }
                            }
                        }
lbl67:
                        // 9 sources

                        if (!var7_7.hasNext()) break block23;
                        modelEntry = (VdbEntry)var7_7.next();
                    } while (!monitor.isCanceled());
                    this.status = DeployStatus.MONITOR_CANCELLED;
                    ** continue;
                }
                if (hasJndiProblems) {
                    this.shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (MessageDialog.openQuestion((Shell)VdbDeployer.this.getShell(), (String)DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "deployWithErrorsConfirmation.title", new Object[0]), (String)DqpUiConstants.UTIL.getString(String.valueOf(PREFIX) + "deployWithErrorsConfirmation.message", new Object[0]))) {
                                VdbDeployer.this.setStatus(null);
                            } else {
                                VdbDeployer.this.setStatus(DeployStatus.DEPLOY_VDB_CANCELED);
                            }
                        }
                    });
                }
lbl75:
                // 4 sources

                if (this.status != null) break block24;
                monitor.subTask(DqpUiConstants.UTIL.getString(String.valueOf(VdbDeployer.PREFIX) + "deployVdbTask", (Object)this.getVdbName()));
                this.teiidServer.deployVdb(this.vdb.getSourceFile());
                this.status = this.teiidServer.hasVdb(this.getVdbName()) != false ? DeployStatus.DEPLOYED_VDB : DeployStatus.DEPLOY_VDB_FAILED;
            }
        }
        monitor.done();
        if (failedModelName != null) {
            return failedModelName;
        }
        return null;
    }

    private boolean dataSourceWithJndiExists(String jndiName) {
        if (jndiName == null || jndiName.isEmpty()) {
            return false;
        }
        boolean hasSourceWithJndi = false;
        Collection serverSources = null;
        try {
            serverSources = this.teiidServer.getDataSources();
        }
        catch (Exception ex) {
            DqpPlugin.Util.log((Throwable)ex);
        }
        if (serverSources != null && !serverSources.isEmpty()) {
            for (ITeiidDataSource serverSource : serverSources) {
                String jndiNameWithContext;
                String serverJndiName = serverSource.getPropertyValue(JNDI_PROPERTY_KEY);
                if (CoreStringUtil.isEmpty((String)serverJndiName)) continue;
                if (serverJndiName.equalsIgnoreCase(jndiName)) {
                    hasSourceWithJndi = true;
                    break;
                }
                if (jndiName.startsWith(JNDI_CONTEXT) || !serverJndiName.equalsIgnoreCase(jndiNameWithContext = JNDI_CONTEXT + jndiName)) continue;
                hasSourceWithJndi = true;
                break;
            }
        }
        return hasSourceWithJndi;
    }

    private boolean hasConnectionInfo(IFile modelFile) {
        boolean hasConnInfo = true;
        try {
            ModelResource modelResource = ModelUtil.getModelResource((IFile)modelFile, (boolean)true);
            ConnectionInfoProviderFactory manager = new ConnectionInfoProviderFactory();
            manager.getProvider(modelResource);
        }
        catch (Exception exception) {
            hasConnInfo = false;
        }
        return hasConnInfo;
    }

    public String getVdbName() {
        return this.vdb.getName();
    }

    Shell getShell() {
        return this.shell;
    }

    private boolean hasValidTranslator(VdbModelEntry modelEntry) throws Exception {
        boolean isValid;
        String translatorName = modelEntry.getSourceInfo().getSource(0).getTranslatorName();
        if (StringUtilities.isEmpty((String)translatorName)) {
            return false;
        }
        boolean bl = isValid = this.teiidServer.getTranslator(translatorName) != null;
        if (!isValid && !this.vdb.getTranslators().isEmpty()) {
            for (TranslatorOverride override : this.vdb.getTranslators()) {
                if (!override.getName().equalsIgnoreCase(translatorName)) continue;
                isValid = this.teiidServer.getTranslator(override.getType()) != null;
                break;
            }
        }
        return isValid;
    }

    void setStatus(DeployStatus status) {
        this.status = status;
    }

    public static enum DeployStatus {
        CREATE_DATA_SOURCE_FAILED,
        DEPLOYED_VDB,
        DEPLOY_VDB_CANCELED,
        DEPLOY_VDB_FAILED,
        EXCEPTION,
        MONITOR_CANCELLED,
        TRANSLATOR_PROBLEM,
        SOURCE_CONNECTION_INFO_PROBLEM;


        public boolean isDeployed() {
            return this == DEPLOYED_VDB;
        }

        public boolean isError() {
            return this == CREATE_DATA_SOURCE_FAILED || this == DEPLOY_VDB_FAILED || this == EXCEPTION || this == TRANSLATOR_PROBLEM || this == SOURCE_CONNECTION_INFO_PROBLEM;
        }
    }
}

