/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.vdb;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.datatools.connectivity.ConnectivityUtil;
import org.teiid.designer.datatools.ui.dialogs.NewTeiidFilteredCPWizard;
import org.teiid.designer.datatools.ui.dialogs.TeiidCPWizardDialog;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidJdbcInfo;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.actions.DeployVdbAction;
import org.teiid.designer.runtime.ui.actions.OpenScrapbookEditorAction;
import org.teiid.designer.runtime.ui.vdb.VdbAgeChecker;
import org.teiid.designer.runtime.ui.vdb.VdbConstants;
import org.teiid.designer.runtime.ui.vdb.VdbRequiresSaveChecker;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;

public class ExecuteVdbWorker
implements VdbConstants {
    protected static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ExecuteVdbWorker.class);

    static String getString(String key) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + key, new Object[0]);
    }

    static String getString(String key, Object param) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + key, param);
    }

    static String getString(String key, Object param, Object param2) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + key, new Object[]{param, param2});
    }

    public boolean isExecutableVdb(Object vdb) {
        String extension;
        return vdb instanceof IFile && (extension = ((IFile)vdb).getFileExtension()) != null && extension.equals("vdb");
    }

    public Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public void run(final IFile selectedVdb) {
        if (!VdbRequiresSaveChecker.insureOpenVdbSaved(selectedVdb)) {
            return;
        }
        UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ExecuteVdbWorker.this.internalRun(selectedVdb);
            }
        });
    }

    void internalRun(IFile selectedVdbFile) {
        ITeiidServer teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
        boolean deployed = false;
        try {
            if (teiidServer != null) {
                IStatus connectStatus = teiidServer.ping();
                if (connectStatus.isOK()) {
                    if (!VdbAgeChecker.doDeploy(selectedVdbFile, teiidServer.getServerVersion())) {
                        return;
                    }
                    deployed = DeployVdbAction.deployVdb(teiidServer, selectedVdbFile);
                    String vdbName = FileUtils.getNameWithoutExtension((IResource)selectedVdbFile);
                    if (teiidServer.isVdbActive(vdbName)) {
                        if (deployed) {
                            this.executeVdb(DqpPlugin.getInstance().getServerManager().getDefaultServer(), vdbName);
                        }
                    } else if (teiidServer.isVdbLoading(vdbName)) {
                        StringBuilder message = new StringBuilder(ExecuteVdbWorker.getString("vdbLoadingMessage", selectedVdbFile.getName()));
                        MessageDialog.openWarning((Shell)this.getShell(), (String)ExecuteVdbWorker.getString("vdbLoadingTitle"), (String)message.toString());
                    } else if (deployed) {
                        StringBuilder message = new StringBuilder(ExecuteVdbWorker.getString("vdbNotActiveMessage", selectedVdbFile.getName()));
                        if (teiidServer.hasVdb(vdbName)) {
                            for (String error : teiidServer.retrieveVdbValidityErrors(vdbName)) {
                                message.append("\nERROR:\t").append(error);
                            }
                        }
                        MessageDialog.openWarning((Shell)this.getShell(), (String)ExecuteVdbWorker.getString("vdbNotActiveTitle"), (String)message.toString());
                    }
                } else {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)ExecuteVdbWorker.getString("noTeiidServerConnection.title"), (String)ExecuteVdbWorker.getString("noTeiidServerConnection.message", connectStatus.getMessage()));
                }
            } else {
                MessageDialog.openWarning((Shell)this.getShell(), (String)ExecuteVdbWorker.getString("noTeiidInstance.title"), (String)ExecuteVdbWorker.getString("noTeiidInstance.message"));
            }
        }
        catch (Exception e) {
            DqpUiConstants.UTIL.log(4, (Throwable)e, ExecuteVdbWorker.getString("vdbNotDeployedError", selectedVdbFile.getName()));
        }
    }

    public void executeVdb(ITeiidServer teiidServer, String vdbName) throws Exception {
        this.processForDTP(teiidServer, vdbName);
    }

    private void openError(String genericTitle, IStatus status) {
        if (status == null) {
            return;
        }
        int codes = 6;
        if (!status.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)status.getMessage(), null, (IStatus)children[0], (int)codes);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
    }

    public void processForDTP(ITeiidServer teiidServer, String vdbName) throws Exception {
        String driverPath = teiidServer.getAdminDriverPath();
        TeiidJdbcInfo jdbcInfo = new TeiidJdbcInfo(vdbName, teiidServer.getTeiidJdbcInfo());
        String connectionURL = jdbcInfo.getUrl();
        String profileName = ExecuteVdbWorker.getString("profileName", vdbName, teiidServer.getHost());
        IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(profileName);
        if (profile == null) {
            if (jdbcInfo.getUsername() == null || jdbcInfo.getUsername().isEmpty() || jdbcInfo.getPassword() == null || jdbcInfo.getPassword().isEmpty()) {
                Properties cpProps = ConnectivityUtil.createVDBTeiidProfileProperties((ITeiidServerVersion)teiidServer.getServerVersion(), (String)driverPath, (String)connectionURL, (String)jdbcInfo.getUsername(), (String)jdbcInfo.getPassword(), (String)vdbName, (String)profileName);
                NewTeiidFilteredCPWizard wiz = new NewTeiidFilteredCPWizard(profileName, null);
                TeiidCPWizardDialog wizardDialog = new TeiidCPWizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
                wizardDialog.setProperties(cpProps);
                wizardDialog.setBlockOnOpen(true);
                if (wizardDialog.open() != 0) {
                    return;
                }
            } else {
                profile = ConnectivityUtil.createVDBTeiidProfile((ITeiidServerVersion)teiidServer.getServerVersion(), (String)driverPath, (String)connectionURL, (String)jdbcInfo.getUsername(), (String)jdbcInfo.getPassword(), (String)vdbName, (String)profileName);
            }
        }
        IStatus connectionStatus = Status.OK_STATUS;
        if (profile != null) {
            connectionStatus = profile.connectWithoutJob();
        }
        try {
            PlatformUI.getWorkbench().showPerspective("org.eclipse.datatools.sqltools.sqleditor.perspectives.EditorPerspective", DqpUiPlugin.getDefault().getCurrentWorkbenchWindow());
        }
        catch (Throwable e) {
            DqpUiConstants.UTIL.log(e);
        }
        if (connectionStatus.getSeverity() < 4) {
            OpenScrapbookEditorAction sbAction = new OpenScrapbookEditorAction();
            sbAction.run(profile, vdbName);
        } else {
            this.openError(ExecuteVdbWorker.getString("vdbConnectionError.title"), connectionStatus);
        }
    }
}

