/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.server.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.util.ServerLifecycleAdapter;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.loading.ComponentLoadingManager;
import org.teiid.designer.core.loading.IManagedLoading;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.IServersProvider;
import org.teiid.designer.runtime.TeiidServerFactory;
import org.teiid.designer.runtime.adapter.TeiidServerAdapterFactory;
import org.teiid.designer.runtime.registry.TeiidRuntimeRegistry;
import org.teiid.designer.runtime.spi.ExecutionConfigurationEvent;
import org.teiid.designer.runtime.spi.IExecutionConfigurationListener;
import org.teiid.designer.runtime.spi.ITeiidAdminInfo;
import org.teiid.designer.runtime.spi.ITeiidJdbcInfo;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.util.ErrorHandler;

public class TeiidServerEditor
extends EditorPart
implements IManagedLoading {
    public static final String EDITOR_ID = TeiidServerEditor.class.getCanonicalName();
    private static final String EMPTY_STRING = "";
    private static final String NOT_CONNECTED = DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.notConnectedLabel", new Object[0]);
    private static final int PORT_MIN = 1;
    private static final int PORT_MAX = 65535;
    private boolean dirty = false;
    private IServerWorkingCopy parentServerWorkingCopy;
    private IServer parentServer;
    private ITeiidServer teiidServer;
    private ScrolledForm form;
    private FormToolkit toolkit;
    private Composite contentsPanel;
    private ProgressBar progressBar;
    private Label jbServerNameLabel;
    private Label hostNameLabel;
    private Combo versionValueCombo;
    private Label adminDescriptionLabel;
    private Text adminUserNameText;
    private Text adminPasswdText;
    private Control adminPort;
    private Button adminSSLCheckbox;
    private Hyperlink adminPingHyperlink;
    private Label adminPingResultLabel;
    private Text jdbcUserNameText;
    private Text jdbcPasswdText;
    private Control jdbcPort;
    private Text jdbcPortOverride;
    private Button jdbcSSLCheckbox;
    private Hyperlink jdbcPingHyperlink;
    private Label jdbcPingResultLabel;
    private ServerResourceCommandManager commandManager;
    private IExecutionConfigurationListener excutionConfigListener = new IExecutionConfigurationListener(){

        public void configurationChanged(final ExecutionConfigurationEvent event) {
            TeiidServerEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEventType()) {
                        case REFRESH: 
                        case UPDATE: {
                            TeiidServerEditor.this.refreshDisplayValues();
                            break;
                        }
                        case REMOVE: {
                            TeiidServerEditor.this.disposeContents();
                            TeiidServerEditor.this.manageLoad(new Properties());
                        }
                    }
                }
            });
        }
    };
    private ModifyListener dirtyModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            TeiidServerEditor.this.setDirty();
            TeiidServerEditor.this.execute(new TeiidServerCommand(TeiidServerEditor.this.parentServerWorkingCopy));
        }
    };
    private SelectionListener dirtySelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TeiidServerEditor.this.setDirty();
            TeiidServerEditor.this.execute(new TeiidServerCommand(TeiidServerEditor.this.parentServerWorkingCopy));
        }
    };
    private IServerLifecycleListener serverLifecycleListener = new ServerLifecycleAdapter(){

        public void serverChanged(IServer server) {
            if (!TeiidServerEditor.this.parentServer.equals(server)) {
                return;
            }
            TeiidServerEditor.this.refreshDisplayValues();
        }
    };

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof IServerEditorPartInput) {
            IServerEditorPartInput serverInput = (IServerEditorPartInput)input;
            this.commandManager = ((ServerEditorPartInput)input).getServerCommandManager();
            this.parentServerWorkingCopy = serverInput.getServer();
            this.parentServer = this.parentServerWorkingCopy.getOriginal();
        }
    }

    public void createPartControl(Composite parent) {
        String title = DqpUiConstants.UTIL.getString("TeiidServerEditor.title", new Object[0]);
        this.setPartName(title);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.toolkit.decorateFormHeading(this.form.getForm());
        this.form.setText(title);
        GridLayoutFactory.fillDefaults().applyTo(this.form.getBody());
        this.progressBar = new ProgressBar(this.form.getBody(), 65538);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)this.progressBar);
        ComponentLoadingManager manager = ComponentLoadingManager.getInstance();
        manager.manageLoading((IManagedLoading)this);
    }

    public void manageLoad(Properties args) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TeiidServerEditor.this.progressBar.dispose();
                if (TeiidServerEditor.this.form.getBody().isDisposed()) {
                    return;
                }
                TeiidServerEditor.this.contentsPanel = TeiidServerEditor.this.toolkit.createComposite(TeiidServerEditor.this.form.getBody());
                GridLayoutFactory.fillDefaults().numColumns(1).spacing(10, 0).applyTo(TeiidServerEditor.this.contentsPanel);
                GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)TeiidServerEditor.this.contentsPanel);
                IServersProvider serversProvider = DqpPlugin.getInstance().getServersProvider();
                serversProvider.addServerLifecycleListener(TeiidServerEditor.this.serverLifecycleListener);
                TeiidServerEditor.this.getServerManager().addListener(TeiidServerEditor.this.excutionConfigListener);
                try {
                    TeiidServerAdapterFactory adapterFactory = new TeiidServerAdapterFactory();
                    if (TeiidServerEditor.this.parentServer.getServerState() == 2) {
                        TeiidServerEditor.this.teiidServer = adapterFactory.adaptServer(TeiidServerEditor.this.parentServer, new TeiidServerFactory.ServerOptions[]{TeiidServerFactory.ServerOptions.ADD_TO_REGISTRY});
                    } else {
                        TeiidServerEditor.this.teiidServer = adapterFactory.adaptServer(TeiidServerEditor.this.parentServer, new TeiidServerFactory.ServerOptions[]{TeiidServerFactory.ServerOptions.NO_CHECK_CONNECTION, TeiidServerFactory.ServerOptions.ADD_TO_REGISTRY});
                    }
                }
                catch (Exception ex) {
                    ErrorHandler.toExceptionDialog((Throwable)ex);
                }
                if (TeiidServerEditor.this.teiidServer != null) {
                    TeiidServerEditor.this.createOverviewSection(TeiidServerEditor.this.contentsPanel);
                    TeiidServerEditor.this.createAdminSection(TeiidServerEditor.this.contentsPanel);
                    TeiidServerEditor.this.createJDBCSection(TeiidServerEditor.this.contentsPanel);
                } else {
                    Label noTeiidLabel = TeiidServerEditor.this.toolkit.createLabel(TeiidServerEditor.this.contentsPanel, DqpUiConstants.UTIL.getString("TeiidServerEditor.noTeiidServer", new Object[0]));
                    TeiidServerEditor.this.blueForeground((Control)noTeiidLabel);
                    GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)noTeiidLabel);
                }
                TeiidServerEditor.this.form.reflow(true);
            }
        };
        UiUtil.runInSwtThread((Runnable)runnable, (boolean)true);
    }

    private void disposeContents() {
        if (this.contentsPanel != null) {
            this.contentsPanel.dispose();
        }
    }

    private void blueForeground(Control control) {
        control.setForeground(control.getDisplay().getSystemColor(10));
    }

    private boolean isSevenServer() {
        if (this.teiidServer == null) {
            return false;
        }
        return this.teiidServer.getServerVersion().isSevenServer();
    }

    /*
     * Unable to fully structure code
     */
    private void createOverviewSection(Composite parent) {
        block4: {
            section = this.toolkit.createSection(parent, 322);
            section.setText(DqpUiConstants.UTIL.getString("TeiidServerOverviewSection.title", new Object[0]));
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
            composite = this.toolkit.createComposite((Composite)section);
            GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 10).spacing(5, 20).applyTo(composite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
            jbLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerOverviewSection.jbLabel", new Object[0]));
            this.blueForeground((Control)jbLabel);
            jbServerName = this.parentServer != null ? this.parentServer.getName() : "";
            this.jbServerNameLabel = this.toolkit.createLabel(composite, jbServerName);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.jbServerNameLabel);
            this.blueForeground((Control)this.jbServerNameLabel);
            hostLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerOverviewSection.hostLabel", new Object[0]));
            this.blueForeground((Control)hostLabel);
            this.hostNameLabel = this.toolkit.createLabel(composite, this.teiidServer.getHost());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.hostNameLabel);
            this.blueForeground((Control)this.hostNameLabel);
            versionLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerOverviewSection.versionLabel", new Object[0]));
            this.blueForeground((Control)versionLabel);
            this.versionValueCombo = new Combo(composite, 4);
            this.versionValueCombo.setToolTipText(DqpUiConstants.UTIL.getString("TeiidServerOverviewSection.versionValueTooltip", new Object[0]));
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.versionValueCombo);
            this.versionValueCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TeiidServerEditor.this.setDirty();
                    TeiidServerEditor.this.execute(new TeiidServerCommand(TeiidServerEditor.this.parentServerWorkingCopy));
                }
            });
            serverVersions = new ArrayList<String>();
            serverVersions.add(this.teiidServer.getServerVersion().toString());
            try {
                registeredServerVersions = TeiidRuntimeRegistry.getInstance().getSupportedVersions();
                for (ITeiidServerVersion version : registeredServerVersions) {
                    serverVersions.add(version.toString());
                }
                break block4;
            }
            catch (Exception v0) {
                var12_15 = ITeiidServerVersion.VersionID.values();
                var11_12 = var12_15.length;
                var10_14 = 0;
                ** while (var10_14 < var11_12)
            }
lbl-1000:
            // 1 sources

            {
                versionId = var12_15[var10_14];
                serverVersions.add(versionId.toString());
                ++var10_14;
                continue;
            }
        }
        Collections.sort(serverVersions, Collections.<T>reverseOrder());
        this.versionValueCombo.setItems(serverVersions.toArray(new String[0]));
        this.versionValueCombo.setText(this.teiidServer.getServerVersion().toString());
        this.versionValueCombo.addModifyListener(this.dirtyModifyListener);
        this.versionValueCombo.setEnabled(this.teiidServer.isConnected() == false);
        this.toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    private void createAdminSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 322);
        section.setText(DqpUiConstants.UTIL.getString("TeiidServerAdminSection.title", new Object[0]));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        Composite composite = this.toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 10).spacing(5, 20).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        if (this.isSevenServer()) {
            Label userNameLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerAdminSection.userNameLabel", new Object[0]));
            this.blueForeground((Control)userNameLabel);
            this.adminUserNameText = this.toolkit.createText(composite, this.teiidServer.getTeiidAdminInfo().getUsername());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.adminUserNameText);
            this.adminUserNameText.addModifyListener(this.dirtyModifyListener);
            Label passwdLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerAdminSection.passwordLabel", new Object[0]));
            this.blueForeground((Control)passwdLabel);
            this.adminPasswdText = this.toolkit.createText(composite, this.teiidServer.getTeiidAdminInfo().getPassword(), 0x400000);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.adminPasswdText);
            this.adminPasswdText.addModifyListener(this.dirtyModifyListener);
            Label portLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerAdminSection.portLabel", new Object[0]));
            this.blueForeground((Control)portLabel);
            Text adminPortText = this.toolkit.createText(composite, this.teiidServer.getTeiidAdminInfo().getPort());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)adminPortText);
            adminPortText.addModifyListener(this.dirtyModifyListener);
            this.adminPort = adminPortText;
            Label checkboxLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("serverPageSecureConnAdminLabel", new Object[0]));
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)checkboxLabel);
            this.blueForeground((Control)checkboxLabel);
            this.adminSSLCheckbox = this.toolkit.createButton(composite, EMPTY_STRING, 32);
            this.adminSSLCheckbox.setSelection(this.teiidServer.getTeiidAdminInfo().isSecure());
            this.adminSSLCheckbox.addSelectionListener(this.dirtySelectionListener);
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.adminSSLCheckbox);
        } else {
            this.adminDescriptionLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerAdminSection.description", new Object[0]));
            this.blueForeground((Control)this.adminDescriptionLabel);
            GridDataFactory.fillDefaults().grab(false, false).span(2, 1).applyTo((Control)this.adminDescriptionLabel);
            Label portLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerAdminSection.portLabel", new Object[0]));
            this.blueForeground((Control)portLabel);
            this.adminPort = this.toolkit.createLabel(composite, this.teiidServer.getTeiidAdminInfo().getPort());
        }
        this.blueForeground(this.adminPort);
        this.adminPingHyperlink = this.toolkit.createHyperlink(composite, DqpUiConstants.UTIL.getString("TeiidServerAdminSection.testPingButtonLabel", new Object[0]), 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.adminPingHyperlink);
        this.adminPingHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TeiidServerEditor.this.doSave(null);
                IStatus status = TeiidServerEditor.this.teiidServer.testPing();
                TeiidServerEditor.this.adminPingResultLabel.setText(status.getMessage());
                TeiidServerEditor.this.form.layout(true, true);
            }
        });
        this.adminPingResultLabel = this.toolkit.createLabel(composite, EMPTY_STRING, 64);
        GridDataFactory.swtDefaults().align(1, 4).grab(true, true).hint(325, -1).applyTo((Control)this.adminPingResultLabel);
        this.toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    private void createJDBCSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 322);
        section.setText(DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.title", new Object[0]));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        Composite composite = this.toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 10).spacing(5, 20).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        Label userNameLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.userNameLabel", new Object[0]));
        this.blueForeground((Control)userNameLabel);
        this.jdbcUserNameText = this.toolkit.createText(composite, this.teiidServer.getTeiidJdbcInfo().getUsername());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.jdbcUserNameText);
        this.jdbcUserNameText.addModifyListener(this.dirtyModifyListener);
        Label passwdLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.passwordLabel", new Object[0]));
        this.blueForeground((Control)passwdLabel);
        this.jdbcPasswdText = this.toolkit.createText(composite, this.teiidServer.getTeiidJdbcInfo().getPassword(), 0x400000);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.jdbcPasswdText);
        this.jdbcPasswdText.addModifyListener(this.dirtyModifyListener);
        Label portLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.portLabel", new Object[0]));
        portLabel.setToolTipText(DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.portToolTip", new Object[0]));
        this.blueForeground((Control)portLabel);
        if (this.isSevenServer()) {
            Text jdbcPortText = this.toolkit.createText(composite, this.teiidServer.getTeiidJdbcInfo().getPort());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)jdbcPortText);
            jdbcPortText.addModifyListener(this.dirtyModifyListener);
            this.jdbcPort = jdbcPortText;
        } else {
            String portValue = NOT_CONNECTED;
            if (this.teiidServer.isConnected() && (portValue = this.getServerManager().getJdbcPort(this.teiidServer, false)) == null) {
                portValue = NOT_CONNECTED;
            }
            this.jdbcPort = this.toolkit.createLabel(composite, portValue);
            this.jdbcPort.setToolTipText(DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.portToolTip", new Object[0]));
        }
        this.blueForeground(this.jdbcPort);
        if (!this.isSevenServer()) {
            Label portOverrideLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.portOverrideLabel", new Object[0]));
            this.blueForeground((Control)portOverrideLabel);
            portOverrideLabel.setToolTipText(DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.portOverrideToolTip", new Object[0]));
            String portOverride = this.getServerManager().getJdbcPort(this.teiidServer, true);
            if (portOverride == null) {
                portOverride = EMPTY_STRING;
            }
            this.jdbcPortOverride = this.toolkit.createText(composite, portOverride);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.jdbcPortOverride);
            this.jdbcPortOverride.addModifyListener(this.dirtyModifyListener);
            this.jdbcPortOverride.setToolTipText(DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.portOverrideToolTip", new Object[0]));
        }
        Label checkboxLabel = this.toolkit.createLabel(composite, DqpUiConstants.UTIL.getString("serverPageSecureConnJDBCLabel", new Object[0]));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)checkboxLabel);
        this.blueForeground((Control)checkboxLabel);
        this.jdbcSSLCheckbox = this.toolkit.createButton(composite, EMPTY_STRING, 32);
        this.jdbcSSLCheckbox.setSelection(this.teiidServer.getTeiidJdbcInfo().isSecure());
        this.blueForeground((Control)this.jdbcSSLCheckbox);
        this.jdbcSSLCheckbox.addSelectionListener(this.dirtySelectionListener);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.jdbcSSLCheckbox);
        this.jdbcPingHyperlink = this.toolkit.createHyperlink(composite, DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.testPingButtonLabel", new Object[0]), 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.jdbcPingHyperlink);
        this.jdbcPingHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TeiidServerEditor.this.doSave(null);
                IStatus status = TeiidServerEditor.this.teiidServer.testJDBCPing(TeiidServerEditor.this.teiidServer.getHost(), TeiidServerEditor.this.teiidServer.getTeiidJdbcInfo().getPort(), TeiidServerEditor.this.teiidServer.getTeiidJdbcInfo().getUsername(), TeiidServerEditor.this.teiidServer.getTeiidJdbcInfo().getPassword());
                TeiidServerEditor.this.jdbcPingResultLabel.setText(status.getMessage());
                TeiidServerEditor.this.form.layout(true, true);
            }
        });
        this.jdbcPingResultLabel = this.toolkit.createLabel(composite, EMPTY_STRING, 64);
        GridDataFactory.swtDefaults().align(1, 4).grab(true, true).hint(325, -1).applyTo((Control)this.jdbcPingResultLabel);
        this.toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    private void execute(ServerCommand command) {
        this.commandManager.execute((IUndoableOperation)command);
    }

    private void refreshDisplayValues() {
        String portValue;
        if (this.teiidServer == null || this.form.isDisposed()) {
            return;
        }
        this.hostNameLabel.setText(this.teiidServer.getHost());
        String versionValue = this.teiidServer.getServerVersion().toString();
        if (!this.versionValueCombo.getText().equals(versionValue)) {
            this.versionValueCombo.setText(versionValue);
        }
        this.versionValueCombo.setEnabled(!this.teiidServer.isConnected());
        this.jbServerNameLabel.setText(this.parentServer != null ? this.parentServer.getName() : EMPTY_STRING);
        ITeiidAdminInfo teiidAdminInfo = this.teiidServer.getTeiidAdminInfo();
        ITeiidJdbcInfo teiidJdbcInfo = this.teiidServer.getTeiidJdbcInfo();
        if (this.isSevenServer()) {
            if (this.adminUserNameText != null) {
                this.setIfDifferent(this.adminUserNameText, teiidAdminInfo.getUsername() != null ? teiidAdminInfo.getUsername() : EMPTY_STRING);
            }
            if (this.adminPasswdText != null) {
                this.setIfDifferent(this.adminPasswdText, teiidAdminInfo.getPassword() != null ? teiidAdminInfo.getPassword() : EMPTY_STRING);
            }
            String string = portValue = teiidAdminInfo.getPort() != null ? teiidAdminInfo.getPort() : EMPTY_STRING;
            if (this.adminPort instanceof Text) {
                this.setIfDifferent((Text)this.adminPort, portValue);
            } else if (this.adminPort instanceof Label) {
                ((Label)this.adminPort).setText(portValue);
            }
            if (this.adminSSLCheckbox != null) {
                this.adminSSLCheckbox.setSelection(teiidAdminInfo.isSecure());
            }
        }
        this.setIfDifferent(this.jdbcUserNameText, teiidJdbcInfo.getUsername() != null ? teiidJdbcInfo.getUsername() : EMPTY_STRING);
        this.setIfDifferent(this.jdbcPasswdText, teiidJdbcInfo.getPassword() != null ? teiidJdbcInfo.getPassword() : EMPTY_STRING);
        if (this.isSevenServer()) {
            String string = portValue = teiidJdbcInfo.getPort() != null ? teiidJdbcInfo.getPort() : EMPTY_STRING;
            if (this.jdbcPort instanceof Text) {
                this.setIfDifferent((Text)this.jdbcPort, portValue);
            }
        } else {
            portValue = NOT_CONNECTED;
            if (this.teiidServer.isConnected()) {
                portValue = this.getServerManager().getJdbcPort(this.teiidServer, false);
                if (portValue == null) {
                    portValue = NOT_CONNECTED;
                }
                ((Label)this.jdbcPort).setText(portValue);
            }
            if ((portValue = this.getServerManager().getJdbcPort(this.teiidServer, true)) != null) {
                this.setIfDifferent(this.jdbcPortOverride, portValue);
            }
        }
        this.jdbcSSLCheckbox.setSelection(teiidJdbcInfo.isSecure());
    }

    private void setIfDifferent(Text text, String value) {
        if (value != null && !value.equals(text.getText())) {
            text.setText(value);
        }
    }

    private ITeiidServerManager getServerManager() {
        return DqpPlugin.getInstance().getServerManager();
    }

    public void dispose() {
        this.getServerManager().removeListener(this.excutionConfigListener);
        IServersProvider serversProvider = DqpPlugin.getInstance().getServersProvider();
        serversProvider.removeServerLifecycleListener(this.serverLifecycleListener);
        super.dispose();
    }

    public void setFocus() {
        if (this.versionValueCombo != null && !this.versionValueCombo.isDisposed()) {
            this.versionValueCombo.setFocus();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.teiidServer == null) {
            return;
        }
        String invalidMessage = this.validate();
        if (invalidMessage != null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Teiid Server Configuration Errors", (String)invalidMessage);
            return;
        }
        ITeiidServerVersion newTeiidServerVersion = this.teiidServer.getServerVersion();
        this.updatePortOverride();
        if (this.versionValueCombo.getText() != null) {
            newTeiidServerVersion = new TeiidServerVersion(this.versionValueCombo.getText());
        }
        TeiidServerFactory teiidServerFactory = new TeiidServerFactory();
        ArrayList<TeiidServerFactory.ServerOptions> serverOptions = new ArrayList<TeiidServerFactory.ServerOptions>();
        if (this.adminSSLCheckbox != null && this.adminSSLCheckbox.getSelection()) {
            serverOptions.add(TeiidServerFactory.ServerOptions.ADMIN_SECURE_CONNECTION);
        }
        if (this.jdbcSSLCheckbox.getSelection()) {
            serverOptions.add(TeiidServerFactory.ServerOptions.JDBC_SECURE_CONNECTION);
        }
        String finalJdbcPort = EMPTY_STRING;
        if (this.isSevenServer()) {
            finalJdbcPort = this.jdbcPort instanceof Text ? ((Text)this.jdbcPort).getText() : this.teiidServer.getTeiidJdbcInfo().getPort();
        } else {
            finalJdbcPort = this.getServerManager().getJdbcPort(this.teiidServer, true);
            if (StringUtilities.isEmpty((String)finalJdbcPort)) {
                finalJdbcPort = this.jdbcPort instanceof Text ? ((Text)this.jdbcPort).getText() : this.teiidServer.getTeiidJdbcInfo().getPort();
            }
        }
        ITeiidServer newTeiidServer = teiidServerFactory.createTeiidServer(newTeiidServerVersion, this.getServerManager(), this.teiidServer.getParent(), this.teiidServer.getTeiidAdminInfo().getPort(), this.adminUserNameText != null ? this.adminUserNameText.getText() : this.teiidServer.getTeiidAdminInfo().getUsername(), this.adminPasswdText != null ? this.adminPasswdText.getText() : this.teiidServer.getTeiidAdminInfo().getPassword(), finalJdbcPort, this.jdbcUserNameText.getText(), this.jdbcPasswdText.getText(), serverOptions.toArray(new TeiidServerFactory.ServerOptions[0]));
        this.teiidServer.update(newTeiidServer);
        this.dirty = false;
        this.firePropertyChange(257);
        this.getServerManager().notifyListeners(ExecutionConfigurationEvent.createServerRefreshEvent((ITeiidServer)this.teiidServer));
    }

    public void doSaveAs() {
    }

    private void setDirty() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void updatePortOverride() {
        if (this.isSevenServer()) {
            return;
        }
        String value = this.jdbcPortOverride.getText();
        int port = 0;
        if (!value.isEmpty()) {
            port = Integer.parseInt(value);
        }
        this.getServerManager().setJdbcPort(this.teiidServer, port, true);
    }

    private String validate() {
        if (this.isSevenServer()) {
            return null;
        }
        String msg = null;
        String value = this.jdbcPortOverride.getText();
        if (value == null) {
            msg = "PORT override undefined";
        } else if (!value.isEmpty()) {
            try {
                int port = Integer.parseInt(value);
                if (port < 1 || port > 65535) {
                    msg = DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.invalidPortNumberMessage", new Object[]{1, 65535});
                }
            }
            catch (NumberFormatException numberFormatException) {
                msg = DqpUiConstants.UTIL.getString("TeiidServerJDBCSection.invalidPortNumberMessage", new Object[]{1, 65535});
            }
        }
        return msg;
    }

    private class TeiidServerCommand
    extends ServerCommand {
        public TeiidServerCommand(IServerWorkingCopy server) {
            super(server, "TeiidServerCommand");
        }

        public void execute() {
        }

        public void undo() {
        }
    }
}

