/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection.properties;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.core.translators.TranslatorPropertyDefinition;
import org.teiid.designer.vdb.VdbPlugin;

public class TranslatorOverride {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(TranslatorOverride.class);
    private final Map<String, TranslatorOverrideProperty> properties;
    private final String type;

    public static String validateName(String proposedName) {
        if (StringUtilities.isEmpty((String)proposedName)) {
            return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "emptyTranslatorName", new Object[0]);
        }
        char[] cArray = proposedName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '-') {
                return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "invalidTranslatorName", (Object)proposedName);
            }
            ++n2;
        }
        if (!Character.isLetter(proposedName.charAt(0))) {
            return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "translatorNameMustStartWithLetter", new Object[0]);
        }
        return null;
    }

    public static String validateType(String proposedType) {
        if (StringUtilities.isEmpty((String)proposedType)) {
            return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "emptyTranslatorType", new Object[0]);
        }
        char[] cArray = proposedType.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetterOrDigit(c) && c != '-') {
                return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "invalidTranslatorType", (Object)proposedType);
            }
            ++n2;
        }
        if (!Character.isLetter(proposedType.charAt(0))) {
            return VdbPlugin.UTIL.getString(String.valueOf(PREFIX) + "translatorTypeMustStartWithLetter", new Object[0]);
        }
        return null;
    }

    public TranslatorOverride(String type, Properties properties) {
        assert (type != null);
        this.type = type;
        this.properties = new HashMap<String, TranslatorOverrideProperty>();
    }

    public void addProperty(TranslatorOverrideProperty newProperty) {
        assert (newProperty != null);
        this.properties.put(newProperty.getDefinition().getId(), newProperty);
    }

    public TranslatorOverrideProperty[] getProperties() {
        TranslatorOverrideProperty[] props = new TranslatorOverrideProperty[this.properties.size()];
        int i = 0;
        for (TranslatorOverrideProperty property : this.properties.values()) {
            props[i++] = property;
        }
        return props;
    }

    public List<String> getPropertyNames() {
        return Arrays.asList(this.properties.keySet().toArray(new String[this.properties.size()]));
    }

    public String getType() {
        return this.type;
    }

    public void markAsUserDefined(TranslatorOverrideProperty property) {
        property.getDefinition().markAsUserDefined(property.getOverriddenValue());
    }

    public boolean removeProperty(String propName) {
        return this.removeProperty(propName, true);
    }

    public boolean removeProperty(String propName, boolean firePropertyEvent) {
        assert (propName != null);
        assert (this.properties.containsKey(propName));
        this.properties.remove(propName);
        return false;
    }

    public void setOverrideValue(TranslatorPropertyDefinition propDefn, String newValue) {
        this.setOverrideValue(propDefn, newValue, true);
    }

    public void setOverrideValue(TranslatorPropertyDefinition propDefn, String newValue, boolean firePropertyEvent) {
        assert (propDefn != null);
        assert (this.properties.containsKey(propDefn.getId()));
        TranslatorOverrideProperty prop = this.properties.get(propDefn.getId());
        String oldValue = prop.getOverriddenValue();
        if (StringUtilities.equals((String)newValue, (String)oldValue)) {
            return;
        }
        prop.setValue(newValue);
    }

    public void updatePropertyDefinition(String propertyName, PropertyDefinition newServerPropDefn) {
        this.updatePropertyDefinition(propertyName, newServerPropDefn, true);
    }

    public void updatePropertyDefinition(String propertyName, PropertyDefinition newServerPropDefn, boolean firePropertyEvent) {
        assert (!StringUtilities.isEmpty((String)propertyName));
        assert (newServerPropDefn != null);
        TranslatorOverrideProperty prop = this.properties.get(propertyName);
        if (prop != null) {
            prop.setDefinition(newServerPropDefn);
        }
    }
}

