/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.Messages;
import org.teiid.designer.runtime.ui.wizards.vdbs.GenerateArchiveVdbWizard;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.ui.VdbUiPlugin;

public class GenerateArchiveVdbAction
extends SortableSelectionAction
implements DqpUiConstants {
    private static final String label = DqpUiConstants.UTIL.getString("label", new Object[0]);

    public GenerateArchiveVdbAction() {
        super(label, -1);
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/standard-vdb.png"));
    }

    public boolean isValidSelection(ISelection selection) {
        return this.vdbSelected(selection);
    }

    public void run() {
        IWorkbenchWindow iww = VdbUiPlugin.singleton.getCurrentWorkbenchWindow();
        Object obj = SelectionUtilities.getSelectedObject((ISelection)this.getSelection());
        if (obj instanceof IFile) {
            IFile vdbXmlFile = (IFile)obj;
            try {
                GenerateArchiveVdbWizard wizard = new GenerateArchiveVdbWizard(vdbXmlFile);
                WizardDialog wd = new WizardDialog(this.getShell(), (IWizard)wizard);
                wd.open();
                return;
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)iww.getShell(), (String)Messages.GenerateArchiveVdbAction_exceptionTitle, (String)ex.getLocalizedMessage());
            }
        }
        MessageDialog.openInformation((Shell)iww.getShell(), (String)Messages.GenerateArchiveVdbAction_nothingExportedTitle, (String)Messages.GenerateArchiveVdbAction_nothingExportedMessage);
    }

    public boolean isApplicable(ISelection selection) {
        return this.vdbSelected(selection);
    }

    private boolean vdbSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? VdbUtil.isDynamicVdb((IFile)nextObj) : false;
            }
        }
        return result;
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

