/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.jmx.camel.navigator.CamelContextNode;
import org.fusesource.ide.jmx.camel.navigator.ProcessorNodeSupport;
import org.fusesource.ide.jmx.camel.navigator.RouteNode;
import org.jboss.tools.jmx.core.tree.Node;

public class ProcessorNode
extends ProcessorNodeSupport {
    private static final boolean useCaching = true;
    private final RouteNode routeNode;
    private final AbstractNode node;

    public ProcessorNode(RouteNode routeNode, Node parent, AbstractNode node) {
        super(parent, routeNode.getRoute());
        this.routeNode = routeNode;
        this.node = node;
    }

    public String toString() {
        return this.node.getDisplayText();
    }

    public AbstractNode getAbstractNode() {
        return this.node;
    }

    @Override
    public CamelContextNode getCamelContextNode() {
        return this.routeNode.getCamelContextNode();
    }

    protected void loadChildren() {
        List children = this.node.getOutputs();
        for (AbstractNode node : children) {
            this.addChild((Node)new ProcessorNode(this.routeNode, (Node)this, node));
        }
    }

    protected Object createPropertyBean() {
        String nodeId = this.getNodeId();
        if (nodeId != null) {
            return this.getCamelContextNode().createProcessorBeanView(this.getRouteId(), nodeId);
        }
        return super.createPropertyBean();
    }

    public void provideContextMenu(IMenuManager menu) {
        this.routeNode.provideContextMenu(menu);
    }

    @Override
    public String getNodeId() {
        return this.node.getId();
    }

    public Image getImage() {
        return this.node.getSmallImage();
    }
}

