/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.ui.ConnectionUIConstants;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class ConnectionTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME = ConnectionUIConstants.TYPENAME;
    private static final int TYPEID = ConnectionTransfer.registerType((String)TYPENAME);
    private static ConnectionTransfer instance = new ConnectionTransfer();

    private ConnectionTransfer() {
    }

    public static ConnectionTransfer getInstance() {
        return instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof Object[])) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            Object[] objects = (Object[])object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream writeOut = new DataOutputStream(out);
                int i = 0;
                while (i < objects.length) {
                    byte[] id;
                    if (objects[i] instanceof Connection) {
                        id = ((Connection)objects[i]).getConnectionParameter().getId().getBytes();
                        writeOut.writeInt(id.length);
                        writeOut.write(id);
                    } else if (objects[i] instanceof ConnectionFolder) {
                        id = ((ConnectionFolder)objects[i]).getId().getBytes();
                        writeOut.writeInt(id.length);
                        writeOut.write(id);
                    }
                    ++i;
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (IOException iOException) {}
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            ArrayList<Object> objectList = new ArrayList<Object>();
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                DataInputStream readIn = new DataInputStream(in);
                do {
                    if (readIn.available() <= 1) continue;
                    int size = readIn.readInt();
                    byte[] id = new byte[size];
                    readIn.read(id);
                    Connection connection = ConnectionCorePlugin.getDefault().getConnectionManager().getConnectionById(new String(id));
                    if (connection != null) {
                        objectList.add(connection);
                        continue;
                    }
                    ConnectionFolder folder = ConnectionCorePlugin.getDefault().getConnectionFolderManager().getConnectionFolderById(new String(id));
                    if (folder == null) continue;
                    objectList.add(folder);
                } while (readIn.available() > 1);
                readIn.close();
            }
            catch (IOException iOException) {
                return null;
            }
            return objectList.toArray();
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }
}

