/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui;

import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.ConnectionUIConstants;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class RunnableContextRunner {
    public static IStatus execute(final StudioConnectionRunnableWithProgress runnable, IRunnableContext runnableContext, boolean handleError) {
        if (runnableContext == null) {
            runnableContext = PlatformUI.getWorkbench().getProgressService();
        }
        final StudioProgressMonitor[] spm = new StudioProgressMonitor[1];
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException {
                block17: {
                    spm[0] = new StudioProgressMonitor(monitor);
                    Connection[] connections = runnable.getConnections();
                    if (connections != null) {
                        Connection[] connectionArray = connections;
                        int n = connections.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Connection connection = connectionArray[n2];
                            if (connection != null && !connection.getConnectionWrapper().isConnected()) {
                                spm[0].setTaskName(Messages.bind((String)Messages.jobs__open_connections_task, (Object[])new String[]{connection.getName()}));
                                spm[0].worked(1);
                                connection.getConnectionWrapper().connect(spm[0]);
                                if (connection.getConnectionWrapper().isConnected()) {
                                    connection.getConnectionWrapper().bind(spm[0]);
                                }
                                if (connection.getConnectionWrapper().isConnected()) {
                                    for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                                        listener.connectionOpened(connection, spm[0]);
                                    }
                                    ConnectionEventRegistry.fireConnectionOpened((Connection)connection, (Object)this);
                                }
                            }
                            ++n2;
                        }
                    }
                    if (!spm[0].errorsReported()) {
                        try {
                            try {
                                if (runnable instanceof StudioConnectionBulkRunnableWithProgress) {
                                    StudioConnectionBulkRunnableWithProgress bulkRunnable = (StudioConnectionBulkRunnableWithProgress)runnable;
                                    ConnectionEventRegistry.suspendEventFiringInCurrentThread();
                                    try {
                                        bulkRunnable.run(spm[0]);
                                    }
                                    finally {
                                        ConnectionEventRegistry.resumeEventFiringInCurrentThread();
                                    }
                                    bulkRunnable.runNotification(spm[0]);
                                    break block17;
                                }
                                runnable.run(spm[0]);
                            }
                            catch (Exception e) {
                                spm[0].reportError(e);
                                spm[0].done();
                                monitor.done();
                            }
                        }
                        finally {
                            spm[0].done();
                            monitor.done();
                        }
                    }
                }
            }
        };
        try {
            runnableContext.run(true, true, runnableWithProgress);
        }
        catch (Exception ex) {
            ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, ConnectionUIConstants.PLUGIN_ID, 4, ex.getMessage() != null ? ex.getMessage() : "", (Throwable)ex));
        }
        IStatus status = spm[0].getErrorStatus(runnable.getErrorMessage());
        if (handleError && !spm[0].isCanceled() && !status.isOK()) {
            ConnectionUIPlugin.getDefault().getExceptionHandler().handleException(status);
        }
        return status;
    }
}

