/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IReferralHandler;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateAdapter;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.dialogs.SelectReferralConnectionDialog;
import org.eclipse.ui.PlatformUI;

public class ConnectionUIReferralHandler
extends ConnectionUpdateAdapter
implements IReferralHandler {
    private Map<String, Connection> referralUrlToReferralConnectionCache = new HashMap<String, Connection>();

    public ConnectionUIReferralHandler() {
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this, (EventRunner)ConnectionCorePlugin.getDefault().getEventRunner());
    }

    public void connectionClosed(Connection connection) {
        this.referralUrlToReferralConnectionCache.clear();
    }

    public Connection getReferralConnection(final List<String> referralUrls) {
        final Connection[] referralConnections = new Connection[1];
        try {
            String normalizedUrl;
            for (String url : referralUrls) {
                normalizedUrl = Utils.getSimpleNormalizedUrl((LdapUrl)new LdapUrl(url));
                if (!this.referralUrlToReferralConnectionCache.containsKey(normalizedUrl)) continue;
                Connection referralConnection = this.referralUrlToReferralConnectionCache.get(normalizedUrl);
                Connection[] connections = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections();
                int i = 0;
                while (i < connections.length) {
                    Connection connection = connections[i];
                    if (referralConnection == connection) {
                        return referralConnection;
                    }
                    ++i;
                }
                this.referralUrlToReferralConnectionCache.remove(normalizedUrl);
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SelectReferralConnectionDialog dialog = new SelectReferralConnectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), referralUrls);
                    if (dialog.open() == 0) {
                        Connection connection;
                        referralConnections[0] = connection = dialog.getReferralConnection();
                    }
                }
            });
            if (referralConnections[0] != null) {
                for (String url : referralUrls) {
                    normalizedUrl = Utils.getSimpleNormalizedUrl((LdapUrl)new LdapUrl(url));
                    this.referralUrlToReferralConnectionCache.put(normalizedUrl, referralConnections[0]);
                }
            }
        }
        catch (LdapURLEncodingException ldapURLEncodingException) {}
        return referralConnections[0];
    }
}

