/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.UTFDataFormatException;
import org.teiid.designer.core.index.CodeByteStream;
import org.teiid.designer.core.index.IndexBlock;
import org.teiid.designer.core.index.Util;
import org.teiid.designer.core.index.WordEntry;

public class GammaCompressedIndexBlock
extends IndexBlock {
    CodeByteStream writeCodeStream = new CodeByteStream();
    CodeByteStream readCodeStream = new CodeByteStream(this.field.buffer());
    char[] prevWord = null;
    int offset = 0;

    public GammaCompressedIndexBlock(int blockSize) {
        super(blockSize);
    }

    @Override
    public boolean addEntry(WordEntry entry) {
        this.writeCodeStream.reset();
        this.encodeEntry(entry, this.prevWord, this.writeCodeStream);
        if (this.offset + this.writeCodeStream.byteLength() > this.blockSize - 2) {
            return false;
        }
        byte[] bytes = this.writeCodeStream.toByteArray();
        this.field.put(this.offset, bytes);
        this.offset += bytes.length;
        this.prevWord = entry.getWord();
        return true;
    }

    protected void encodeEntry(WordEntry entry, char[] prevWord, CodeByteStream codeStream) {
        char[] word = entry.getWord();
        int prefixLen = prevWord == null ? 0 : Math.min(Util.prefixLength(prevWord, word), 255);
        codeStream.writeByte(prefixLen);
        codeStream.writeUTF(word, prefixLen, word.length);
        int n = entry.getNumRefs();
        codeStream.writeGamma(n);
        int prevRef = 0;
        int i = 0;
        while (i < n) {
            int ref = entry.getRef(i);
            if (ref <= prevRef) {
                throw new IllegalArgumentException();
            }
            codeStream.writeGamma(ref - prevRef);
            prevRef = ref;
            ++i;
        }
    }

    @Override
    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.offset = 0;
            this.prevWord = null;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.offset == 0;
    }

    @Override
    public boolean nextEntry(WordEntry entry) {
        char[] word;
        block6: {
            this.readCodeStream.reset(this.field.buffer(), this.offset);
            int prefixLength = this.readCodeStream.readByte();
            word = this.readCodeStream.readUTF();
            if (this.prevWord != null && prefixLength > 0) {
                char[] temp = new char[prefixLength + word.length];
                System.arraycopy(this.prevWord, 0, temp, 0, Math.min(prefixLength, this.prevWord.length));
                System.arraycopy(word, 0, temp, Math.min(prefixLength, this.prevWord.length), word.length);
                word = temp;
            }
            if (word.length != 0) break block6;
            return false;
        }
        try {
            entry.reset(word);
            int n = this.readCodeStream.readGamma();
            int prevRef = 0;
            int i = 0;
            while (i < n) {
                int ref = prevRef + this.readCodeStream.readGamma();
                if (ref < prevRef) {
                    throw new InternalError();
                }
                entry.addRef(ref);
                prevRef = ref;
                ++i;
            }
            this.offset = this.readCodeStream.byteLength();
            this.prevWord = word;
            return true;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return false;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.offset = 0;
        this.prevWord = null;
    }
}

