/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import org.teiid.designer.common.xml.JdomHelper;
import org.teiid.designer.common.xml.XMLReaderWriter;

public class XMLReaderWriterImpl
implements XMLReaderWriter {
    public static final int DEFAULT_INDENT_SIZE = 4;
    public static final boolean DEFAULT_USE_NEW_LINES = true;
    private int indent = 4;
    private boolean newLines = true;

    @Override
    public void writeDocument(Document doc, OutputStream stream) throws IOException {
        StringBuffer indentBuffer = new StringBuffer();
        int i = 0;
        while (i < this.indent) {
            indentBuffer.append(" ");
            ++i;
        }
        XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat(indentBuffer.toString(), this.newLines));
        outputter.output(doc, stream);
        stream.flush();
        stream.close();
    }

    @Override
    public Document readDocument(InputStream stream) throws JDOMException, IOException {
        return JdomHelper.buildDocument(stream);
    }

    public void setIndentSize(int indent) {
        this.indent = indent;
    }

    public void setUseNewLines(boolean newLines) {
        this.newLines = newLines;
    }
}

