/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.xmi;

import org.teiid.designer.common.xmi.ModelImportInfo;
import org.teiid.designer.common.xmi.XMIHeader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TerminatingXMIHeaderContentHandler
extends DefaultHandler {
    public static final String HEADER_FOUND_EXCEPTION_MESSAGE = "HeaderFoundException";
    public static final String XMI_NOT_FOUND_EXCEPTION_MESSAGE = "XMINotFoundException";
    private static final String XMI_TAG_NAME = "XMI";
    private static final String VIRTUAL_DATABASE_TAG_NAME = "VirtualDatabase";
    private static final String MODEL_ANNOTATION_TAG_NAME = "ModelAnnotation";
    private static final String XMI_VERSION_0020_ATTRIBUTE_NAME = "xmi:version";
    private static final String XMI_VERSION_0011_ATTRIBUTE_NAME = "xmi.version";
    private static final String PRODUCER_NAME_ATTRIBUTE_NAME = "ProducerName";
    private static final String PRODUCER_VERSION_ATTRIBUTE_NAME = "ProducerVersion";
    private static final String UUID_ATTRIBUTE_NAME = "uuid";
    private static final String DESCRIPTION_ATTRIBUTE_NAME = "description";
    private static final String PRIMARY_URI_ATTRIBUTE_NAME = "primaryMetamodelUri";
    private static final String MODEL_TYPE_ATTRIBUTE_NAME = "modelType";
    private static final String VISIBLE_ATTRIBUTE_NAME = "visible";
    private static final String MODEL_NAMESPACE_URI = "namespaceURI";
    private static final String MODEL_IMPORT_TAG_NAME = "modelImports";
    private static final String MODELS_TAG_NAME = "models";
    private static final String IMPORT_PATH_ATTRIBUTE_NAME = "path";
    private static final String IMPORT_LOC_ATTRIBUTE_NAME = "modelLocation";
    private static final String IMPORT_NAME_ATTRIBUTE_NAME = "name";
    private static final String IMPORT_TYPE_ATTRIBUTE_NAME = "modelType";
    private static final String IMPORT_UUID_ATTRIBUTE_NAME = "uuid";
    private static final String IMPORT_PRIMARY_METAMODEL_URI_ATTRIBUTE_NAME = "primaryMetamodelUri";
    private boolean foundXmiStartElement = false;
    private boolean foundAnnotationStartElement = false;
    private boolean foundAnnotationEndElement = false;
    private boolean foundVdbStartElement = false;
    private boolean foundVdbEndElement = false;
    private XMIHeader header;

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.getXmiHeader().addNamespaceURI(uri);
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equalsIgnoreCase(XMI_TAG_NAME)) {
            this.processAttributes(atts);
            this.foundXmiStartElement = true;
        } else if (localName.equalsIgnoreCase(MODEL_ANNOTATION_TAG_NAME)) {
            this.processAttributes(atts);
            this.foundAnnotationStartElement = true;
        } else if (localName.equalsIgnoreCase(VIRTUAL_DATABASE_TAG_NAME)) {
            this.processVdbAttributes(atts);
            this.foundAnnotationStartElement = true;
            this.foundVdbStartElement = true;
        } else if (localName.equalsIgnoreCase(MODELS_TAG_NAME) && this.foundVdbStartElement) {
            this.processImportAttributes(atts);
        } else if (localName.equalsIgnoreCase(MODEL_IMPORT_TAG_NAME)) {
            this.processImportAttributes(atts);
        }
        this.checkForCompletion();
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.checkForCompletion();
        if (localName.equals(MODEL_ANNOTATION_TAG_NAME)) {
            this.foundAnnotationEndElement = true;
        } else if (localName.equals(VIRTUAL_DATABASE_TAG_NAME)) {
            this.foundAnnotationEndElement = true;
            this.foundVdbEndElement = true;
        }
        super.endElement(namespaceURI, localName, qName);
    }

    public XMIHeader getXmiHeader() {
        if (this.header == null) {
            this.header = new XMIHeader();
        }
        return this.header;
    }

    private void checkForCompletion() throws SAXException {
        if (!(this.foundXmiStartElement || this.foundAnnotationStartElement || this.foundVdbStartElement)) {
            throw new SAXException(XMI_NOT_FOUND_EXCEPTION_MESSAGE);
        }
        if (this.foundAnnotationStartElement && this.foundAnnotationEndElement && !this.foundVdbStartElement) {
            throw new SAXException(HEADER_FOUND_EXCEPTION_MESSAGE);
        }
        if (this.foundVdbStartElement && this.foundVdbEndElement) {
            throw new SAXException(HEADER_FOUND_EXCEPTION_MESSAGE);
        }
    }

    private void processAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            String qname = atts.getQName(i);
            if (name.equalsIgnoreCase("uuid") && !this.foundVdbStartElement) {
                this.getXmiHeader().setUUID(value);
            } else if (name.equalsIgnoreCase(DESCRIPTION_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setDescription(value);
            } else if (name.equalsIgnoreCase(PRODUCER_NAME_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setProducerName(value);
            } else if (name.equalsIgnoreCase(PRODUCER_VERSION_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setProducerVersion(value);
            } else if (name.equalsIgnoreCase("primaryMetamodelUri")) {
                this.getXmiHeader().setPrimaryMetamodelURI(value);
            } else if (name.equalsIgnoreCase("modelType")) {
                this.getXmiHeader().setModelType(value);
            } else if (name.equalsIgnoreCase(MODEL_NAMESPACE_URI)) {
                this.getXmiHeader().setModelNamespaceUri(value);
            } else if (name.equalsIgnoreCase(VISIBLE_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setVisible(value);
            } else if (qname.equalsIgnoreCase(XMI_VERSION_0020_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setXmiVersion(value);
            } else if (qname.equalsIgnoreCase(XMI_VERSION_0011_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setXmiVersion(value);
            }
            ++i;
        }
    }

    private void processVdbAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            String qname = atts.getQName(i);
            if (name.equalsIgnoreCase("uuid")) {
                this.getXmiHeader().setUUID(value);
            } else if (qname.equalsIgnoreCase(XMI_VERSION_0020_ATTRIBUTE_NAME)) {
                this.getXmiHeader().setXmiVersion(value);
            }
            ++i;
        }
    }

    private void processImportAttributes(Attributes atts) {
        ModelImportInfo info = new ModelImportInfo();
        int i = 0;
        while (i < atts.getLength()) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            if (name.equalsIgnoreCase(IMPORT_PATH_ATTRIBUTE_NAME)) {
                info.setPath(value);
            } else if (name.equalsIgnoreCase(IMPORT_LOC_ATTRIBUTE_NAME)) {
                info.setLocation(value);
            } else if (name.equalsIgnoreCase("uuid")) {
                info.setUUID(value);
            } else if (name.equalsIgnoreCase(IMPORT_NAME_ATTRIBUTE_NAME)) {
                info.setName(value);
            } else if (name.equalsIgnoreCase("modelType")) {
                info.setModelType(value);
            } else if (name.equalsIgnoreCase("primaryMetamodelUri")) {
                info.setPrimaryMetamodelURI(value);
            }
            ++i;
        }
        this.getXmiHeader().addModelImportInfo(info);
    }
}

