/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.teiid.datatools.connectivity.model.Parameter;
import org.teiid.designer.datatools.profiles.ws.ConnectionProfileWizard;
import org.teiid.designer.datatools.profiles.ws.HeaderPropertiesPanel;
import org.teiid.designer.datatools.profiles.ws.ParameterPanel;
import org.teiid.designer.datatools.profiles.ws.WSWizardUtils;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.dialogs.ScrolledConnectionProfileDetailsPage;
import org.teiid.designer.ui.common.ICredentialsCommon;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.CredentialsComposite;

public class WSProfileDetailsWizardPage
extends ScrolledConnectionProfileDetailsPage
implements DatatoolsUiConstants {
    private Composite scrolled;
    private Label profileLabel;
    private CLabel profileText;
    private Label descriptionLabel;
    private Text descriptionText;
    private Label urlPreviewLabel;
    Text urlPreviewText;
    private Label urlLabel;
    private Text urlText;
    private Label responseTypeLabel;
    private CredentialsComposite credentialsComposite;
    private Combo responseTypeCombo;
    private Map<String, Parameter> parameterMap = new LinkedHashMap<String, Parameter>();
    private TabItem parametersTab;
    private TabItem headerPropertiesTab;
    ParameterPanel parameterPanel;
    HeaderPropertiesPanel headerPanel;
    private Properties profileProperties;

    public WSProfileDetailsWizardPage(String pageName) {
        super(pageName, UTIL.getString("WSProfileDetailsWizardPage.Name", new Object[0]), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.teiid.designer.datatools.ui", (String)"icons/full/obj16/web-service-cp.png"));
    }

    public void createCustomControl(Composite parent) {
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, (String)UTIL.getString("Common.Properties.Label", new Object[0]));
        this.scrolled = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        this.scrolled.setLayout((Layout)gridLayout);
        this.profileLabel = new Label(this.scrolled, 0);
        this.profileLabel.setText(UTIL.getString("Common.Profile.Label", new Object[0]));
        this.profileText = WidgetFactory.createLabel((Composite)this.scrolled, (int)2052);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.profileText.setLayoutData((Object)gd);
        this.profileText.setText(((ConnectionProfileWizard)this.getWizard()).getProfileName());
        this.descriptionLabel = new Label(this.scrolled, 0);
        this.descriptionLabel.setText(UTIL.getString("Common.Description.Label", new Object[0]));
        gd = new GridData();
        this.descriptionLabel.setLayoutData((Object)gd);
        this.descriptionText = WidgetFactory.createTextBox((Composite)this.scrolled, (int)2060, (int)4);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.descriptionText.setLayoutData((Object)gd);
        String description = ((ConnectionProfileWizard)this.getWizard()).getProfileDescription();
        this.descriptionText.setText(description);
        this.descriptionText.setBackground(Display.getCurrent().getSystemColor(19));
        this.urlLabel = new Label(this.scrolled, 0);
        this.urlLabel.setText(UTIL.getString("Common.URL.Label", new Object[0]));
        this.urlLabel.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        this.urlLabel.setLayoutData((Object)gd);
        this.urlText = new Text(this.scrolled, 2052);
        this.urlText.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData(768);
        gd.widthHint = 500;
        this.urlText.setLayoutData((Object)gd);
        this.responseTypeLabel = new Label(this.scrolled, 0);
        this.responseTypeLabel.setText(UTIL.getString("Common.ResponseType.Label", new Object[0]));
        this.responseTypeLabel.setToolTipText(UTIL.getString("Common.ResponseType.ToolTip", new Object[0]));
        gd = new GridData();
        this.responseTypeLabel.setLayoutData((Object)gd);
        this.responseTypeCombo = WidgetFactory.createCombo((Composite)this.scrolled, (int)2060);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.responseTypeCombo.setLayoutData((Object)gd);
        this.responseTypeCombo.setItems(new String[]{"XML", "JSON"});
        this.responseTypeCombo.select(0);
        this.responseTypeCombo.setText("XML");
        this.responseTypeCombo.setToolTipText(UTIL.getString("Common.ResponseType.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)this.responseTypeCombo);
        this.responseTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSProfileDetailsWizardPage.this.handleResponseTypeChanged(((Combo)e.widget).getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.responseTypeCombo.setVisibleItemCount(2);
        this.credentialsComposite = new CredentialsComposite(this.scrolled, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.credentialsComposite.setLayoutData((Object)gd);
        this.profileProperties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        this.loadParameters(this.profileProperties);
        this.urlPreviewLabel = new Label(this.scrolled, 0);
        this.urlPreviewLabel.setText(UTIL.getString("WSProfileDetailsWizardPage.urlPreviewLabel", new Object[0]));
        gd = new GridData();
        this.urlPreviewLabel.setLayoutData((Object)gd);
        this.urlPreviewText = new Text(this.scrolled, 2634);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 40;
        gd.horizontalSpan = 3;
        this.urlPreviewText.setLayoutData((Object)gd);
        this.urlPreviewText.setBackground(Display.getCurrent().getSystemColor(19));
        TabFolder tabFolder = new TabFolder(this.scrolled, 2176);
        tabFolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Composite parameterPanel = WidgetFactory.createPanel((Composite)tabFolder);
        this.parametersTab = new TabItem(tabFolder, 4);
        this.parametersTab.setControl((Control)parameterPanel);
        this.parametersTab.setText(UTIL.getString("ParametersPanel_groupTitle", new Object[0]));
        this.parameterPanel = new ParameterPanel(this, parameterPanel, this.parameterMap, 6);
        this.urlPreviewText.setText(this.updateUrlPreview().toString());
        Composite headerPropertiesPanel = WidgetFactory.createPanel((Composite)tabFolder);
        this.headerPropertiesTab = new TabItem(tabFolder, 4);
        this.headerPropertiesTab.setControl((Control)headerPropertiesPanel);
        this.headerPropertiesTab.setText(UTIL.getString("HeaderPropertiesPanel_groupTitle", new Object[0]));
        this.headerPanel = new HeaderPropertiesPanel(this, headerPropertiesPanel, this.parameterMap, 6);
        this.setPingButtonVisible(true);
        this.setPingButtonEnabled(false);
        this.setAutoConnectOnFinishDefault(false);
        this.setCreateAutoConnectControls(false);
        this.setShowAutoConnect(false);
        this.setShowAutoConnectOnFinish(false);
        this.setPageComplete(false);
        this.addListeners();
    }

    void handleResponseTypeChanged(String type) {
        this.setProperty("responseType", type);
        this.updateState();
    }

    public Map<String, Parameter> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, Parameter> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public Properties getProfileProperties() {
        return this.profileProperties;
    }

    public void setProfileProperties(Properties profileProperties) {
        this.profileProperties = profileProperties;
    }

    private void loadParameters(Properties props) {
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            if (!keyStr.startsWith("rest_param:") && !keyStr.startsWith("header_param:")) continue;
            Parameter newParam = new Parameter(keyStr, props.getProperty((String)key));
            this.parameterMap.put(newParam.getName(), newParam);
        }
    }

    StringBuilder updateUrlPreview() {
        StringBuilder previewUrl = new StringBuilder();
        String urlText = this.urlText.getText();
        if (urlText == null || urlText.trim().equals("")) {
            urlText = "{base URL}";
        }
        String parameters = null;
        try {
            parameters = this.buildParameterString();
        }
        catch (UnsupportedEncodingException ex) {
            this.setErrorMessage(String.valueOf(UTIL.getString("Common.URL.Invalid.Message", new Object[0])) + ex.getMessage());
        }
        previewUrl.append(urlText).append(parameters);
        return previewUrl;
    }

    private String buildParameterString() throws UnsupportedEncodingException {
        StringBuilder parameterString = new StringBuilder();
        if (this.parameterMap == null) {
            return parameterString.toString();
        }
        Map<String, Parameter> parameterMap = this.parameterMap;
        for (String key : parameterMap.keySet()) {
            Parameter value = parameterMap.get(key);
            if (value.getType().equals((Object)"header_param:")) continue;
            if (value.getType().equals((Object)Parameter.Type.URI)) {
                parameterString.append("/").append(value.getDefaultValue());
            }
            if (value.getType() != Parameter.Type.Query) continue;
            if (parameterString.length() == 0 || !parameterString.toString().contains("?")) {
                parameterString.append("?");
            } else {
                parameterString.append("&");
            }
            parameterString.append(this.encodeString(value.getName())).append("=").append(this.encodeString(value.getDefaultValue()));
        }
        return parameterString.toString();
    }

    private String encodeString(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, Charset.defaultCharset().displayName());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        String description = ((ConnectionProfileWizard)this.getWizard()).getProfileDescription();
        this.descriptionText.setText(description);
        this.profileText.setText(((ConnectionProfileWizard)this.getWizard()).getProfileName());
    }

    private void addListeners() {
        this.urlText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String urlStr = WSProfileDetailsWizardPage.this.urlText.getText();
                if (urlStr != null) {
                    urlStr = urlStr.trim();
                }
                WSProfileDetailsWizardPage.this.setProperty("EndPoint", urlStr);
            }
        });
        this.credentialsComposite.addSecurityOptionListener(24, new Listener(){

            public void handleEvent(Event event) {
                WSProfileDetailsWizardPage.this.setProperty("SecurityType", WSProfileDetailsWizardPage.this.credentialsComposite.getSecurityOption().name());
            }
        });
        this.credentialsComposite.addSecurityOptionListener(2, new Listener(){

            public void handleEvent(Event event) {
                WSProfileDetailsWizardPage.this.setProperty("SecurityType", WSProfileDetailsWizardPage.this.credentialsComposite.getSecurityOption().name());
            }
        });
        this.credentialsComposite.addUserNameListener(24, new Listener(){

            public void handleEvent(Event event) {
                WSProfileDetailsWizardPage.this.setProperty("AuthUserName", WSProfileDetailsWizardPage.this.credentialsComposite.getUserName());
            }
        });
        this.credentialsComposite.addPasswordListener(24, new Listener(){

            public void handleEvent(Event event) {
                WSProfileDetailsWizardPage.this.setProperty("AuthPassword", WSProfileDetailsWizardPage.this.credentialsComposite.getPassword());
            }
        });
    }

    private void setProperty(String propertyId, String value) {
        if (this.profileProperties == null) {
            this.profileProperties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        }
        this.profileProperties.setProperty(propertyId, value);
        if (propertyId.equals("SecurityType") && value.equals(ICredentialsCommon.SecurityType.None.name())) {
            this.profileProperties.remove("AuthUserName");
            this.profileProperties.remove("AuthPassword");
        }
        this.updateState();
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateState();
    }

    void updateState() {
        this.setPingButtonVisible(true);
        this.setPingButtonEnabled(false);
        this.profileText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileName());
        this.descriptionText.setText(((NewConnectionProfileWizard)this.getWizard()).getProfileDescription());
        this.urlPreviewText.setText(this.updateUrlPreview().toString());
        if (this.profileProperties == null) {
            this.profileProperties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        }
        if (this.profileProperties != null && this.parameterMap != null) {
            for (String key : this.parameterMap.keySet()) {
                Parameter para = this.parameterMap.get(key);
                this.profileProperties.put(para.getPropertyKey(), para.getPropertyValue());
            }
        }
        if (this.profileProperties != null) {
            this.profileProperties.put("responseType", this.responseTypeCombo.getText());
        }
        if (this.profileProperties.get("EndPoint") == null || this.profileProperties.get("EndPoint").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.URL.Error.Message", new Object[0]));
            return;
        }
        this.setErrorMessage(null);
        try {
            new URL(this.profileProperties.get("EndPoint").toString());
        }
        catch (MalformedURLException e) {
            this.setErrorMessage(String.valueOf(UTIL.getString("Common.URL.Invalid.Message", new Object[0])) + e.getMessage());
            return;
        }
        if (this.profileProperties.get("SecurityType") != null && !ICredentialsCommon.SecurityType.None.name().equals(this.profileProperties.get("SecurityType"))) {
            if (this.profileProperties.get("AuthUserName") == null || this.profileProperties.get("AuthUserName").toString().isEmpty()) {
                this.setErrorMessage(UTIL.getString("Common.Username.Error.Message", new Object[0]));
                this.setPageComplete(false);
                return;
            }
            this.setErrorMessage(null);
            if (this.profileProperties.get("AuthPassword") == null || this.profileProperties.get("AuthPassword").toString().isEmpty()) {
                this.setErrorMessage(UTIL.getString("Common.Password.Error.Message", new Object[0]));
                this.setPageComplete(false);
                return;
            }
        }
        this.setPingButtonEnabled(true);
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.setMessage(UTIL.getString("Click.Next.or.Finish", new Object[0]));
    }

    public boolean canFlipToNextPage() {
        return this.internalComplete(super.canFlipToNextPage());
    }

    private boolean internalComplete(boolean complete) {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        if (complete && (properties.get("EndPoint") == null || properties.get("EndPoint").toString().isEmpty())) {
            complete = false;
        }
        if (complete && properties.get("SecurityType") != null && !ICredentialsCommon.SecurityType.None.name().equals(properties.get("SecurityType").toString())) {
            if (complete && (properties.get("AuthUserName") == null || properties.get("AuthUserName").toString().isEmpty())) {
                complete = false;
            }
            if (complete && (properties.get("AuthPassword") == null || properties.get("AuthPassword").toString().isEmpty())) {
                complete = false;
            }
        }
        return complete;
    }

    public List getSummaryData() {
        List result = super.getSummaryData();
        result.add(new String[]{UTIL.getString("Common.URL.Label", new Object[0]), this.urlText.getText()});
        result.add(new String[]{UTIL.getString("Common.Username.Label", new Object[0]), this.credentialsComposite.getUserName()});
        result.add(new String[]{UTIL.getString("Common.Security.Type.Label", new Object[0]), this.credentialsComposite.getSecurityOption().name()});
        return result;
    }

    public void testConnection() {
        super.testConnection();
    }

    protected Runnable createTestConnectionRunnable(IConnectionProfile profile) {
        final URLPingJob pingJob = new URLPingJob(this.getShell(), profile);
        pingJob.schedule();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    pingJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
    }

    public class URLPingJob
    extends Job {
        private IConnectionProfile icp;
        private Shell shell;

        public URLPingJob(Shell shell, IConnectionProfile profile) {
            super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.job"));
            this.setSystem(false);
            this.setUser(true);
            this.shell = shell;
            this.icp = profile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.title"), -1);
            Exception exception = this.testXmlUrlConnection(this.icp);
            monitor.done();
            new XmlUrlPingUIJob(this.shell, exception).schedule();
            return Status.OK_STATUS;
        }

        public Exception testXmlUrlConnection(IConnectionProfile icp) {
            return WSWizardUtils.testURLConnection(icp, "EndPoint");
        }

        public Throwable getTestConnectionException(IConnection conn) {
            return conn != null ? conn.getConnectException() : new RuntimeException(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"));
        }

        public class XmlUrlPingUIJob
        extends UIJob {
            private Shell shell;
            private Throwable exception;

            public XmlUrlPingUIJob(Shell shell, Throwable exception) {
                super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.uijob"));
                this.setSystem(false);
                this.exception = exception;
                this.shell = shell;
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                this.showTestConnectionMessage(this.shell, this.exception);
                return Status.OK_STATUS;
            }

            public void showTestConnectionMessage(Shell shell, Throwable exception) {
                if (exception == null) {
                    MessageDialog.openInformation((Shell)shell, (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.success"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.success"));
                    WSProfileDetailsWizardPage.this.updateState();
                } else {
                    ExceptionHandler.showException((Shell)shell, (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"), (Throwable)exception);
                    WSProfileDetailsWizardPage.this.setErrorMessage(exception.getMessage());
                    WSProfileDetailsWizardPage.this.updateState();
                }
            }
        }
    }
}

