/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ldap.widget;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.datatools.profiles.ldap.LDAPConnectionFactory;
import org.teiid.designer.datatools.profiles.ldap.LDAPUrl;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;

public class LdapSettingsWidget
extends Composite
implements Listener,
IChangeNotifier,
StringConstants {
    private Composite scrolled;
    private Label hostLabel;
    private Text hostText;
    private Label portLabel;
    private Spinner portSpinner;
    private Label encMethodLabel;
    private Combo encMethodCombo;
    private String[] encMethods = new String[]{DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Encryption.NoEncryption", new Object[0]), DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Encryption.UseSSLEncryption", new Object[0])};
    private Label urlLabel;
    private Text urlText;
    private Label networkProviderLabel;
    private Combo networkProviderCombo;
    private Properties connProperties;
    private Set<IChangeListener> listeners = new HashSet<IChangeListener>();

    public LdapSettingsWidget(Composite parent, int style, Properties connProperties) {
        super(parent, style);
        this.connProperties = connProperties;
        this.createComposite();
    }

    public String getTitle() {
        return DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Label", new Object[0]);
    }

    private void setProperty(String key, String value) {
        this.connProperties.setProperty(key, value);
    }

    private void setUrl() {
        String host = this.hostText.getText();
        int port = this.portSpinner.getSelection();
        String encMethod = this.encMethodCombo.getText();
        String ldapScheme = "ldap://";
        if (host.isEmpty()) {
            return;
        }
        if (encMethod.equals(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Encryption.UseSSLEncryption", new Object[0]))) {
            ldapScheme = "ldaps://";
        }
        String ldapUrl = String.valueOf(ldapScheme) + host + ":" + port;
        this.setProperty("LdapHost", host);
        this.setProperty("LdapPort", Integer.toString(port));
        this.setProperty("LdapScheme", ldapScheme);
        this.setProperty("LdapUrl", ldapUrl);
        this.urlText.setText(ldapUrl);
    }

    private void addListeners() {
        this.hostText.addListener(24, (Listener)this);
        this.portSpinner.addListener(24, (Listener)this);
        this.encMethodCombo.addListener(24, (Listener)this);
        this.networkProviderCombo.addListener(24, (Listener)this);
    }

    private void notifyListeners() {
        for (IChangeListener listener : this.listeners) {
            listener.stateChanged((IChangeNotifier)this);
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.hostText || event.widget == this.portSpinner || event.widget == this.encMethodCombo) {
            this.setUrl();
        }
        if (event.widget == this.networkProviderCombo) {
            this.setProperty("NetworkProvider", "JNDI (Java Naming and Directory Interface)");
            this.setProperty("LdapContextFactory", LDAPConnectionFactory.getDefaultLdapContextFactory());
        }
        this.notifyListeners();
    }

    private void initControls() {
        if (this.connProperties.get("LdapUrl") != null) {
            String url = this.connProperties.getProperty("LdapUrl");
            try {
                LDAPUrl ldapUrl = new LDAPUrl(url);
                if ("ldaps://".equals(ldapUrl.getScheme())) {
                    this.encMethodCombo.select(1);
                } else if ("ldap://".equals(ldapUrl.getScheme())) {
                    this.encMethodCombo.select(0);
                }
                this.hostText.setText(ldapUrl.getHost());
                this.portSpinner.setSelection(ldapUrl.getPort());
            }
            catch (Exception exception) {}
            this.urlText.setText(url);
        }
        if (this.connProperties.get("LdapContextFactory") != null) {
            this.networkProviderCombo.setText(this.connProperties.getProperty("LdapContextFactory"));
        }
    }

    private void createComposite() {
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.scrolled = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.scrolled);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(this.scrolled);
        this.hostLabel = new Label(this.scrolled, 0);
        this.hostLabel.setText(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Host.Label", new Object[0]));
        this.hostLabel.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Host.Tooltip", new Object[0]));
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)this.hostLabel);
        this.hostText = new Text(this.scrolled, 2052);
        this.hostText.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Host.Tooltip", new Object[0]));
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.hostText);
        this.portLabel = new Label(this.scrolled, 0);
        this.portLabel.setText(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Port.Label", new Object[0]));
        this.portLabel.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Port.Tooltip", new Object[0]));
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)this.portLabel);
        this.portSpinner = new Spinner(this.scrolled, 0);
        this.portSpinner.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Port.Tooltip", new Object[0]));
        this.portSpinner.setMinimum(1);
        this.portSpinner.setMaximum(65535);
        this.portSpinner.setSelection(389);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.portSpinner);
        this.encMethodLabel = new Label(this.scrolled, 0);
        this.encMethodLabel.setText(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Encryption.Label", new Object[0]));
        this.encMethodLabel.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Encryption.Tooltip", new Object[0]));
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)this.portLabel);
        this.encMethodCombo = new Combo(this.scrolled, 2060);
        this.encMethodCombo.setItems(this.encMethods);
        this.encMethodCombo.select(0);
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.encMethodCombo);
        this.urlLabel = new Label(this.scrolled, 0);
        this.urlLabel.setText(DatatoolsUiConstants.UTIL.getString("Common.URL.Label", new Object[0]));
        this.urlLabel.setToolTipText(DatatoolsUiConstants.UTIL.getString("Common.URL.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)this.urlLabel);
        this.urlText = new Text(this.scrolled, 2056);
        this.urlText.setEnabled(false);
        this.urlText.setToolTipText(DatatoolsUiConstants.UTIL.getString("Common.URL.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.urlText);
        this.networkProviderLabel = new Label(this.scrolled, 0);
        this.networkProviderLabel.setText(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Provider.Label", new Object[0]));
        this.networkProviderLabel.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Provider.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)this.networkProviderLabel);
        String[] networkProviders = new String[]{"JNDI (Java Naming and Directory Interface)"};
        this.networkProviderCombo = new Combo(this.scrolled, 2060);
        this.networkProviderCombo.setItems(networkProviders);
        this.networkProviderCombo.select(0);
        this.networkProviderCombo.setEnabled(false);
        this.setProperty("NetworkProvider", "JNDI (Java Naming and Directory Interface)");
        this.setProperty("LdapContextFactory", LDAPConnectionFactory.getDefaultLdapContextFactory());
        this.networkProviderCombo.setToolTipText(DatatoolsUiConstants.UTIL.getString("LdapSettingsWidget.Provider.ToolTip", new Object[0]));
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.networkProviderCombo);
        this.addListeners();
        this.initControls();
    }

    public void addChangeListener(IChangeListener theListener) {
        this.listeners.add(theListener);
    }

    public void removeChangeListener(IChangeListener theListener) {
        this.listeners.remove(theListener);
    }
}

