/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ldap;

import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.datatools.profiles.ldap.LdapConnectionProfileWizard;
import org.teiid.designer.datatools.profiles.ldap.widget.LdapSettingsWidget;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;

public class LdapProfileDetailsWizardPage
extends ConnectionProfileDetailsPage
implements DatatoolsUiConstants,
IChangeListener {
    private LdapSettingsWidget settingsWidget;

    public LdapProfileDetailsWizardPage(String pageName) {
        super(pageName, UTIL.getString("LdapProfileDetailsWizardPage.Name", new Object[0]), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.teiid.designer.datatools.ui", (String)"icons/ldap.gif"));
    }

    public void createCustomControl(Composite parent) {
        this.settingsWidget = new LdapSettingsWidget(parent, 0, ((LdapConnectionProfileWizard)this.getWizard()).getProfileProperties());
        this.settingsWidget.addChangeListener(this);
        this.setPingButtonVisible(false);
        this.setAutoConnectOnFinishDefault(false);
        this.setPingButtonEnabled(false);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateState();
    }

    void updateState() {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        this.setErrorMessage(null);
        if (properties.get("LdapUrl") == null || properties.get("LdapUrl").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("LdapProfileDetailsWizardPage.Url.Error.Message", new Object[0]));
            this.setPingButtonEnabled(false);
            return;
        }
        if (properties.get("LdapContextFactory") == null || properties.get("LdapContextFactory").toString().isEmpty()) {
            this.setErrorMessage(UTIL.getString("Common.Context.Factory.Error.Message", new Object[0]));
            this.setPingButtonEnabled(false);
            return;
        }
        this.setPageComplete(true);
        this.setPingButtonEnabled(true);
        this.setMessage(UTIL.getString("Click.Next.or.Finish", new Object[0]));
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateState();
    }

    public boolean canFlipToNextPage() {
        return this.internalComplete(super.canFlipToNextPage());
    }

    private boolean internalComplete(boolean complete) {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        if (complete && (properties.get("LdapUrl") == null || properties.get("LdapUrl").toString().isEmpty())) {
            complete = false;
        }
        if (complete && (properties.get("LdapContextFactory") == null || properties.get("LdapContextFactory").toString().isEmpty())) {
            complete = false;
        }
        return complete;
    }

    public void testConnection() {
        super.testConnection();
    }

    public List getSummaryData() {
        Properties properties = ((NewConnectionProfileWizard)this.getWizard()).getProfileProperties();
        List result = super.getSummaryData();
        result.add(new String[]{UTIL.getString("Common.URL.Label", new Object[0]), properties.getProperty("LdapUrl")});
        result.add(new String[]{UTIL.getString("LdapSettingsWidget.Provider.Label", new Object[0]), "JNDI (Java Naming and Directory Interface)"});
        result.add(new String[]{UTIL.getString("LdapSettingsWidget.CtxFactory.Label", new Object[0]), properties.getProperty("LdapContextFactory")});
        return result;
    }
}

