/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.ui.editors.MedEditorPage;
import org.teiid.designer.extension.ui.editors.MedSelectionProvider;
import org.teiid.designer.extension.ui.editors.ModelExtensionDefinitionEditor;
import org.teiid.designer.extension.ui.model.MedModelNode;

public class MedSelectionSynchronizer
implements ISelectionChangedListener,
PropertyChangeListener {
    private IStructuredSelection currentSelection = StructuredSelection.EMPTY;
    private final ModelExtensionDefinitionEditor medEditor;
    private ModelExtensionDefinition med;
    private MedModelNode medNode;
    private final List<MedSelectionProvider> selectionProviders = new ArrayList<MedSelectionProvider>(5);

    public MedSelectionSynchronizer(ModelExtensionDefinitionEditor medEditor) {
        this.medEditor = medEditor;
        this.setMed(this.medEditor.getMed());
    }

    public boolean addSelectionProvider(MedSelectionProvider selectionProvider) {
        boolean added = false;
        if (!this.selectionProviders.contains(selectionProvider) && (added = this.selectionProviders.add(selectionProvider))) {
            selectionProvider.addSelectionChangedListener(this);
            selectionProvider.setSelection((ISelection)this.currentSelection);
        }
        return added;
    }

    public void dispose() {
        for (MedSelectionProvider selectionProvider : this.selectionProviders) {
            selectionProvider.removeSelectionChangedListener(this);
        }
    }

    public MedModelNode getDescriptionNode() {
        return this.getMedModelNode().getDescriptionNode();
    }

    public MedModelNode getMedModelNode() {
        return this.medNode;
    }

    public MedModelNode getMetaclassNode(String metaclass) {
        return this.getMedModelNode().getMetaclassNode(metaclass);
    }

    public MedModelNode getMetamodelUriNode() {
        return this.getMedModelNode().getMetamodelUriNode();
    }

    public MedModelNode getModelTypesNode() {
        return this.getMedModelNode().getModelTypesNode();
    }

    public MedModelNode getNamespacePrefixNode() {
        return this.getMedModelNode().getNamespacePrefixNode();
    }

    public MedModelNode getNamespaceUriNode() {
        return this.getMedModelNode().getNamespaceUriNode();
    }

    public MedModelNode getPropertyDefinitionNode(String metaclass, ModelExtensionPropertyDefinition propDefn) {
        return this.getMedModelNode().getPropertyDefinitionNode(metaclass, propDefn);
    }

    public IStructuredSelection getSelection() {
        return this.currentSelection;
    }

    public MedModelNode getVersionNode() {
        return this.getMedModelNode().getVersionNode();
    }

    private boolean isSynchronized() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.medNode = MedModelNode.createMedNode(this.med);
        for (MedSelectionProvider selectionProvider : this.selectionProviders) {
            selectionProvider.refresh();
        }
    }

    public boolean removeSelectionProvider(MedSelectionProvider selectionProvider) {
        boolean removed = this.selectionProviders.remove(selectionProvider);
        if (removed) {
            selectionProvider.removeSelectionChangedListener(this);
        }
        return removed;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isSynchronized()) {
            MedSelectionProvider source = (MedSelectionProvider)event.getSelectionProvider();
            ISelection newSelection = event.getSelection();
            if (newSelection instanceof IStructuredSelection) {
                this.currentSelection = (IStructuredSelection)newSelection;
                for (MedSelectionProvider selectionProvider : this.selectionProviders) {
                    if (selectionProvider == source || !selectionProvider.isApplicable(this.currentSelection)) continue;
                    selectionProvider.setSelection(newSelection);
                    MedEditorPage page = selectionProvider.getMedEditorPage();
                    if (page == null) break;
                    IWorkbenchPart part = this.medEditor.getSite().getPage().getActivePart();
                    this.medEditor.selectPage(page);
                    if (part == this.medEditor) break;
                    part.setFocus();
                    break;
                }
            }
        }
    }

    void setMed(ModelExtensionDefinition newMed) {
        if (this.med != null) {
            this.med.removeListener((PropertyChangeListener)this);
        }
        this.med = newMed;
        this.medNode = MedModelNode.createMedNode(this.med);
        this.med.addListener((PropertyChangeListener)this);
        for (MedSelectionProvider selectionProvider : this.selectionProviders) {
            selectionProvider.refresh();
        }
    }
}

